<?php

namespace App\Http\Livewire;

use Livewire\Component;
use App\Models\Nf;
use Carbon\Carbon;
use Illuminate\Support\Facades\DB;
use App\Services\DateRangeService;

class GraphMediaPedidoVeiculoJsComponent extends Component
{
    public $mediasPedidoMesAtual;

    public $datarange;
    public $idempresa;
    public $idveiculo;
    public $idcontrato;

   protected $listeners = ['filtersApplied' => 'onFilterUpdate'];

    public function mount()
    {
        $this->loadInitialData();
    }

    public function loadInitialData()
    {
        if (empty($this->datarange)) {
            $this->setInitialDateRange();
        }
        $this->loadData();
    }

    private function setInitialDateRange()
    {
        $dataInicio = Carbon::now()->startOfMonth()->format('d-m-Y');
        $dataFim = Carbon::now()->endOfMonth()->format('d-m-Y');
        $this->datarange = $dataInicio . ' até ' . $dataFim;
    }

    private function loadData()
    {
        $dates = DateRangeService::generateDateRange($this->datarange);
        $inicioMesAtual = '2024-01-01';
        $finalMesAtual = '2024-01-30';

         // Agora você pode chamar a função e obter as médias ordenadas
        $this->mediasPedidoMesAtual = $this->calcularCustoTotalPorVeiculo($dates['dataInicio'], $dates['dataFim']);
        //$this->mediasPedidoMesAtual = $this->calcularMediaPedidoPorVeiculo($inicioMesAtual, $finalMesAtual);

        $this->dispatchBrowserEvent('MediaPedidoVeiculoUpdated', [
            'mediasPedidoMesAtual' => $this->mediasPedidoMesAtual
        ]);

        // Exemplo de como exibir as médias de Pedido por veículo
    //    foreach ($mediasPedidoMesAtual as $idVeiculo => $mediaPedido) {
      //      echo "Veículo $idVeiculo: " . number_format($mediaPedido, 2, '.', '') . " km/l<br>";
      //  }

    }

    public function render()
    {
        return view('livewire.graph-media-pedido-veiculo-js-component', [
            'mediasPedidoMesAtual' => $this->mediasPedidoMesAtual
        ]);
    }

    function calcularCustoTotalPorVeiculo($inicio, $fim) {
        // Inicializa a consulta com condições básicas
        $sql = "
            SELECT
                n.idnf,
                ni.valoritem,
                n.idveiculo,
                v.placa as rotulo
            FROM nf n
            JOIN nfitem ni ON n.idnf = ni.idnf
            JOIN veiculo v on v.idveiculo = n.idveiculo
            WHERE not ni.idprodserv IN (20, 31)
            AND n.dataentrada BETWEEN ? AND ?
            AND n.saida = 'P'
            AND n.idprodservtipo = 2
            AND ni.qtd > 0";

        $bindings = [$inicio, $fim];

        // Adiciona condições de filtro se idempresa ou idveiculo forem fornecidos
        if (!empty($this->idempresa)) {
            $sql .= " AND n.idempresa = ?";
            $bindings[] = $this->idempresa;
        }

        if (!empty($this->idcontrato)) {
            $sql .= " AND EXISTS (
                SELECT 1
                FROM contratoveiculo cv
                WHERE cv.idveiculo = n.idveiculo
                AND cv.idcontrato = ?
            )";
            $bindings[] = $this->idcontrato;
        }

        if (!empty($this->idveiculo)) {
            $sql .= " AND n.idveiculo = ?";
            $bindings[] = $this->idveiculo;
        }

        $sql .= " ORDER BY n.idveiculo, n.dataentrada";

        // Executa a consulta
        $resultados = DB::select(DB::raw($sql), $bindings);

        // Estruturas para armazenar os custos por veículo
        $custosPorVeiculo = [];
        foreach ($resultados as $registro) {
            $idVeiculo = $registro->idveiculo;
            $valorItem = $registro->valoritem;
            $rotulo = $registro->rotulo; // Placa do veículo

            if (!isset($custosPorVeiculo[$idVeiculo])) {
                $custosPorVeiculo[$idVeiculo] = [
                    'rotulo' => $rotulo,
                    'custoTotal' => 0
                ];
            }

            // Acumula o valor do item no custo total do veículo
            $custosPorVeiculo[$idVeiculo]['custoTotal'] += $valorItem;
        }

        // Preparando dados para ordenação e exibição
        $custosTotaisPorVeiculo = [];
        foreach ($custosPorVeiculo as $idVeiculo => $info) {
            $custosTotaisPorVeiculo[] = [
                'id' => $idVeiculo,
                'rotulo' => $info['rotulo'],
                'valor' => $info['custoTotal']
            ];
        }

        // Ordena o array pelo custo total em ordem decrescente
        usort($custosTotaisPorVeiculo, function ($item1, $item2) {
            return $item2['valor'] <=> $item1['valor'];
        });

        // Retorna o vetor ordenado de custos totais por veículo
        return $custosTotaisPorVeiculo;
    }

    public function onFilterUpdate($filters)
    {
        $this->datarange = $filters['datarange'] ?? null;
        $this->idempresa = $filters['idempresa'] ?? null;
        $this->idveiculo = $filters['idveiculo'] ?? null;
        $this->idcontrato = $filters['idcontrato'] ?? null;
        $this->loadData();
//dd($this->datarange);
        $this->dispatchBrowserEvent('MediaPedidoVeiculoUpdated', [
            'mediasPedidoMesAtual' => $this->mediasPedidoMesAtual
        ]);
    }
}
