<?php

namespace App\Http\Livewire;

use Livewire\Component;
use App\Models\Nf;
use Carbon\Carbon;

class GraphVendaComponent extends Component
{
    public $vendasMesAtual;
    public $vendasMesPassado;
    public $totalVendasMesAtual;
    public $totalVendasMesPassado;
    public $percentualVendasMudanca;


    public function mount()
    {
        $inicioMesAtual = Carbon::now()->startOfMonth();
        $finalMesAtual = Carbon::now()->endOfMonth();
        
        $inicioMesPassado = Carbon::now()->subMonthNoOverflow()->startOfMonth();
        $finalMesPassado = Carbon::now()->subMonthNoOverflow()->endOfMonth();

        $this->vendasMesAtual = Nf::venda()
                                   ->whereBetween('dataentrada', [$inicioMesAtual, $finalMesAtual])
                                   ->get();

        $this->vendasMesPassado = Nf::venda()
                                     ->whereBetween('dataentrada', [$inicioMesPassado, $finalMesPassado])
                                     ->get();

        $this->totalVendasMesAtual = $this->vendasMesAtual->sum('valornf');
        $this->totalVendasMesPassado = $this->vendasMesPassado->sum('valornf');
        $this->percentualVendasMudanca = $this->totalVendasMesPassado > 0 
                                    ? (($this->totalVendasMesAtual - $this->totalVendasMesPassado) / $this->totalVendasMesPassado) * 100 
                                    : 0;
    }

    public function render()
    {
        return view('livewire.graph-venda-component', [
            'vendasMesAtual' => $this->vendasMesAtual,
            'vendasMesPassado' => $this->vendasMesPassado,
            'percentualVendasMudanca' => $this->percentualVendasMudanca,
            'totalVendasMesAtual' => $this->totalVendasMesAtual,
            'totalVendasMesPassado' => $this->totalVendasMesPassado           

        ]);
    }
}


