<?php

namespace App\Http\Livewire;

use Livewire\Component;
use App\Models\Nf;
use Carbon\Carbon;

class GraphVendaJsComponent extends Component
{
    public $vendasPorMesJs;
    public $GraficoVendasPorMesJs;

    public function mount()
    {
        $dadosMeses = collect();

        // Preenche os últimos 6 meses
        for ($i = 5; $i >= 0; $i--) {
            $mes = Carbon::now()->subMonths($i);
            $dadosMeses->push([
                'mes' => $mes->month,
                'ano' => $mes->year,
                'total' => 0
            ]);
        }

        // Consulta os dados
        $dadosConsulta = Nf::venda()
            ->selectRaw('MONTH(dataentrada) as mes, YEAR(dataentrada) as ano,  COALESCE(SUM(valornf), 0) as total')
            ->where('dataentrada', '>=', Carbon::now()->subMonths(6))
            ->groupBy('mes', 'ano')
            ->get();

        // Preenche os dados nos meses
        $dadosMeses->transform(function ($mes) use ($dadosConsulta) {
            foreach ($dadosConsulta as $dado) {
                if ($mes['mes'] == $dado->mes && $mes['ano'] == $dado->ano) {
                    $mes['total'] = $dado->total;
                    break;
                }
            }
            return $mes;
        });

        $this->vendasPorMesJs = $dadosMeses;

        $this->GraficoVendasPorMesJs = [
            'labels' => $dadosMeses->map(fn($mes) => "{$mes['mes']}/{$mes['ano']}")->toArray(),
            'data' => $dadosMeses->map(fn($mes) => $mes['total'])->toArray()
        ];
    }

    public function render()
    {
        return view('livewire.graph-venda-js-component', [
            'vendasPorMes' => $this->vendasPorMesJs,
            'GraficoVendasPorMesJs' => $this->GraficoVendasPorMesJs
        ]);
    }
}
