<?php

namespace App\Http\Livewire;

use Livewire\Component;
use App\Models\Nf;
use Carbon\Carbon;
use App\Services\DateRangeService;
use Illuminate\Support\Facades\DB;

class PedidoVeiculoComponent extends Component
{
    public $pedidosVeiculoMesAtual;
    public $pedidosVeiculoMesPassado;
    public $totalPedidosVeiculoMesAtual;
    public $totalPedidosVeiculoMesPassado;
    public $percentualPedidosVeiculoMudanca;

    public $datarange;
    public $idempresa;
    public $idveiculo;
    public $idcontrato;

    protected $listeners = ['filtersApplied' => 'onFilterUpdate'];

    public function mount()
    {
        $this->loadInitialData();
    }

    public function loadInitialData()
    {
        // Define o intervalo de datas inicial se nenhum datarange for fornecido
        if (empty($this->datarange)) {
            $this->setInitialDateRange();
        }
        $this->loadData(); // Carrega os dados após definir o intervalo de datas
    }

    private function setInitialDateRange()
    {
        $dataInicio = Carbon::now()->startOfMonth()->format('d-m-Y');
        $dataFim = Carbon::now()->format('d-m-Y');
        $this->datarange = $dataInicio . ' até ' . $dataFim;
    }


    private function loadData()
    {
        $dados = DateRangeService::generateDateRange($this->datarange);


        $queryAtual = Nf::pedido()
            ->join('nfitem', 'nfitem.idnf', '=', 'nf.idnf')
            ->whereNotIn('idprodserv', [20, 31])
            ->whereBetween('dataentrada', [$dados['dataInicio'], $dados['dataFim']])
            ->Where('idprodservtipo','=',2);


        if ($this->idempresa) {
            $queryAtual->where('nf.idempresa', $this->idempresa);
        }

        if (!empty($this->idcontrato)) {
            $queryAtual->whereExists(function ($subquery) {
                $subquery->select(DB::raw(1))
                    ->from('contratoveiculo as cv')
                    ->whereColumn('cv.idveiculo', 'nf.idveiculo')
                    ->where('cv.idcontrato', $this->idcontrato);
            });
        }

        if ($this->idveiculo) {
            $queryAtual->where('nf.idveiculo', $this->idveiculo);

        }

        $this->pedidosVeiculoMesAtual = $queryAtual->get();


        $this->totalPedidosVeiculoMesAtual = $this->pedidosVeiculoMesAtual->sum('valoritem');

    }

    public function render()
    {
        return view('livewire.pedido-veiculo-component', [
            'pedidosVeiculoMesAtual' => $this->pedidosVeiculoMesAtual,
            'totalPedidosVeiculoMesAtual' => $this->totalPedidosVeiculoMesAtual,
        ]);
    }

    public function onFilterUpdate($filters)
    {   //dd(1);
       // dd($filters['datarange'] );
        $this->datarange = $filters['datarange'] ?? null;
        $this->idempresa = $filters['idempresa'] ?? null;
        $this->idveiculo = $filters['idveiculo'] ?? null;
        $this->idcontrato = $filters['idcontrato'] ?? null;
       // dd($this->datarange);
        $this->loadData();
       // dd($this->GraficoCotacoesPorDiaJs);
        $this->dispatchBrowserEvent('livewire.pedido-veiculo-component', [
            'pedidosVeiculoMesAtual' => $this->pedidosVeiculoMesAtual,
            'totalPedidosVeiculoMesAtual' => $this->totalPedidosVeiculoMesAtual,
        ]);


    }
}
