<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;

class SingleSession
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure(\Illuminate\Http\Request): (\Illuminate\Http\Response|\Illuminate\Http\RedirectResponse)  $next
     * @return \Illuminate\Http\Response|\Illuminate\Http\RedirectResponse
     */
    public function handle($request, Closure $next)
    {
        if (Auth::check() && Auth::user()->idsession !== Session::getId()) {
            Auth::logout(); // Desconecta o usuário
            return redirect()->to('/sign-in')->with('error-session', 'Você foi desconectado porque sua conta foi acessada em outro dispositivo.<br>Por favor, faça login novamente para continuar.');
        }

        return $next($request);
    }
}
