<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Traits\HandlesFileUploads;
use App\Scopes\TenantScope;

class Agencia extends Model
{
    use HasFactory, HandlesFileUploads;

    const CREATED_AT = 'criadoem';
    const UPDATED_AT = 'alteradoem';

    protected $table = 'agencia';
    protected $primaryKey = 'idagencia';

    protected $fillable = [
        'idempresa',
        'nome',
        'padrao',
        'nagencia',
        'noperacao',
        'nconta',
        'gerente',
        'telefone',
        'status',
        'saldoinicial',
        'saldoatual',
        'chavepix'
    ];

    protected static function booted()
    {
        static::addGlobalScope(new TenantScope);
    }

    // Método para verificar se a coluna existe na tabela
    public static function hasColumn($column)
    {
        return in_array($column, (new static)->getFillable());
    }


    public function empresa()
    {
        return $this->hasOne(Empresa::class, 'idempresa', 'idempresa');
    }

    public function incrementarSaldoInicial($valor)
    {
        $this->saldoinicial = $valor + $this->saldoinicial;
        $this->save();
    }

    public function incrementarSaldo($valor)
    {
        if ($valor < 0) {
            throw new \InvalidArgumentException("O valor de incremento não pode ser negativo.");
        }

        $this->saldoatual += $valor; // Forma mais clara de incrementar
        $this->save();
    }

    public function decrementarSaldo($valor)
    {
        if ($valor < 0) {
            throw new \InvalidArgumentException("O valor de decremento não pode ser negativo.");
        }

        $this->saldoatual -= $valor; // Forma mais clara de decrementar
        $this->save();
    }

}
