<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Traits\HandlesFileUploads;
use App\Scopes\TenantScope;

class ContratoItem extends Model
{
    use HasFactory, HandlesFileUploads;

    const CREATED_AT = 'criadoem';
    const UPDATED_AT = 'alteradoem';

    protected $table = 'contratoitem';
    protected $primaryKey = 'idcontratoitem';
    protected $fillable = [
        'idcontrato',
        'idempresa',
        'idprodserv',
        'iditem',
        'item',
        'idgrupoitem',
        'idtipoitem',
        'qtd',
        'un',
        'valorun',
        'valoritem' 
    ];

    protected static function booted()
    {
        static::addGlobalScope(new TenantScope);
    }

     // Método para verificar se a coluna existe na tabela
     public static function hasColumn($column)
     {
         return in_array($column, (new static)->getFillable());
     }

    function prodserv()
    {
        return $this->hasOne(ProdutoServico::class, 'idprodserv', 'idprodserv');
    }

    function grupoitem()
    {
        return $this->hasOne(GrupoItem::class, 'idgrupoitem', 'idgrupoitem');
    }

    public function contrato()
    {
        return $this->belongsTo(Nf::class, 'idcontrato', 'idcontrato');
    }

}
