<?php

namespace App\Models;

use App\Scopes\TenantScope;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Plano extends Model
{
    use HasFactory;

    const CREATED_AT = 'criadoem';
    const UPDATED_AT = 'alteradoem';

    protected $table = 'planos';
    protected $primaryKey = 'idplano';
    protected $fillable = [
        'idprodserv',
        'idempresa',
        'nome',
        'valor',
        'status',
        'gratuito'
    ];

    protected static function booted()
    {
        static::addGlobalScope(new TenantScope);
    }

    public static function hasColumn($column)
    {
        return in_array($column, (new static)->getFillable());
    }

    public function empresa()
    {
        return $this->belongsTo(Empresa::class, 'idempresa', 'idempresa');
    }

    public function prodserv()
    {
        return $this->belongsTo(ProdutoServico::class, 'idprodserv', 'idprodserv');
    }
}
