<?php

namespace App\Models;

use App\Scopes\TenantScope;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PlanoFuncionalidade extends Model
{
    use HasFactory;

    const CREATED_AT = 'criadoem';
    const UPDATED_AT = 'alteradoem';

    protected $table = 'plano_funcionalidade';
    protected $primaryKey = 'idplanofuncionalidade';
    protected $fillable = [
        'idplano',
        'idfuncionalidade',
        'status',
        'qtd'
    ];

    protected static function booted()
    {
        static::addGlobalScope(new TenantScope);
    }

    public static function hasColumn($column)
    {
        return in_array($column, (new static)->getFillable());
    }

    public function funcionalidade()
    {
        return $this->belongsTo(Funcionalidade::class, 'idfuncionalidade', 'idfuncionalidade');
    }

    public function plano()
    {
        return $this->belongsTo(Plano::class, 'idplano', 'idplano');
    }
}
