<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use App\Traits\HandlesFileUploads;
use App\Scopes\TenantScope;

class TagTipo extends Model
{
    use HasFactory, HandlesFileUploads;

    const CREATED_AT = 'criadoem';
    const UPDATED_AT = 'alteradoem';

    protected $table = 'tagtipo';
    protected $primaryKey = 'idtagtipo';

    protected $fillable = [
        'idempresa',
        'tagtipo',
        'status',
        'criadopor',
        'alteradopor',

        // Parametros
        'marca',
        'modelo',
        'anofabricacao',
        'numeroserie',
        'altura',
        'largura',
        'comprimento',
        'peso',
        'material',
        'combustivel',
        'datamanutencao',
        'dataproximamanutencao',
        'garantia',
        'voltagem',
        'processador',
        'memoriaram',
        'cor',
        'sistemaoperacional',
    ];

    protected static function booted()
    {
        static::addGlobalScope(new TenantScope);
    }

    // Método para verificar se a coluna existe na tabela
    public static function hasColumn($column)
    {
        return in_array($column, (new static)->getFillable());
    }

    public function empresa() : BelongsTo
    {
        return $this->belongsTo(Empresa::class, 'idempresa', 'idempresa');
    }

    public function criador() : BelongsTo
    {
        return $this->belongsTo(User::class, 'criadopor', 'id');
    }
}
