<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Scopes\TenantScope;

class Tenant extends Model
{
    use HasFactory;

    const CREATED_AT = 'criadoem';
    const UPDATED_AT = 'alteradoem';

    protected $table = 'tenant';
    protected $primaryKey = 'idtenant';

    protected $fillable = [
        'nome',
        'status',
        'is_admin_tenant',
        'idpessoa',
        'tipo',
        'idplano'
    ];

    protected static function booted()
    {
        static::addGlobalScope(new TenantScope);
    }

     // Método para verificar se a coluna existe na tabela
     public static function hasColumn($column)
     {
         return in_array($column, (new static)->getFillable());
     }

    public function empresas()
    {
        return $this->hasMany(Empresa::class);
    }

    public function pessoa()
    {
        return $this->belongsTo(Pessoa::class, 'idpessoa', 'idpessoa');
    }

    public function plano()
    {
        return $this->belongsTo(Plano::class, 'idplano', 'idplano');
    }
}


