<?php

namespace App\Services;

use App\Models\NfItem;
use App\Models\Nf;

class EstoqueService
{
    public function calcularEstoqueAtual($idProdutoServico)
    {
        $quantidadeComprada = $this->getQuantidadeComprada($idProdutoServico);
        $quantidadePedida = $this->getQuantidadePedida($idProdutoServico);

        return $quantidadeComprada - $quantidadePedida;
    }

    private function getQuantidadeComprada($idProdutoServico)
    {
        return NfItem::join('nf', 'nfitem.idnf', '=', 'nf.idnf')
        ->where('nfitem.idprodserv', $idProdutoServico)
        ->where('nf.status', 'CONCLUÍDO')
        ->where('nf.tipo', 'D')
        ->sum('nfitem.qtd');
    }

    private function getQuantidadePedida($idProdutoServico)
    {
        return NfItem::join('nf', 'nfitem.idnf', '=', 'nf.idnf')
            ->where('nfitem.idprodserv', $idProdutoServico)
            ->where('nf.status', 'CONCLUÍDO')
            ->where('nf.tipo', 'C')
            ->sum('nfitem.qtd');
    }
}
?>