<?php

namespace App\Services;

use App\Models\Agencia;
use App\Models\NfParcela;
use Illuminate\Support\Facades\DB;

class NfParcelaService
{
    public function concluirParcela($nfParcela, bool $debito, bool $credito, $idagencia)
    {
        DB::transaction(function () use ($nfParcela, $debito, $credito, $idagencia) {
            // Verificar se a parcela é de débito
            if ($debito === true) {
                $this->processarDebito($nfParcela, $idagencia);
            }

            if ($credito === true) {
                $this->processarCredito($nfParcela, $idagencia);
            }
        });
    }

    private function processarDebito($nfParcela, $idagencia)
    {
        // Obter o saldo atual da agência antes da operação
        $saldoAtualAgencia = $this->obterSaldoAtualAgencia($idagencia);

        // Guardar o saldo atual da agência como saldo inicial da parcela
        $nfParcela->saldoinicial = $saldoAtualAgencia;

        // Calcular o novo saldo atual da parcela e da agência
        $nfParcela->saldoatual = $saldoAtualAgencia - $nfParcela->valor;

        // Atualizar o saldo da agência
        $this->atualizarSaldoAgencia($nfParcela, $idagencia);

        // Atualizar o registro da parcela
        $this->atualizarParcela($nfParcela);
    }

    private function processarCredito($nfParcela, $idagencia)
    {
        // Obter o saldo atual da agência antes da operação
        $saldoAtualAgencia = $this->obterSaldoAtualAgencia($idagencia);

        // Guardar o saldo atual da agência como saldo inicial da parcela
        $nfParcela->saldoinicial = $saldoAtualAgencia;

        // Calcular o novo saldo atual da parcela e da agência
        $nfParcela->saldoatual = $saldoAtualAgencia + $nfParcela->valor;

        $this->atualizarSaldoAgencia($nfParcela, $idagencia);

        // Atualizar o registro da parcela
        $this->atualizarParcela($nfParcela);
    }

    public function estornarParcela($nfParcela, bool $debito, bool $credito, $idagencia)
    {
        DB::transaction(function () use ($nfParcela, $debito, $credito, $idagencia) {
            // Verificar se a parcela é de débito
            if ($debito === true) {
                $this->reverterDebito($nfParcela, $idagencia);
            }

            // Verificar se a parcela é de crédito
            if ($credito === true) {
                $this->reverterCredito($nfParcela, $idagencia);
            }
        });
    }

    private function reverterDebito($nfParcela, $idagencia)
    {
        // Reverter a operação com base no saldo inicial e saldo atual armazenados
        $agencia = Agencia::find($idagencia);

        if (!$agencia) {
            throw new \Exception("Agência não encontrada PARA REVERTER DEBITO no ID: {$idagencia}");
        }

        // Reverter o saldo da agência ao estado anterior usando o saldo inicial da parcela
        $agencia->saldoatual = $nfParcela->saldoinicial;

        // Salvar o novo saldo da agência
        $agencia->save();

        // Limpar os valores de saldo da parcela para indicar que foi estornada
        $nfParcela->saldoinicial = null;
        $nfParcela->saldoatual = null;
        $nfParcela->save();
    }

    private function reverterCredito($nfParcela, $idagencia)
    {
        // Reverter a operação com base no saldo inicial e saldo atual armazenados
        $agencia = Agencia::find($idagencia);

        if (!$agencia) {
            throw new \Exception("Agência não encontrada PARA REVERTER CREDITO no ID: {$idagencia}");
        }

        // Reverter o saldo da agência ao estado anterior usando o saldo inicial da parcela
        $agencia->saldoatual = $nfParcela->saldoinicial;

        // Salvar o novo saldo da agência
        $agencia->save();

        // Limpar os valores de saldo da parcela para indicar que foi estornada
        $nfParcela->saldoinicial = null;
        $nfParcela->saldoatual = null;
        $nfParcela->save();
    }

    private function obterSaldoAtualAgencia($idagencia)
    {
        $agencia = Agencia::find($idagencia);

        if (!$agencia) {
            throw new \Exception("Agência não encontrada PARA OBTER SALDO ATUAL AGENCIA no ID: {$idagencia}");
        }

        return $agencia->saldoatual ?? 0;
    }

    private function atualizarSaldoAgencia($nfParcela, $idagencia)
    {
        $agencia = Agencia::find($idagencia);

        if (!$agencia) {
            throw new \Exception("Agência não encontrada PARA ATUALIZAR SALDO AGENCIA no ID: {$idagencia}");
        }

        // Atualizar o saldo atual da agência
        $agencia->saldoatual = $nfParcela->saldoatual;
        $agencia->save();
    }

    private function atualizarParcela($nfParcela)
    {
        // Supondo que você tenha um modelo para a tabela nfparcela
        $parcela = NfParcela::find($nfParcela->idnfparcela);

        if (!$parcela) {
            throw new \Exception("Parcela não encontrada para o ID: {$nfParcela->idnfparcela}");
        }

        $parcela->saldoinicial = $nfParcela->saldoinicial;
        $parcela->saldoatual = $nfParcela->saldoatual;
        $parcela->save();
    }
}
