<?php

namespace App\Services;

use GuzzleHttp\Client;

class PagarMeService
{
    private string $SECRET_API_KEY;
    private array $headers;

    public function __construct()
    {
        $this->SECRET_API_KEY = config('pagarme.api_key');
        $username = $this->SECRET_API_KEY;
        $password = '';
        $this->headers = [
            'Content-Type' => 'application/json',
            'Accept' => 'application/json',
            'Authorization' => 'Basic ' . base64_encode($username . ':' . $password),
        ];
    }

    public function createOrderCheckoutPagarme($data)
    {
        $client = new Client();

        $checkoutData = [
            'customer' => [
                'metadata' => [
                    'idnfparcela' => $data['idnfparcela'],
                    'idtenant' => $data['idtenant'],
                ],
                'address' => [
                    'country' => $data['pais'] ?? 'BR',
                    'state' => $data['estado'],
                    'city' => $data['cidade'],
                    'zip_code' => $data['cep'],
                    'line_1' => $data['logradouro'], // Padrão: Numero, rua, bairro
                ],
                'phones' => [
                    'home_phone' => [
                        'country_code' => $data['codigo_pais'] ?? '55',
                        'area_code' => $data['ddd'],
                        'number' => $data['celular'],
                    ],
                ],
                'name' => $data['nome'],
                'email' => $data['email'],
                'type' => $data['tipo_cliente'],
                'document' => $data['documento'],
                'document_type' => $data['tipo_documento'], // CPF, CNPJ ou PASSPORT
            ],
            'items' => [
                [
                    'amount' => $data['valor'], // Valor em centavos Ex.: 1000 = R$ 10,00
                    'quantity' => 1,
                    'code' => $data['idplano'],
                    'description' => $data['descricao'],
                ],
            ],
            'payments' => [
                [
                    'Pix' => [
                        'expires_in' => 2592000, // 30 dias
                    ],
                    'payment_method' => 'pix',
                    'amount' => $data['valor'], // Valor em centavos
                ],
            ]
        ];

        $response = $client->request(
            'POST',
            'https://api.pagar.me/core/v5/orders',
            [
                'headers' => $this->headers,
                'json' => $checkoutData,  // Serializa automaticamente para JSON
            ]
        );

        return (object) [
            'data' => json_decode($response->getBody()->getContents()),  // Extrai o corpo da resposta e decodifica JSON
            'status' => $response->getStatusCode(),  // Retorna o código de status HTTP
        ];
    }
}
