<?php

namespace App\Services;

use App\Models\Item;
use Illuminate\Http\Request;
use Carbon\Carbon;
use App\Http\Controllers\Admin\PedidoController;
use Illuminate\Support\Facades\Log;

use function PHPUnit\Framework\isNull;

class PedidoService
{

    protected $pedidoController; 

    public function __construct(PedidoController $pedidoController = null)
    {
        $this->pedidoController = $pedidoController;
    }


    public function sincronizaPedidoEvento($evento)
    {
        try {
           
              
            if ($evento->status === 'CONCLUÍDO') {
                //dd("idprodervtipo: ".$evento->eventotipo->prodserv->idprodservtipo);
                die($evento->eventotipo->idprodserv);
                if ((empty($evento->idobjeto)) && (empty($evento->objeto))) {
                  
                    $pedido = [
                        'idpessoa' => $evento->idcliente,
                        'idempresa' => $evento->idempresa,
                        'idprodervtipo' => $evento->eventotipo->prodserv->idprodservtipo,
                        'tipo' => 'C',
                        'saida' => 'V',
                        'dataemissao' => Carbon::now(),
                        'dataentrada' => Carbon::now(),
                        'idformapagamento' => 4,
                        'qtdparcela' => 1,
                        'status' => 'ATIVO',
                        'valornf' => $evento->eventotipo->prodserv->valorvenda,
                        'totalnf' => $evento->eventotipo->prodserv->valorvenda,
                        'datavencimento' => Carbon::now(),
                    ];
                    
                    $pedido = \App\Models\Nf::create($pedido);
                    dd($pedido->idnf);
                    $item = new \App\Models\NfItem(); // ou você pode instanciar o Item de outra forma, se necessário
                    $item->idnf = $pedido->idnf;
                    $item->idprodserv = $evento->eventotipo->idprodserv;
                    $item->qtd = 1;
                    $item->idempresa = $evento->idempresa;
                    $item->valorun = $evento->eventotipo->prodserv->valorvenda;
                    $item->valoritem = $evento->eventotipo->prodserv->valorvenda;
                    $item->save();

                    $evento->idobjeto = $pedido->idnf;
                    $evento->objeto = 'nf';
                    $evento->save();
            
                }
                $pedido = \App\Models\Nf::find($evento->idobjeto); 
                if ($pedido) {
                    if ($pedido->status != 'CONCLUÍDO'){
                        $pedido->status = 'CONCLUÍDO';
                        $pedido->save();

                        $this->pedidoController::geraNfParcelas($pedido);
                    }
                }else {
                    // O pedido não foi encontrado; manipule como necessário
                    // Ex: Logar o erro, etc.
                }
            }
        } catch (\Exception $e) {
            Log::error("Erro ao sincronizar pedido e evento: " . $e->getMessage());
        // Tratar exceções aqui
        }
    }
}