<?php

namespace App\Services;

use App\Models\TagRetira;

class TagRetiraService
{
    /**
     * Gera o próximo número sequencial para uma empresa.
     *
     * @param int $idempresa
     * @return string
     */
    public function get($idtag)
    {
        $tagsReservadas = TagRetira::where('idtag', $idtag)
            ->whereIn('status', ['RESERVADA', 'PENDENTE'])
            ->with('pessoa') // Carrega a relação com a tabela pessoa
            ->orderBy('criadoem')
            ->get();

        // Personaliza a estrutura do JSON caso necessário
        return response()->json([
            'data' => $tagsReservadas
        ]);
    }
}
