<?php

namespace App\Traits;

use App\Models\Upload;

trait HandlesFileUploads
{
    public static function bootHandlesFileUploads()
    {

        static::saving(function ($model) {

            if (request()->has('files')) {
               // dd('aqui1');
                foreach (request()->file('files') as $file) {
                    //dd('aqui');
                    $path = $file->store('uploads', 'public');
                    if(isset($model->idempresa)){
                            Upload::create([
                                'idtenant' => auth()->user()->idtenant,
                                'idempresa' => $model->idempresa,
                                'objeto' => get_class($model),
                                'idobjeto' => $model->getAttribute($model->getKeyName()),
                                'caminho' => $path,
                                'criadopor' => auth()->user()->name,
                                'criadoem' => now(),
                                'alteradopor' => auth()->user()->name,
                                'alteradoem' => now(),
                            ]);
                        }else{
                            Upload::create([
                                'idtenant' => auth()->user()->idtenant,
                                'objeto' => get_class($model),
                                'idobjeto' => $model->getAttribute($model->getKeyName()),
                                'caminho' => $path,
                                'criadopor' => auth()->user()->name,
                                'criadoem' => now(),
                                'alteradopor' => auth()->user()->name,
                                'alteradoem' => now(),
                            ]);
                        }
                }
            } else {
                //dd('erro');
            }
        });
        
    }

    public function uploads()
    {
        return $this->morphMany(Upload::class, 'objeto', 'objeto', 'idobjeto');
    }
}
