<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('produtos', function (Blueprint $table) {
            $table->id();
            $table->int('idprodservtipo');
            $table->foreign('idprodservtipo')->references('idprodservtipo')->on('prodservtipo');
            $table->int('idempresa');
            $table->foreign('idempresa')->references('idempresa')->on('empresa');
            $table->string('prodserv', 200);
            $table->string('status', 45);
            $table->decimal('valorcompra', 10, 2);
            $table->decimal('valorvenda', 10, 2);
            $table->decimal('estoque', 10, 2);
            $table->string('unidade', 15);
            $table->decimal('estoqueminimo', 10, 2);
            $table->string('email', 120);
            $table->string('telefone', 45);
            $table->string('celular', 45);
            $table->string('criadopor', 45);
            $table->string('alteradopor', 45);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('produtos');
    }
};
