<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('tipopessoa', function (Blueprint $table) {
            $table->id('idtipopessoa');
            $table->unsignedBigInteger('idempresa');
            $table->foreign('idempresa')->references('idempresa')->on('empresa');
            $table->string('tipopessoa', 100);
            $table->string('status', 45);
            $table->timestamp('criadoem')->useCurrent();
            $table->string('criadopor', 45)->nullable();
            $table->timestamp('alteradoem')->useCurrent();
            $table->string('alteradopor', 45)->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('tipo_pessoas');
    }
};
