<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('pessoa', function (Blueprint $table) {
            $table->id('idpessoa');
            $table->unsignedBigInteger('idempresa');
            $table->foreign('idempresa')->references('idempresa')->on('empresa');
            // TODO: criar modulo e tabela pra relacao para tipopessoa
            // $table->unsignedBigInteger('idtipopessoa');
            // $table->foreign('idtipopessoa')->references('idtipopessoa')->on('tipopessoa');
            $table->string('nome', 120)->nullable();
            $table->string('razaosocial', 120)->nullable();
            $table->string('cpfcnpj', 45)->nullable();
            $table->string('inscestadual', 45)->nullable();
            $table->string('cep', 45)->nullable();
            $table->string('endereco', 45)->nullable();
            $table->string('numero', 45)->nullable();
            $table->string('complemento', 45)->nullable();
            $table->string('bairro', 45)->nullable();
            $table->string('cidade', 45)->nullable();
            $table->string('estado', 45)->nullable();
            $table->string('datanascimento', 45)->nullable();
            $table->string('rg', 45)->nullable();
            $table->string('nomepai', 45)->nullable();
            $table->string('nomemae', 45)->nullable();
            $table->string('estadocivil', 45)->nullable();
            $table->string('cargo', 45)->nullable();
            $table->date('admissao')->nullable();
            $table->string('tipo', 25)->nullable()->default('cliente');
            $table->string('admissaomotivo', 45)->nullable();
            $table->date('demissao')->nullable();
            $table->string('demissaomotivo', 45)->nullable();
            $table->string('status', 45);
            $table->timestamp('criadoem')->useCurrent();
            $table->string('criadopor', 45)->nullable();
            $table->timestamp('alteradoem')->useCurrent();
            $table->string('alteradopor', 45)->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('pessoa');
    }
};
