<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('prodserv', function (Blueprint $table) {
            $table->id('idprodserv');
            $table->unsignedBigInteger('idprodservtipo');
            $table->foreign('idprodservtipo')->references('idprodservtipo')->on('prodservtipo');
            $table->unsignedBigInteger('idempresa');
            $table->foreign('idempresa')->references('idempresa')->on('empresa');
            $table->string('prodserv', 200);
            $table->string('status', 45);
            $table->decimal('valorcompra', 10, 2);
            $table->decimal('valorvenda', 10, 2);
            $table->decimal('estoque', 10, 2);
            $table->string('unidade', 15);
            $table->decimal('estoqueminimo', 10, 2);
            $table->string('email', 120);
            $table->string('telefone', 45);
            $table->string('celular', 45);
            $table->timestamp('criadoem')->useCurrent();
            $table->string('criadopor', 45)->nullable();
            $table->timestamp('alteradoem')->useCurrent();
            $table->string('alteradopor', 45)->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('prodserv');
    }
};
