<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('tagtipo', function (Blueprint $table) {
            $table->bigIncrements('idtagtipo'); // Campo idtagtipo com auto incremento e chave primária
            $table->unsignedBigInteger('idempresa'); // Chave estrangeira idempresa
            $table->string('tagtipo', 120); // Campo tagtipo
            $table->string('status', 45); // Campo status
            $table->timestamp('criadoem')->default(DB::raw('CURRENT_TIMESTAMP')); // Campo criadoem com valor default
            $table->string('criadopor', 45)->nullable(); // Campo criadopor, permite nulo
            $table->timestamp('alteradoem')->default(DB::raw('CURRENT_TIMESTAMP')); // Campo alteradoem com valor default
            $table->string('alteradopor', 45)->nullable(); // Campo alteradopor, permite nulo

            // Definindo a chave estrangeira
            $table->foreign('idempresa')->references('idempresa')->on('empresa')->onDelete('cascade');

            // Definindo índices
            $table->index('idempresa', 'tagtipo_idempresa_foreign');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        // Excluindo as chaves estrangeiras e índices
        Schema::table('tagtipo', function (Blueprint $table) {
            $table->dropForeign('tagtipo_idempresa_foreign');
            $table->dropIndex('tagtipo_idempresa_foreign');
        });

        Schema::dropIfExists('tagtipo');
    }
};
