<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('tagretira', function (Blueprint $table) {
            $table->bigIncrements('idtagretira'); // Campo idtagretira com auto incremento e chave primária
            $table->integer('idpessoa'); // Campo idpessoa
            $table->unsignedBigInteger('idempresa'); // Chave estrangeira idempresa
            $table->unsignedInteger('idtag')->nullable(); // Chave estrangeira idtag, permite nulo
            $table->date('datadevolucao')->nullable(); // Campo datadevolucao
            $table->string('status', 45); // Campo status
            $table->longText('observacao')->nullable(); // Campo observacao, permite nulo
            $table->timestamp('criadoem')->default(DB::raw('CURRENT_TIMESTAMP')); // Campo criadoem com valor default
            $table->string('criadopor', 45)->nullable(); // Campo criadopor, permite nulo
            $table->timestamp('alteradoem')->default(DB::raw('CURRENT_TIMESTAMP')); // Campo alteradoem com valor default
            $table->string('alteradopor', 45)->nullable(); // Campo alteradopor, permite nulo

            // Definindo a chave estrangeira
            $table->foreign('idempresa')->references('idempresa')->on('empresa')->onDelete('cascade');

            // Definindo índices
            $table->index('idempresa', 'tagretira_idempresa_foreign');
            $table->index('datadevolucao', 'data_devolucao');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        // Excluindo as chaves estrangeiras e índices
        Schema::table('tagretira', function (Blueprint $table) {
            $table->dropForeign('tagretira_idempresa_foreign');
            $table->dropIndex('data_devolucao');
        });

        Schema::dropIfExists('tagretira');
    }
};
