<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('agendas', function (Blueprint $table) {
            $table->id('idagenda');
            $table->unsignedBigInteger('idempresa');
            $table->unsignedBigInteger('idpessoa');
            $table->foreign('idempresa')->references('idempresa')->on('empresa');
            $table->foreign('idpessoa')->references('idpessoa')->on('pessoa');
            $table->string('nome');
            // Campos de dias dom_horainicio1, dom_horafim1, dom_horainicio2, dom_horafim2
            $table->string('dom_horainicio1', 5)->nullable();
            $table->string('dom_horafim1', 5)->nullable();
            $table->string('dom_horainicio2', 5)->nullable();
            $table->string('dom_horafim2', 5)->nullable();
            // Campos de dias seg_horainicio1, seg_horafim1, seg_horainicio2, seg_horafim2
            $table->string('seg_horainicio1', 5)->nullable();
            $table->string('seg_horafim1', 5)->nullable();
            $table->string('seg_horainicio2', 5)->nullable();
            $table->string('seg_horafim2', 5)->nullable();
            // Campos de dias ter_horainicio1, ter_horafim1, ter_horainicio2, ter_horafim2
            $table->string('ter_horainicio1', 5)->nullable();
            $table->string('ter_horafim1', 5)->nullable();
            $table->string('ter_horainicio2', 5)->nullable();
            $table->string('ter_horafim2', 5)->nullable();
            // Campos de dias qua_horainicio1, qua_horafim1, qua_horainicio2, qua_horafim2
            $table->string('qua_horainicio1', 5)->nullable();
            $table->string('qua_horafim1', 5)->nullable();
            $table->string('qua_horainicio2', 5)->nullable();
            $table->string('qua_horafim2', 5)->nullable();
            // Campos de dias qui_horainicio1, qui_horafim1, qui_horainicio2, qui_horafim2
            $table->string('qui_horainicio1', 5)->nullable();
            $table->string('qui_horafim1', 5)->nullable();
            $table->string('qui_horainicio2', 5)->nullable();
            $table->string('qui_horafim2', 5)->nullable();
            // Campos de dias sex_horainicio1, sex_horafim1, sex_horainicio2, sex_horafim2
            $table->string('sex_horainicio1', 5)->nullable();
            $table->string('sex_horafim1', 5)->nullable();
            $table->string('sex_horainicio2', 5)->nullable();
            $table->string('sex_horafim2', 5)->nullable();
            // Campos de dias sab_horainicio1, sab_horafim1, sab_horainicio2, sab_horafim2
            $table->string('sab_horainicio1', 5)->nullable();
            $table->string('sab_horafim1', 5)->nullable();
            $table->string('sab_horainicio2', 5)->nullable();
            $table->string('sab_horafim2', 5)->nullable();
            $table->string('tempo_agendamento', 5)->nullable();
            $table->boolean('agendamento_online')->default(false);
            $table->string('antecendencia_minima', 5)->nullable();
            $table->boolean('choque_horario')->default(false);
            $table->boolean('feriado')->default(false);
            $table->string('status');
            $table->timestamp('criadoem')->default(DB::raw('CURRENT_TIMESTAMP')); // Campo criadoem com valor default
            $table->string('criadopor', 45)->nullable(); // Campo criadopor, permite nulo
            $table->timestamp('alteradoem')->default(DB::raw('CURRENT_TIMESTAMP')); // Campo alteradoem com valor default
            $table->string('alteradopor', 45)->nullable(); // Campo alteradopor, permite nulo
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('agendas');
    }
};
