<meta name="csrf-token" content="{{ csrf_token() }}">
<div class="card mb-4">
    <div class="card-header p-0 position-relative mt-n4 mx-3 z-index-2">
        <div class="bg-gradient-primary shadow-primary border-radius-lg pt-4 pb-3">
            <h5 class="mx-3">Agências</h5>
        </div>
    </div>
    <div class="card-body ">
    {{-- Messagens da session --}}
        @include('partials.session-message')
        @if ($errors->any() || session('error'))
        <div class="row">
            <div class="col-sm-12">
                <div class="alert alert-danger">
                    <button type="button" class="close" data-dismiss="alert"
                            aria-label="Close">
                        <i class="tim-icons icon-simple-remove"></i>
                    </button>
                    <span>{{$errors->any() ? $errors->first() : session('error')}}</span>
                </div>
            </div>
        </div>
            @endif

        <div class="row">
            @if (isset($agencia))
            <div class="col-md-9 col-lg-9">
                <span class="badge badge-sm bg-light mb-3 text-dark"># <?=$agencia->idagencia;?></span>
            </div>
            <div class="col-md-3 col-lg-3">
                <span class="float-end badge badge-sm {{$bg_status}}"><?=$agencia->status;?></span>
            </div>
        @endif
        </div>
    </div>
</div>

<div class="d-flex gap-3 mb-4 w-100">
    <div class="col-md-6">
        <div class="card">
            <div class="card-header mb-0 pb-0">
                <div class="col-md-12 col-lg-12">
                    <h4 class="mb-3 bg-light">Dados Cadastrais</h4>
                    <p>Campos com <span class="text-danger">*</span> são obrigatórios</p>
                </div>
            </div>
            <div class="card-body">
                <div class="row">
                    {{-- Empresa --}}
                    <div class="col-4">
                        <div class="input-group input-group-static my-3">
                            <label class="ms-0">Empresa <span class="text-danger">*</span></label>
                            <select class="form-control" name="idempresa" required>
                                <option value="" disabled="disabled">- Selecionar -</option>
                                @if (isset($empresas))
                                    @foreach($empresas as $empresa)
                                        <option value="{{ $empresa->idempresa }}" {{ ((isset($agencia) && $empresa->idempresa == $agencia->empresa->idempresa) || (old('idempresa') == $empresa->idempresa)) ? 'selected' : '' }}>{{$empresa->razaosocial}}</option>
                                    @endforeach
                                @endif
                            </select>
                        </div>
                    </div>
                    {{-- Nome --}}
                    <div class="col-4">
                        <div class="input-group input-group-static my-3 {{ $errors->has('agencia') ? ' is-invalid' : '' }}">
                            <label>{{ __('Nome') }} <span class="text-danger">*</span></label>
                            <input class="form-control{{ $errors->has('agencia') ? ' is-invalid' : '' }}"
                            name="nome" id="input-nome" type="text"
                            required
                            value="{{ isset($agencia) ? $agencia->nome : old('nome') }}" placeholder="{{ __('Nome') }}"/>
                            @if ($errors->has('nome'))
                                <span id="nome-error" class="error text-danger"
                                    for="input-nome">{{ $errors->first('nome') }}</span>
                            @endif
                        </div>
                    </div>
                    {{-- N° da Agência --}}
                    <div class="col-4">
                        <div class="input-group input-group-static my-3 {{ $errors->has('nagencia') ? ' is-invalid' : '' }}">
                            <label>{{ __('N° da Agência') }}</label>
                            <input class="form-control {{ $errors->has('nagencia') ? ' is-invalid' : '' }}"
                            name="nagencia" id="input-nagencia" type="text"
                            required
                            value="{{ isset($agencia) ? $agencia->nagencia : old('nagencia') }}" placeholder="{{ __('N° da Agência') }}"/>
                            @if ($errors->has('nagencia'))
                                <span id="nagencia-error" class="error text-danger"
                                    for="input-nagencia">{{ $errors->first('nagencia') }}</span>
                            @endif
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="row">
                        {{-- N° da operação --}}
                        <div class="col-4">
                            <div class="input-group input-group-static my-3 {{ $errors->has('noperacao') ? ' is-invalid' : '' }}">
                                <label>{{ __('N° da operação') }}</label>
                                <input class="form-control{{ $errors->has('noperacao') ? ' is-invalid' : '' }}"
                                required
                                name="noperacao" id="input-noperacao" type="text"
                                value="{{ isset($agencia) ? $agencia->noperacao : old('noperacao') }}" placeholder="{{ __('N° da operação') }}"/>
                                @if ($errors->has('noperacao'))
                                    <span id="noperacao-error" class="error text-danger"
                                        for="input-noperacao">{{ $errors->first('noperacao') }}</span>
                                @endif
                            </div>
                        </div>
                        {{-- N° da conta --}}
                        <div class="col-4">
                            <div class="input-group input-group-static my-3 {{ $errors->has('nconta') ? ' is-invalid' : '' }}">
                                <label>{{ __('N° da conta') }}</label>
                                <input class="form-control {{ $errors->has('nconta') ? ' is-invalid' : '' }}"
                                required
                                name="nconta" id="input-nconta" type="text"
                                value="{{ isset($agencia) ? $agencia->nconta : old('nconta') }}" placeholder="{{ __('N° da conta') }}"/>
                                @if ($errors->has('nconta'))
                                    <span id="nconta-error" class="error text-danger"
                                        for="input-nconta">{{ $errors->first('nconta') }}</span>
                                @endif
                            </div>
                        </div>
                        {{-- Saldo Inicial --}}
                        <div class="col-4">
                            <div class="input-group input-group-static my-3 {{ $errors->has('saldoinicial') ? ' is-invalid' : '' }}">
                                <label>{{ __('Saldo Inicial') }} <span class="text-danger">*</span></label>
                                <input class="form-control {{ $errors->has('saldoinicial') ? ' is-invalid' : '' }}"
                                name="saldoinicial" id="input-saldoinicial" type="text"
                                value="{{ isset($agencia) ? $agencia->saldoinicial : old('saldoinicial') }}" placeholder="{{ __('Saldo Inicial') }}"/>
                                @if ($errors->has('saldoinicial'))
                                    <span id="saldoinicial-error" class="error text-danger"
                                        for="input-saldoinicial">{{ $errors->first('saldoinicial') }}</span>
                                @endif
                            </div>
                        </div>
                        {{-- Chaeve Pix --}}
                        <div class="col-6">
                            <div class="input-group input-group-static my-3 {{ $errors->has('chavepix') ? ' is-invalid' : '' }}">
                                <label>{{ __('Chave Pix') }}</label>
                                <input class="form-control {{ $errors->has('chavepix') ? ' is-invalid' : '' }}"
                                name="chavepix" id="input-chavepix" type="text"
                                value="{{ isset($agencia) ? $agencia->chavepix : old('chavepix') }}" placeholder="{{ __('Chave Pix') }}"/>
                                @if ($errors->has('chavepix'))
                                    <span id="chavepix-error" class="error text-danger"
                                        for="input-chavepix">{{ $errors->first('chavepix') }}</span>
                                @endif
                            </div>
                        </div>
                        {{-- Configurações --}}
                        <div class="col-6">
                            <label class="form-label">Configurações</label>
                            <div>
                                <div class="form-check form-switch mb-3 d-flex align-items-center gap-3">
                                    <input class="form-check-input" name="padrao" id="input-padrao" type="checkbox"
                                    value="1" {{ isset($agencia) && $agencia->padrao == 1 ? 'checked' : '' }}>
                                    <label class="form-check-label m-0" for="input-padrao">Agência Padrão</label>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="col-md-3">
        <div class="card">
            <div class="card-header mb-0 pb-0">
                <div class="col-md-12 col-lg-12">
                    <h4 class="mb-3 bg-light">Contatos</h4>
                </div>
            </div>
            <div class="card-body">
                <div class="row">
                    {{-- Gerente --}}
                    <div class="col-12">
                        <div class="input-group input-group-static my-3 {{ $errors->has('gerente') ? ' is-invalid' : '' }}">
                            <label>{{ __('Gerente') }}</label>
                            <input class="form-control{{ $errors->has('gerente') ? ' is-invalid' : '' }}"
                            required
                            name="gerente" id="input-gerente" type="text"
                            value="{{ isset($agencia) ? $agencia->gerente : old('gerente') }}" placeholder="{{ __('Gerente') }}"/>
                            @if ($errors->has('gerente'))
                                <span id="gerente-error" class="error text-danger"
                                    for="input-gerente">{{ $errors->first('gerente') }}</span>
                            @endif
                        </div>
                    </div>
                    {{-- Telefone --}}
                    <div class="col-12">
                        <div class="input-group input-group-static my-3 {{ $errors->has('telefone') ? ' is-invalid' : '' }}">
                            <label>{{ __('Telefone') }}</label>
                            <input class="form-control telefone {{ $errors->has('telefone') ? ' is-invalid' : '' }}"
                            required
                            name="telefone" id="input-telefone" type="text"
                            value="{{ isset($agencia) ? $agencia->telefone : old('telefone') }}" placeholder="{{ __('Telefone') }}"/>
                            @if ($errors->has('telefone'))
                                <span id="telefone-error" class="error text-danger"
                                    for="input-telefone">{{ $errors->first('telefone') }}</span>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>


{{-- Ordem --}}
{{-- <div class="col-4">
    <div class="input-group input-group-static my-3 {{ $errors->has('ord') ? ' is-invalid' : '' }}">
        <label>{{ __('Ordem') }}</label>
        <input class="form-control{{ $errors->has('ord') ? ' is-invalid' : '' }}"
        name="ord" id="input-ord" type="text"
        value="{{ isset($agencia) ? $agencia->ord : old('ord') }}" placeholder="{{ __('Ordem') }}"/>
        @if ($errors->has('ord'))
            <span id="ord-error" class="error text-danger"
                for="input-ord">{{ $errors->first('ord') }}</span>
        @endif
    </div>
</div> --}}
{{-- <div class="col-md-12 col-lg-6">
    <div class="row">

        <div class="col-4">
            <div class="input-group input-group-static my-3 {{ $errors->has('remessa') ? ' is-invalid' : '' }}">
                <label>{{ __('Remessa') }}</label>
                <input class="form-control{{ $errors->has('remessa') ? ' is-invalid' : '' }}"
                name="remessa" id="input-remessa" type="text"
                value="{{ isset($agencia) ? $agencia->remessa : old('remessa') }}" placeholder="{{ __('Remessa') }}"/>
                @if ($errors->has('remessa'))
                    <span id="remessa-error" class="error text-danger"
                        for="input-remessa">{{ $errors->first('remessa') }}</span>
                @endif
            </div>
        </div>

        <div class="col-4">
            <div class="input-group input-group-static my-3 {{ $errors->has('boleto') ? ' is-invalid' : '' }}">
                <label>{{ __('Boleto') }}</label>
                <input class="form-control{{ $errors->has('boleto') ? ' is-invalid' : '' }}"
                name="boleto" id="input-boleto" type="text"
                value="{{ isset($agencia) ? $agencia->boleto : old('boleto') }}" placeholder="{{ __('Boleto') }}"/>
                @if ($errors->has('boleto'))
                    <span id="boleto-error" class="error text-danger"
                        for="input-boleto">{{ $errors->first('boleto') }}</span>
                @endif
            </div>
        </div>

        <div class="col-4">
            <div class="input-group input-group-static my-3 {{ $errors->has('retornorm') ? ' is-invalid' : '' }}">
                <label>{{ __('Retorno') }}</label>
                <input class="form-control{{ $errors->has('retornorm') ? ' is-invalid' : '' }}"
                name="retornorm" id="input-retornorm" type="text"
                value="{{ isset($agencia) ? $agencia->retornorm : old('retornorm') }}" placeholder="{{ __('Retorno') }}"/>
                @if ($errors->has('retornorm'))
                    <span id="retornorm-error" class="error text-danger"
                        for="input-retornorm">{{ $errors->first('retornorm') }}</span>
                @endif
            </div>
        </div>
    </div>
</div> --}}

<div class="row">
    <div class="col-md-6">
        @include('partials.status', ['model' => $agencia ?? null])
    </div>
    @if(isset($agencia))
    <div class="col-md-6">
        @include('partials.upload', ['model' => $agencia])
    </div>
    @endif
</div>

<div class="card mb-4">
    <div class="card-footer ml-auto mr-auto">
        <button id="submit-button" type="submit" class="btn btn-success">{{ __((isset($agencia) ? 'Atualizar' : 'Adicionar').' Agência') }}</button>
        <a href="{{ route('admin.agencias.index') }}"
                   class="btn btn-light">{{ __('Voltar') }}</a>
        @if(isset($agencia))
        <a class="btn bg-gradient-dark" href="{{route('admin.agencias.create')}}"><i
                    class="material-icons text-sm">add</i>&nbsp;&nbsp;Novo Agência</a>
        @endif
    </div>
</div>
