<meta name="csrf-token" content="{{ csrf_token() }}">

<div class="card mb-4">
    <div class="card-header p-0 position-relative mt-n4 mx-3 z-index-2">
        <div class="bg-gradient-primary shadow-primary border-radius-lg pt-4 pb-3">
            <h5 class="mx-3">Agenda</h5>
        </div>
    </div>
    <div class="card-body ">
    {{-- Messagens da session --}}
        @include('partials.session-message')
        @if ($errors->any() || session('error'))
        <div class="row">
            <div class="col-sm-12">
                <div class="alert alert-danger">
                    <button type="button" class="close" data-dismiss="alert"
                            aria-label="Close">
                        <i class="tim-icons icon-simple-remove"></i>
                    </button>
                    <span>{{$errors->any() ? $errors->first() : session('error')}}</span>
                </div>
            </div>
        </div>
            @endif

        <div class="row">
            @if (isset($agenda))
            <div class="col-md-9 col-lg-9">
                <span class="badge badge-sm bg-light mb-3 text-dark"># <?=$agenda->idagenda;?></span>
            </div>
            <div class="col-md-3 col-lg-3">
                <span class="float-end badge badge-sm {{$bg_status}}"><?=$agenda->status;?></span>
            </div>
        @endif
        </div>
    </div>
</div>

<div class="row space-x-4 mb-4">
    <div class="col-md-5 space-y-4">
        <div class="card">
            <div class="card-header mb-0 pb-0">
                <div class="col-md-12 col-lg-12">
                    <h4 class="mb-3 bg-light">Dados Cadastrais</h4>
                    <p class="m-0 p-0">Campos com <span class="text-danger">*</span> são obrigatórios</p>
                </div>
            </div>
            <div class="card-body">
                <div class="row">
                    {{-- Ocultar pessoa --}}
                    <div class="col-6">
                        <div class="form-check form-switch d-flex align-items-center gap-3 mb-3">
                            <input class="form-check-input" {{ isset($agenda) && $agenda->idpessoa ? 'checked' : '' }} type="checkbox" role="switch" id="switchMostrarPessoa">
                            <label class="form-check-label m-0" for="switchMostrarPessoa">Colaborador</label>
                            <p class="m-0 p-0" data-bs-toggle="tooltip" data-bs-title="Permite que o cliente selecione o colaborador"><i class="fa fa-question-circle-o" aria-hidden="true"></i></p>
                        </div>
                    </div>
                    {{-- Agenda privada ou publica --}}
                    <div class="col-6">
                        <div class="form-check form-switch d-flex align-items-center gap-3 mb-3">
                            <input class="form-check-input" {{ isset($agenda) && $agenda->coletiva ? 'checked' : '' }} type="checkbox" name="coletiva" role="switch" id="switchColetiva">
                            <label class="form-check-label m-0" for="switchColetiva">Coletiva</label>
                            <p class="m-0 p-0" data-bs-toggle="tooltip" data-bs-title="Permite acesso a clientes e colaboradores"><i class="fa fa-question-circle-o" aria-hidden="true"></i></p>
                        </div>
                    </div>
                    {{-- Agendamento online --}}
                    <div class="col-6">
                        <div class="form-check form-switch d-flex align-items-center gap-3 mb-3">
                            <input class="form-check-input" {{ isset($agenda) && $agenda->online ? 'checked' : '' }} @checked(true) type="checkbox" name="online" role="switch" id="switchonline">
                            <label class="form-check-label m-0" for="switchonline">Online</label>
                            <p class="m-0 p-0" data-bs-toggle="tooltip" data-bs-title="Permite agendemantos externos e internos online"><i class="fa fa-question-circle-o" aria-hidden="true"></i></p>
                        </div>
                    </div>
                    {{-- Oculta choque de horários --}}
                    <div class="col-6">
                        <div class="form-check form-switch d-flex align-items-center gap-3 mb-3">
                            <input class="form-check-input" {{ isset($agenda) && $agenda->choquehorario ? 'checked' : '' }} type="checkbox" role="switch" id="switchchoque">
                            <label class="form-check-label m-0" for="switchchoque">Simultâneo</label>
                            <p class="m-0 p-0" data-bs-toggle="tooltip" data-bs-title="Permite mais de um agendamento para o mesmo horário"><i class="fa fa-question-circle-o" aria-hidden="true"></i></p>
                        </div>
                    </div>
                </div>
                <div class="row">
                    {{-- Nome --}}
                    <div class="col-6">
                        <div class="input-group input-group-static my-3">
                            <label class="ms-0">Nome <span class="text-danger">*</span></label>
                            <input class="form-control" type="text" name="nome" value="{{ isset($agenda) ? $agenda->nome : old('nome') }}" required>
                        </div>
                    </div>
                    {{-- Empresa --}}
                    <div class="col-6">
                        <div class="input-group input-group-static my-3">
                            <label class="ms-0">Empresa <span class="text-danger">*</span></label>
                            <select class="form-control" name="idempresa" required>
                                <option value="" disabled="disabled">- Selecionar -</option>
                                @if (isset($empresas))
                                    @foreach($empresas as $empresa)
                                        <option value="{{ $empresa->idempresa }}" {{ ((isset($agenda) && $empresa->idempresa == $agenda->empresa->idempresa) || (old('idempresa') == $empresa->idempresa)) ? 'selected' : '' }}>{{$empresa->razaosocial}}</option>
                                    @endforeach
                                @endif
                            </select>
                        </div>
                    </div>
                </div>
                <div class="row">
                    {{-- Tempo de agendamento --}}
                    <div class="col-6">
                        <div class="input-group input-group-static my-3">
                            <label for="tempo">Tempo de agendamento</label>
                            <input type="time" class="form-control" name="tempo" id="tempo" value="{{ isset($agenda) ? $agenda->tempo : old('tempo') }}" required>
                        </div>
                    </div>
                    {{-- Antecedencia Minima --}}
                    <div class="col-6">
                        <div class="input-group input-group-static my-3">
                            <label class="ms-0">Antecedencia mínima <span class="text-danger">*</span></label>
                            <select class="form-control" name="antecedenciaminima" required>
                                <option value="" disabled="disabled">- Selecionar -</option>
                                <option value="01:00:00" {{ isset($agenda) && $agenda->antecedenciaminima === '1' ? 'selected' : '' }}>1 hora</option>
                                <option value="02:00:00" {{ isset($agenda) && $agenda->antecedenciaminima === '2' ? 'selected' : '' }}>2 horas</option>
                                <option value="03:00:00" {{ isset($agenda) && $agenda->antecedenciaminima === '3' ? 'selected' : '' }}>3 horas</option>
                                <option value="04:00:00" {{ isset($agenda) && $agenda->antecedenciaminima === '4' ? 'selected' : '' }}>4 horas</option>
                                <option value="05:00:00" {{ isset($agenda) && $agenda->antecedenciaminima === '5' ? 'selected' : '' }}>5 horas</option>
                            </select>
                        </div>
                    </div>
                    {{-- Permitir choque de horários --}}
                    <div class="col-6 {{ isset($agenda) && $agenda->choquehorario ? '' : 'd-none' }}" id="containerChoque">
                        <div class="input-group input-group-static my-3">
                            <label for="choquehorario">Limite de choque de horários</label>
                            <select class="form-control" name="choquehorario"  id="choquehorario">
                                <option value="" {{ isset($agenda) && $agenda->choquehorario === null ? 'selected' : '' }}>Ilimitado</option>
                                <option value="1" {{ isset($agenda) && $agenda->choquehorario === 1 ? 'selected' : '' }}>1</option>
                                <option value="2" {{ isset($agenda) && $agenda->choquehorario === 2 ? 'selected' : '' }}>2</option>
                                <option value="3" {{ isset($agenda) && $agenda->choquehorario === 3 ? 'selected' : '' }}>3</option>
                                <option value="4" {{ isset($agenda) && $agenda->choquehorario === 4 ? 'selected' : '' }}>4</option>
                                <option value="5" {{ isset($agenda) && $agenda->choquehorario === 5 ? 'selected' : '' }}>5</option>
                                <option value="6" {{ isset($agenda) && $agenda->choquehorario === 6 ? 'selected' : '' }}>6</option>
                                <option value="7" {{ isset($agenda) && $agenda->choquehorario === 7 ? 'selected' : '' }}>7</option>
                                <option value="8" {{ isset($agenda) && $agenda->choquehorario === 8 ? 'selected' : '' }}>8</option>
                                <option value="9" {{ isset($agenda) && $agenda->choquehorario === 9 ? 'selected' : '' }}>9</option>
                                <option value="10" {{ isset($agenda) && $agenda->choquehorario === 10 ? 'selected' : '' }}>10</option>
                            </select>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="col-md-7">
        <div class="card">
            <div class="card-header mb-0 pb-0">
                <div class="col-md-12 col-lg-12">
                    <h4 class="mb-3 bg-light">Horários</h4>
                </div>
            </div>
            <div class="card-body">
                <div class="row">
                    {{-- Colaborador --}}
                    <div class="col-6 {{ isset($agenda) && $agenda->idpessoa ? '' : 'd-none' }}" id="containerPessoa">
                        <div class="input-group input-group-static my-3">
                            <label class="ms-0">Colaborador <span class="text-danger">*</span></label>
                            <select class="form-control" name="idpessoa" id="idpessoa">
                                <option value="" disabled="disabled">- Selecionar -</option>
                                @if (isset($pessoas))
                                    @foreach($pessoas as $pessoa)
                                        <option value="{{ $pessoa->idpessoa }}" {{ ((isset($agenda->idpessoa) && $pessoa->idpessoa == $agenda->pessoa->idpessoa) || (old('idpessoa') == $pessoa->idpessoa)) ? 'selected' : '' }}>{{$pessoa->nome}}</option>
                                    @endforeach
                                @endif
                            </select>
                        </div>
                        <p>Selecione o colaborador para personalizar seu horário.</p>
                    </div>

                    {{-- Adicionar dias da semana e horários --}}
                    <div class="col-12">
                        <div class="table-responsive">
                            <table class="table table-hover table-striped table-bordered table-sm" style="font-size: .8rem;">
                                <thead>
                                    <th class="text-center align-middle"></th>

                                    <th class="text-center">
                                        <input type="checkbox" name="check-dom" id="check-dom"
                                        {{ empty($agenda->dom_horainicio1) && empty($agenda->dom_horafim1) &&
                                           empty($agenda->dom_horainicio2) && empty($agenda->dom_horafim2) ? '' : 'checked' }}> Dom
                                    </th>

                                    <th class="text-center">
                                        <input type="checkbox" name="check-seg" id="check-seg"
                                        {{ empty($agenda->seg_horainicio1) && empty($agenda->seg_horafim1) &&
                                           empty($agenda->seg_horainicio2) && empty($agenda->seg_horafim2) ? '' : 'checked' }}> Seg
                                    </th>

                                    <th class="text-center">
                                        <input type="checkbox" name="check-ter" id="check-ter"
                                        {{ empty($agenda->ter_horainicio1) && empty($agenda->ter_horafim1) &&
                                           empty($agenda->ter_horainicio2) && empty($agenda->ter_horafim2) ? '' : 'checked' }}> Ter
                                    </th>

                                    <th class="text-center">
                                        <input type="checkbox" name="check-qua" id="check-qua"
                                        {{ empty($agenda->qua_horainicio1) && empty($agenda->qua_horafim1) &&
                                           empty($agenda->qua_horainicio2) && empty($agenda->qua_horafim2) ? '' : 'checked' }}> Qua
                                    </th>

                                    <th class="text-center">
                                        <input type="checkbox" name="check-qui" id="check-qui"
                                        {{ empty($agenda->qui_horainicio1) && empty($agenda->qui_horafim1) &&
                                           empty($agenda->qui_horainicio2) && empty($agenda->qui_horafim2) ? '' : 'checked' }}> Qui
                                    </th>

                                    <th class="text-center">
                                        <input type="checkbox" name="check-sex" id="check-sex"
                                        {{ empty($agenda->sex_horainicio1) && empty($agenda->sex_horafim1) &&
                                           empty($agenda->sex_horainicio2) && empty($agenda->sex_horafim2) ? '' : 'checked' }}> Sex
                                    </th>

                                    <th class="text-center">
                                        <input type="checkbox" name="check-sab" id="check-sab"
                                        {{ empty($agenda->sab_horainicio1) && empty($agenda->sab_horafim1) &&
                                           empty($agenda->sab_horainicio2) && empty($agenda->sab_horafim2) ? '' : 'checked' }}> Sáb
                                    </th>
                                </thead>
                                <tbody>
                                    <tr class="text-center align-middle">
                                        <td>Entrada</td>
                                        <td><input type="time" name="dom_horainicio1" class="form-control form-control-sm time-input" value="{{ isset($agenda) ? $agenda->dom_horainicio1 : '08:00' }}" step="60" id="time-dom1"></td>
                                        <td><input type="time" name="seg_horainicio1" class="form-control form-control-sm time-input" value="{{ isset($agenda) ? $agenda->seg_horainicio1 : '08:00' }}" step="60" id="time-seg1"></td>
                                        <td><input type="time" name="ter_horainicio1" class="form-control form-control-sm time-input" value="{{ isset($agenda) ? $agenda->ter_horainicio1 : '08:00' }}" step="60" id="time-ter1"></td>
                                        <td><input type="time" name="qua_horainicio1" class="form-control form-control-sm time-input" value="{{ isset($agenda) ? $agenda->qua_horainicio1 : '08:00' }}" step="60" id="time-qua1"></td>
                                        <td><input type="time" name="qui_horainicio1" class="form-control form-control-sm time-input" value="{{ isset($agenda) ? $agenda->qui_horainicio1 : '08:00' }}" step="60" id="time-qui1"></td>
                                        <td><input type="time" name="sex_horainicio1" class="form-control form-control-sm time-input" value="{{ isset($agenda) ? $agenda->sex_horainicio1 : '08:00' }}" step="60" id="time-sex1"></td>
                                        <td><input type="time" name="sab_horainicio1" class="form-control form-control-sm time-input" value="{{ isset($agenda) ? $agenda->sab_horainicio1 : '08:00' }}" step="60" id="time-sab1"></td>
                                    </tr>
                                    <tr class="text-center align-middle">
                                        <td>Saida</td>
                                        <td><input type="time" name="dom_horafim1" class="form-control form-control-sm time-input" value="{{ isset($agenda) ? $agenda->dom_horafim1 : '12:00' }}" step="60" id="time-dom2"></td>
                                        <td><input type="time" name="seg_horafim1" class="form-control form-control-sm time-input" value="{{ isset($agenda) ? $agenda->seg_horafim1 : '12:00' }}" step="60" id="time-seg2"></td>
                                        <td><input type="time" name="ter_horafim1" class="form-control form-control-sm time-input" value="{{ isset($agenda) ? $agenda->ter_horafim1 : '12:00' }}" step="60" id="time-ter2"></td>
                                        <td><input type="time" name="qua_horafim1" class="form-control form-control-sm time-input" value="{{ isset($agenda) ? $agenda->qua_horafim1 : '12:00' }}" step="60" id="time-qua2"></td>
                                        <td><input type="time" name="qui_horafim1" class="form-control form-control-sm time-input" value="{{ isset($agenda) ? $agenda->qui_horafim1 : '12:00' }}" step="60" id="time-qui2"></td>
                                        <td><input type="time" name="sex_horafim1" class="form-control form-control-sm time-input" value="{{ isset($agenda) ? $agenda->sex_horafim1 : '12:00' }}" step="60" id="time-sex2"></td>
                                        <td><input type="time" name="sab_horafim1" class="form-control form-control-sm time-input" value="{{ isset($agenda) ? $agenda->sab_horafim1 : '12:00' }}" step="60" id="time-sab2"></td>
                                    </tr>
                                    <tr class="text-center align-middle">
                                        <td>Entrada</td>
                                        <td><input type="time" name="dom_horainicio2" class="form-control form-control-sm time-input" value="{{ isset($agenda) ? $agenda->dom_horainicio2 : '14:00' }}" step="60" id="time-dom3"></td>
                                        <td><input type="time" name="seg_horainicio2" class="form-control form-control-sm time-input" value="{{ isset($agenda) ? $agenda->seg_horainicio2 : '14:00' }}" step="60" id="time-seg3"></td>
                                        <td><input type="time" name="ter_horainicio2" class="form-control form-control-sm time-input" value="{{ isset($agenda) ? $agenda->ter_horainicio2 : '14:00' }}" step="60" id="time-ter3"></td>
                                        <td><input type="time" name="qua_horainicio2" class="form-control form-control-sm time-input" value="{{ isset($agenda) ? $agenda->qua_horainicio2 : '14:00' }}" step="60" id="time-qua3"></td>
                                        <td><input type="time" name="qui_horainicio2" class="form-control form-control-sm time-input" value="{{ isset($agenda) ? $agenda->qui_horainicio2 : '14:00' }}" step="60" id="time-qui3"></td>
                                        <td><input type="time" name="sex_horainicio2" class="form-control form-control-sm time-input" value="{{ isset($agenda) ? $agenda->sex_horainicio2 : '14:00' }}" step="60" id="time-sex3"></td>
                                        <td><input type="time" name="sab_horainicio2" class="form-control form-control-sm time-input" value="{{ isset($agenda) ? $agenda->sab_horainicio2 : '14:00' }}" step="60" id="time-sab3"></td>
                                    </tr>
                                    <tr class="text-center align-middle">
                                        <td>Saida</td>
                                        <td><input type="time" name="dom_horafim2" class="form-control form-control-sm time-input" value="{{ isset($agenda) ? $agenda->dom_horafim2 : '18:00' }}" step="60" id="time-dom4"></td>
                                        <td><input type="time" name="seg_horafim2" class="form-control form-control-sm time-input" value="{{ isset($agenda) ? $agenda->seg_horafim2 : '18:00' }}" step="60" id="time-seg4"></td>
                                        <td><input type="time" name="ter_horafim2" class="form-control form-control-sm time-input" value="{{ isset($agenda) ? $agenda->ter_horafim2 : '18:00' }}" step="60" id="time-ter4"></td>
                                        <td><input type="time" name="qua_horafim2" class="form-control form-control-sm time-input" value="{{ isset($agenda) ? $agenda->qua_horafim2 : '18:00' }}" step="60" id="time-qua4"></td>
                                        <td><input type="time" name="qui_horafim2" class="form-control form-control-sm time-input" value="{{ isset($agenda) ? $agenda->qui_horafim2 : '18:00' }}" step="60" id="time-qui4"></td>
                                        <td><input type="time" name="sex_horafim2" class="form-control form-control-sm time-input" value="{{ isset($agenda) ? $agenda->sex_horafim2 : '18:00' }}" step="60" id="time-sex4"></td>
                                        <td><input type="time" name="sab_horafim2" class="form-control form-control-sm time-input" value="{{ isset($agenda) ? $agenda->sab_horafim2 : '18:00' }}" step="60" id="time-sab4"></td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="card mt-4">
            <div class="card-header">
                <div class="col-md-12 col-lg-12">
                    <h4 class="bg-light d-flex align-items-center flex-row justify-content-between">
                        <span>Tipos de Agendamentos</span>
                        <span class="d-flex align-items-center gap-2">
                            <a style="float:right" class="insertRecord btn btn-info btn-sm m-0">+ adicionar item</a>
                        </span>
                    </h4>
                </div>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-12 col-lg-12">
                        <div class="table-responsive">
                            <table class="table table-hover table-striped table-bordered table-sm" id="tab_logic">
                                <thead>
                                    <tr class="info" style="font-size:14px;">
                                        <th class="th-sm">AÇÃO</th>
                                        <th class="w-50">TIPO</th>
                                        <th class="w-50">SERVIÇO</th>
                                        <th class="w-50">TEMPO</th>
                                        <th class="w-50">VALOR</th>
                                    </tr>
                                </thead>
                                <tbody class="resultbody">
                                    @if(isset($agenda) && !empty($agenda->agendaEventosTipos))
                                        @foreach ($agendaEventosTipos as $tipos)
                                            <tr>
                                                <td class="custom-tbl">
                                                    <a class="deleteRecord btn-sm text-danger material-icons text-sm me-2" style="cursor: pointer;">delete</a>
                                                </td>
                                                <td class="custom-tbl">
                                                    <select class="form-control input-sm select-evento" name="tiposevento[]">
                                                        @foreach ($eventoTipos as $tipo)
                                                            <option value="{{ $tipo->ideventotipo }}" {{ $tipos->ideventotipo == $tipo->ideventotipo ? 'selected' : '' }}>{{ $tipo->eventotipo }}</option>
                                                        @endforeach
                                                    </select>
                                                </td>
                                                <td class="custom-tbl">
                                                    <input type="text" readonly class="form-control form-control-sm" name="servico[]" value="{{ $tipos->eventoTipo->eventotipo }}">
                                                </td>
                                                <td class="custom-tbl">
                                                    <input type="text" readonly class="form-control form-control-sm" name="horapadrao[]" value="{{ $tipos->eventoTipo->horapadrao }}">
                                                </td>
                                                <td class="custom-tbl">
                                                    <input type="text" readonly class="form-control form-control-sm" name="valor[]" value="{{ $tipos->eventoTipo->prodserv->valorvenda }}">
                                                </td>
                                            </tr>
                                        @endforeach
                                    @endif
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="row">
    <div class="col-md-5">
        @include('partials.status', ['model' => $agenda ?? null])
    </div>
    @if(isset($agenda))
    <div class="col-md-6">
        @include('partials.upload', ['model' => $agenda])
    </div>
    @endif
</div>

<div class="card mb-4">
    <div class="card-footer ml-auto mr-auto">
        <button id="submit-button" type="submit" class="btn btn-success">{{ __((isset($agenda) ? 'Atualizar' : 'Adicionar').' Agenda') }}</button>
        <a href="{{ route('admin.agendas.index') }}"
                   class="btn btn-light">{{ __('Voltar') }}</a>
        @if(isset($agenda))
        <a class="btn bg-gradient-dark" href="{{route('admin.agendas.create')}}"><i
                    class="material-icons text-sm">add</i>&nbsp;&nbsp;Novo Agenda</a>
        @endif
    </div>
</div>

@push('js')
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
    $(document).ready(function() {
        function toggleDay(day) {
            const timeInputs = $('.time-input[name^="' + day + '_"]');
            const isChecked = $('#check-' + day).is(':checked');

            if (isChecked) {
                timeInputs.prop('disabled', false).removeClass(['bg-danger', 'text-light']);
            } else {
                timeInputs.prop('disabled', true).addClass(['bg-danger', 'text-light']).val(null);
            }
        }

        function initializeDays() {
            const days = ['dom', 'seg', 'ter', 'qua', 'qui', 'sex', 'sab'];

            days.forEach(function(day) {
                const timeInputs = $('.time-input[name^="' + day + '_"]');
                const hasValues = timeInputs.filter(function() { return $(this).val() !== ''; }).length > 0;

                $('#check-' + day).prop('checked', hasValues); // Marcar o checkbox se houver valores

                toggleDay(day); // Habilitar ou desabilitar os campos com base no checkbox
            });
        }

        function togglePessoa() {
            $('#containerPessoa').toggleClass('d-none', !$('#switchMostrarPessoa').is(':checked'));
            $('#idpessoa').val(null);
        }

        function toggleChoque() {
            $('#containerChoque').toggleClass('d-none', !$('#switchchoque').is(':checked'));
            $('#choquehorario').val(null);
        }

        // Inicializar os campos com base nos checkboxes e valores existentes
        initializeDays();

        // Usar um único evento para todos os checkboxes
        $('input[type="checkbox"][id^="check-"]').change(function() {
            const day = $(this).attr('id').replace('check-', '');
            toggleDay(day);
        });

        $('#switchMostrarPessoa').on('change', togglePessoa);
        $('#switchchoque').on('change', toggleChoque);
    });
</script>
<script>
    $(document).ready(function() {
        const eventoTipos = @json($eventoTipos);

        // Função para atualizar as informações relacionadas ao tipo de evento selecionado
        function handleTipoEventoChange() {
            const $select = $(this);
            const selectedTipoId = $select.val();

            if (!selectedTipoId) {
                $select.closest('tr').find('input[name="servico[]"]').val('');
                $select.closest('tr').find('input[name="horapadrao[]"]').val('');
                $select.closest('tr').find('input[name="valor[]"]').val('');
                return;
            }

            const selectedTipo = eventoTipos.find(tipo => tipo.ideventotipo == selectedTipoId);

            if (selectedTipo) {
                $select.closest('tr').find('input[name="servico[]"]').val(selectedTipo.prodserv ? selectedTipo.prodserv.prodserv : '');
                $select.closest('tr').find('input[name="horapadrao[]"]').val(selectedTipo.horapadrao);
                $select.closest('tr').find('input[name="valor[]"]').val(selectedTipo.prodserv ? selectedTipo.prodserv.valorvenda : '');
            } else {
                $select.closest('tr').find('input').val('');
            }
        }

        function updateOptions() {
            var selectedValues = [];

            // Captura os valores atualmente selecionados em todos os selects
            $('.select-evento').each(function() {
                var val = $(this).val();
                if (val) {
                    selectedValues.push(val);
                }
            });

            // Atualiza os selects, desabilitando as opções que já foram escolhidas
            $('.select-evento').each(function() {
                var select = $(this);
                select.find('option').each(function() {
                    var optionValue = $(this).val();

                    // Desabilita a opção se ela já foi selecionada em outro select
                    if (selectedValues.includes(optionValue) && optionValue !== select.val()) {
                        $(this).attr('disabled', true);
                    } else {
                        $(this).attr('disabled', false);
                    }
                });
            });
        }

        // Aplica o evento 'change' para os selects que já foram renderizados
        $('#tab_logic tbody').find('.select-evento').on('change', function() {
            updateOptions();
            handleTipoEventoChange.call(this);
        });

        // Ao clicar no botão de inserir uma nova linha
        $(".insertRecord").click(function() {
            var newRow = `
                <tr>
                    <td class="custom-tbl">
                        <a class="deleteRecord btn-sm text-danger material-icons text-sm me-2" style="cursor: pointer;">delete</a>
                    </td>
                    <td class="custom-tbl">
                        <select class="form-control input-sm select-evento" name="tiposevento[]">
                            <option value="">- Selecionar -</option>
                            ${eventoTipos.map(tipo =>
                                `<option value="${tipo.ideventotipo}">${tipo.eventotipo}</option>`
                            ).join('')}
                        </select>
                    </td>
                    <td class="custom-tbl">
                        <input type="text" readonly class="form-control form-control-sm" name="servico[]" value="">
                    </td>
                    <td class="custom-tbl">
                        <input type="text" readonly class="form-control form-control-sm" name="horapadrao[]" value="">
                    </td>
                    <td class="custom-tbl">
                        <input type="text" readonly class="form-control form-control-sm" name="valor[]" value="">
                    </td>
                </tr>
            `;

            // Adiciona a nova linha à tabela
            $('#tab_logic tbody').append(newRow);

            // Adiciona o listener de mudança ao select recém-adicionado
            $('#tab_logic tbody').find('tr:last-child').find('.select-evento').on('change', function () {
                updateOptions();
                handleTipoEventoChange.call(this);
            });

            // Atualiza as opções imediatamente após adicionar a nova linha
            updateOptions();
        });

        // Evento para remover a linha ao clicar no botão delete
        $(document).on('click', '.deleteRecord', function() {
            $(this).closest('tr').remove();
            updateOptions(); // Atualiza as opções após remover uma linha
        });
    });
</script>
@endpush
