<x-layout bodyClass="g-sidenag-sidenav-show  bg-dark-silkv-show  bg-gray-200">
    <x-navbars.sidebar activePage="clientes"></x-navbars.sidebar>
    <main class="main-content position-relative max-height-vh-100 h-100 border-radius-lg ">
        <!-- Navbar -->
        <x-navbars.navs.auth titlePage="Clientes"></x-navbars.navs.auth>
        <!-- End Navbar -->
        <div class="container-fluid py-4">
            <div class="row">
                <div class="col-12">
                    <div class="card my-4">
                        <div class="card-header p-0 position-relative mt-n4 mx-3 z-index-2">
                            <div class="bg-gradient-primary shadow-primary border-radius-lg pt-4 pb-3">
                                <h5 class="mx-3">Gerenciamento de Clientes</h5>
                            </div>
                        </div>
                        <div class="row m-0">
                            <div class="col-6 text-left">
                                <form action="{{ route('admin.clientes.search') }}" class="navbar-form d-flex align-items-center gap-3 mt-3"
                                    method="get">
                                    <div class="input-group input-group-outline d-flex align-items-center">
                                        <input type="text" name="search" class="form-control"
                                            placeholder="Buscar pelo nome do clientes..."
                                            value="{{ \Request::get('search') }}">
                                        <button type="submit" class="btn btn-primary btn-round btn-just-icon m-0">
                                            <i class="material-icons">search</i>
                                            <div class="ripple-container"></div>
                                        </button>
                                    </div>
                                    <div class="col-2">
                                        <select name="status" id="status-search" class="form-control border border-2 text-center" style="border-radius: 20px;">
                                            <option value="" disabled selected>Filtros</option>
                                            @foreach ($statusOptions as $status => $value)
                                                <option value="{{ $status }}">{{ $value }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                    <div class="col-3">
                                        <input type="checkbox" class="btn-check"  id="btn-check-inativo" autocomplete="off"
                                        {{ \Request::get('status') === 'INATIVO' ? 'checked' : '' }}>
                                        <label class="btn btn-outline-info shadow-sm p-0 m-0 pt-2 pb-2 ps-4 pe-4" style="text-transform: none; border-radius: 20px; font-size: .9rem" for="btn-check-inativo"><i class="fa fa-times-circle-o" aria-hidden="true"></i> Inativo <i class="fa fa-times ps-3 {{ \Request::get('status') === 'INATIVO' ? '' : 'd-none' }}" style="font-weight: 600;" id="btn-check-hide" aria-hidden="true"></i></label>
                                    </div>
                                </form>
                            </div>
                            <div class="col-6 my-3 text-end">
                                <a class="btn bg-gradient-dark mb-0" href="{{ route('admin.clientes.create') }}"><i
                                        class="material-icons text-sm">add</i>&nbsp;&nbsp;Adicionar cliente</a>
                            </div>
                        </div>
                        <div class="card-body px-0 pb-2">
                            {{-- Messagens da session --}}
                            @include('partials.session-message')
                            <div class="table-responsive p-0">
                                <table class="table align-items-center mb-0">
                                    <thead>
                                        <tr>
                                            <th
                                                class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                                ID
                                            </th>
                                            <th
                                                class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                                Empresa
                                            </th>
                                            <th
                                                class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                                Nome
                                            </th>
                                            <th
                                                class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                                Razão Social
                                            </th>
                                            <th
                                                class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                                CPF / Cnpj
                                            </th>
                                            <th
                                                class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                                Status
                                            </th>

                                            <th class="text-secondary opacity-7 d-none"></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach ($clientes as $cliente)
                                            <tr data-url="{{route('admin.clientes.edit', $cliente->idpessoa)}}" style="cursor: pointer;">
                                                <td>
                                                    <div class="d-flex px-2 py-1">
                                                        <div class="d-flex flex-column justify-content-center">
                                                            <p class="mb-0 text-sm">{{ $cliente->idpessoa }}</p>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>
                                                    <div class="d-flex px-2 py-1">
                                                        <div class="d-flex flex-column justify-content-center">
                                                            <p class="mb-0 text-sm">
                                                                {{ $cliente->empresa->sigla ?? 'Sem empresa' }}
                                                            </p>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>
                                                    <div class="d-flex px-2 py-1">
                                                        <div class="d-flex flex-column justify-content-center">
                                                            <p class="mb-0 text-sm">{{ $cliente->nome }}</p>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>
                                                    <div class="d-flex px-2 py-1">
                                                        <div class="d-flex flex-column justify-content-center">
                                                            <p class="mb-0 text-sm">{{ $cliente->razaosocial }}</p>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>
                                                    <div class="d-flex px-2 py-1">
                                                        <div class="d-flex flex-column justify-content-center">
                                                            <p class="mb-0 text-sm">{{ $cliente->cpfcnpj }}</p>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td data-noclicked="true" class="pe-3">
                                                    <div class="progress mb-1" style="width: 100%;">
                                                        <div class="progress-bar {{ $cliente->status === 'ATIVO' ? 'bg-success' : ($cliente->status === 'POTENCIAL' ? 'bg-info' : ($cliente->status === 'SUSPENSO' ? 'bg-warning' : 'bg-danger' )) }}" role="progressbar" style="height: 10px; width: 25%;" data-iditem="{{ $cliente->idpessoa }}" data-status="INATIVO" data-bs-toggle="tooltip" data-bs-title="Inativo"></div>
                                                        <div class="progress-bar {{ $cliente->status === 'ATIVO' ? 'bg-success' : ($cliente->status === 'POTENCIAL' ? 'bg-info' : ($cliente->status === 'INATIVO' ? 'bg-secondary' : 'bg-warning')) }}" role="progressbar" style="height: 10px; width: 25%;" data-iditem="{{ $cliente->idpessoa }}" data-status="SUSPENSO" data-bs-toggle="tooltip" data-bs-title="Suspenso"></div>
                                                        <div class="progress-bar {{ $cliente->status === 'ATIVO' ? 'bg-success' : ($cliente->status === 'POTENCIAL' ? 'bg-info' : 'bg-secondary') }}" role="progressbar" style="height: 10px; width: 25%;" data-iditem="{{ $cliente->idpessoa }}" data-status="POTENCIAL" data-bs-toggle="tooltip" data-bs-title="Potencial"></div>
                                                        <div class="progress-bar {{ $cliente->status === 'ATIVO' ? 'bg-success' : 'bg-secondary' }}" role="progressbar" style="height: 10px; width: 25%;" data-iditem="{{ $cliente->idpessoa }}" data-status="ATIVO" data-bs-toggle="tooltip" data-bs-title="Ativo"></div>
                                                    </div>
                                                    <div>
                                                        <span id="status-{{ $cliente->idpessoa }}" style="font-size: .8rem; text-transform: capitalize">{{ Str::lower($cliente->status) }}</span>
                                                    </div>
                                                </td>
                                                <td class="align-middle text-center d-none">
                                                    <a rel="tooltip" class="btn btn-success btn-link"
                                                        href="{{ route('admin.clientes.edit', $cliente->idpessoa) }}"
                                                        data-original-title="" title="">
                                                        <i class="material-icons">edit</i>
                                                        <div class="ripple-container"></div>
                                                    </a>
                                                    <form
                                                        action="{{ route('admin.clientes.destroy', $cliente->idpessoa) }}"
                                                        class="d-inline" method="POST">
                                                        @csrf
                                                        @method('delete')
                                                        <button type="button" class="btn btn-danger btn-link"
                                                            data-original-title="" title=""
                                                            onclick="confirm('{{ __('Você tem certeza que deseja apagar esse cliente?') }}') ? this.parentElement.submit() : ''">
                                                            <i class="material-icons">close</i>
                                                            <div class="ripple-container"></div>
                                                        </button>
                                                    </form>
                                                </td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <x-footers.auth></x-footers.auth>
        </div>
    </main>
    <x-plugins></x-plugins>
</x-layout>
@include('partials.update-status-progress', ['route' => route('admin.clientes.update', ['cliente' => ':id']), 'redirect' => 0, 'options' => [
    'INATIVO' => 'bg-danger',
    'SUSPENSO' => 'bg-warning',
    'POTENCIAL' => 'bg-info',
    'ATIVO' => 'bg-success'
]])
@include('partials.filter-inativo', ['routeSearch' => route('admin.clientes.search'), 'routeIndex' => route('admin.clientes.index')])

