@push('css')
    {{-- Select2 --}}
    <link rel="stylesheet" href="{{ asset('assets/css/select2.min.css') }}">
@endpush
<meta name="csrf-token" content="{{ csrf_token() }}">
<?php

$opt = '';
if(isset($produtoServico)){
    foreach($produtoServico as $prod)
    {
            $opt .='<option value="'.$prod->idprodserv.'" data-unidade="'.$prod->unidade.'" data-valorcompra="'.$prod->valorcompra.'">'.htmlspecialchars($prod->prodserv).'</option>"';
    }
}


 $optveiculos = '';
if(isset($veiculos)){
    foreach($veiculos as $veiculo)
    {
            $optveiculos .='<option value="'.$veiculo->idveiculo.'">'.htmlspecialchars($veiculo->marca).'/'.htmlspecialchars($veiculo->modelo).' | '.htmlspecialchars($veiculo->placa).'</option>';
    }
}

?>
<div class="card mb-4">
    <div class="card-header p-0 position-relative mt-n4 mx-3 z-index-2">
        <div class="bg-gradient-primary shadow-primary border-radius-lg pt-4 pb-3">
            <h5 class="mx-3">Assinatura</h5>
        </div>
    </div>
    <div class="card-body ">
    {{-- Messagens da session --}}
        @include('partials.session-message')
        @if ($errors->any() || session('error'))
        <div class="row">
            <div class="col-sm-12">
                <div class="alert alert-danger">
                    <button type="button" class="close" data-dismiss="alert"
                            aria-label="Close">
                        <i class="tim-icons icon-simple-remove"></i>
                    </button>
                    <span>{{$errors->any() ? $errors->first() : session('error')}}</span>
                </div>
            </div>
        </div>
            @endif

        <div class="row">
            @if (isset($contrato))
            <div class="col-md-9 col-lg-9">
                <span class="badge badge-sm bg-light mb-3 text-dark"># <?=$contrato->idcontrato;?></span>
            </div>
            <div class="col-md-3 col-lg-3">
                <span class="float-end badge badge-sm {{$bg_status}}"><?=$contrato->status;?></span>
            </div>
        @endif
        </div>
    </div>
</div>
<div class="row">
    <div class="col-md-12">
        <div class="card mb-4">
            <div class="card-body ">
                <div class="row">
                    <div class="col-md-12 col-lg-12">
                        <h4 class="mb-3 bg-light">Dados Cadastrais</h4>
                    </div>
                    <div class="col-md-8 col-lg-8">
                        <div class="row">
                            {{-- Empresa --}}
                            <div class="col-12">
                                <div class="input-group input-group-static my-3">
                                    <label class="ms-0">Empresa</label>
                                    <select class="form-control" name="idempresa">
                                        <option value="">- Selecionar -</option>
                                    @foreach($empresas as $empresa)
                                        <option value="{{ $empresa->idempresa }}" {{ ((isset($contrato) && $empresa->idempresa == $contrato->empresa->idempresa) || (old('idempresa') == $empresa->idempresa)) ? 'selected' : '' }}>{{$empresa->razaosocial}}</option>
                                    @endforeach
                                    </select>
                                </div>
                            </div>
                            {{-- Pessoa --}}
                            <div class="col-12">
                                <div class="input-group input-group-static my-3">
                                    <label class="ms-0">Cliente</label>
                                    <select class="form-control" name="idpessoa" required="true" aria-required="true" >
                                        <option value=''>Selecionar</option>
                                        @foreach($pessoas as $pessoa)
                                            <option value="{{ $pessoa->idpessoa }}" {{ ((isset($contrato) && ($pessoa->idpessoa && $pessoa->idpessoa == $contrato->pessoa->idpessoa)) || (old('idpessoa') == $pessoa->idpessoa)) ? 'selected' : '' }}>{{ $pessoa->razaosocial ?? $pessoa->nome }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-2 col-lg-2">
                        <div class="row">
                         {{-- Recorrência --}}
                            <div class="col-12">
                                <div class="input-group input-group-static my-3">
                                    <label class="ms-0">Compra/Venda</label>
                                    <select class="form-control" name="tipo" required="true" aria-required="true"
                                    @if (isset($pedido))
                                        disabled="disabled" readonly
                                    @endif>
                                        <option value="" disabled="disabled">- Selecionar -</option>
                                        <option value="D" {{ ((isset($contrato) && 'D' == $contrato->tipo) || (old('tipo') == 'D')) ? 'selected' : '' }}>Compra</option>
                                        <option value="C" {{ ((isset($contrato) && 'C' == $contrato->tipo) || (old('tipo') == 'C')) ? 'selected' : '' }}>Venda</option>
                                    </select>
                                </div>
                            </div>
                            {{-- Tipo de Produto e Serviço --}}
                            <div class="col-12">
                                <div class="input-group input-group-static my-3">
                                    <label class="ms-0">Tipo</label>
                                    <select class="form-control" name="idprodservtipo" required="true" aria-required="true"
                                    @if (isset($pedido))
                                        disabled="disabled" readonly
                                    @endif>
                                        <option value="" disabled="disabled">- Selecionar -</option>
                                        @foreach($tiposProdutoServico as $tipoProdutoServico)
                                            <option value="{{ $tipoProdutoServico->idprodservtipo }}" {{ ((isset($contrato) && $tipoProdutoServico->idprodservtipo == $contrato->idprodservtipo) || (old('idprodservtipo') == $tipoProdutoServico->idprodservtipo)) ? 'selected' : '' }}>{{$tipoProdutoServico->prodservtipo}}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-2 col-lg-2">
                        <div class="row">
                            <h6 class="text-uppercase text-body text-xs font-weight-bolder">Exibir Informações</h6>

                            {{-- Exibir dados do contrato --}}
                            <div class="col-12 my-3">
                                <div class="form-check form-switch d-flex align-items-center gap-3">
                                    <input class="form-check-input" {{ isset($contrato) && $contrato->mostracontrato ? 'checked' : '' }} name="mostracontrato" type="checkbox" role="switch" id="switchMostraContrato">
                                    <label class="form-check-label m-0" for="switchMostraContrato">Dados do contrato</label>
                                </div>
                            </div>
                            {{-- Exibir dados do endereço --}}
                            <div class="col-12 my-3">
                                <div class="form-check form-switch d-flex align-items-center gap-3">
                                    <input class="form-check-input" {{ isset($contrato) && $contrato->mostraendereco ? 'checked' : '' }} name="mostraendereco" type="checkbox" role="switch" id="switchMostraEndereco">
                                    <label class="form-check-label m-0" for="switchMostraEndereco">Endereço</label>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-{{ isset($contrato) && $contrato->mostracontrato == 1 ? '8' : '12' }}" id="col-recorrencia">
        <div class="card mb-4">
            <div class="card-body ">
                <div class="row">
                    <div class="col-md-12 col-lg-12">
                        <h4 class="mb-3 bg-light">Dados da Assinatura Recorrente</h4>
                    </div>
                </div>
                <div class="row">
                    {{-- Recorrência --}}
                    <div class="col-4">
                        <div class="input-group input-group-static my-3">
                            <label class="ms-0">Periodicidade</label>
                            <select class="form-control" name="recorrencia" required="true" aria-required="true"
                            @if (isset($pedido))
                                disabled="disabled" readonly
                            @endif>
                                <option value="" disabled="disabled">- Selecionar -</option>

                                <option value="mensal" {{ ((isset($contrato) && 'mensal' == $contrato->recorrencia) || (old('recorrencia') == 'mensal')) ? 'selected' : '' }}>Mensal</option>
                                <option value="trimestral" {{ ((isset($contrato) && 'trimestral' == $contrato->recorrencia) || (old('recorrencia') == 'trimestral')) ? 'selected' : '' }}>Trimestral</option>
                                <option value="semestral" {{ ((isset($contrato) && 'semestral' == $contrato->recorrencia) || (old('recorrencia') == 'semestral')) ? 'selected' : '' }}>Semestral</option>
                                <option value="anual" {{ ((isset($contrato) && 'anual' == $contrato->recorrencia) || (old('recorrencia') == 'anual')) ? 'selected' : '' }}>Anual</option>
                            </select>
                        </div>
                    </div>
                    {{-- Data Início --}}
                    <div class="col-4">
                        <div
                            class="input-group input-group-static my-3 {{ $errors->has('datainiciorecorrencia') ? ' is-invalid' : '' }}">
                            <label>{{ __('Data de Início da Cobrança') }}</label>
                            <input class="form-control {{ $errors->has('datainiciorecorrencia') ? ' is-invalid' : '' }}"
                                name="datainiciorecorrencia" id="input-datainiciorecorrencia" type="date"
                                value="{{ isset($contrato) ? $contrato->datainiciorecorrencia : old('datainiciorecorrencia') }}"
                                placeholder="{{ __('Data de Início') }}"/>
                            @if ($errors->has('datainiciorecorrencia'))
                                <span id="datainiciorecorrencia-error" class="error text-danger"
                                    for="input-datainiciorecorrencia">{{ $errors->first('datainiciorecorrencia') }}</span>
                            @endif
                        </div>
                    </div>

                    <div class="col-4">
                        <div
                            class="input-group input-group-static my-3 {{ $errors->has('datafimrecorrencia') ? ' is-invalid' : '' }}">
                            <label>{{ __('Data de Fim da Cobrança') }}</label>
                            <input class="form-control {{ $errors->has('datafimrecorrencia') ? ' is-invalid' : '' }}"
                                name="datafimrecorrencia" id="input-datafimrecorrencia" type="date"
                                value="{{ isset($contrato) ? Carbon\Carbon::parse($contrato->datafimrecorrencia)->format('Y-m-d') : old('datafimrecorrencia') }}"
                                placeholder="{{ __('Data de Início') }}"/>
                            @if ($errors->has('datafimrecorrencia'))
                                <span id="datafimrecorrencia-error" class="error text-danger"
                                    for="input-datafimrecorrencia">{{ $errors->first('datafimrecorrencia') }}</span>
                            @endif
                        </div>
                    </div>
                    <div class="col-4">
                        <div class="input-group input-group-static my-3 {{ $errors->has('numero') ? ' is-invalid' : '' }}">
                                <label>{{ __('Dia de Vencimento') }}</label>
                                <input class="form-control{{ $errors->has('numero') ? ' is-invalid' : '' }}"
                                    name="diavencimento" id="input-diavencimento" type="text"
                                    pattern="[0-9]*" inputmode="numeric"
                                    value="{{ isset($contrato) ? $contrato->diavencimento : old('diavencimento') }}" placeholder="{{ __('Dia de vencimento') }}"
                                    required="true" aria-required="true"/>
                                    @if ($errors->has('diavencimento'))
                                        <span id="diavencimento-error" class="error text-danger"
                                            for="input-diavencimento">{{ $errors->first('diavencimento') }}</span>
                                    @endif
                        </div>
                    </div>
                    <div class="col-4">
                        <div class="input-group input-group-static my-3 {{ $errors->has('numero') ? ' is-invalid' : '' }}">
                                <label>{{ __('Antecedência') }}</label>
                                <input class="form-control{{ $errors->has('numero') ? ' is-invalid' : '' }}"
                                    name="antecedencia" id="input-antecedencia" type="text"
                                    pattern="[0-9]*" inputmode="numeric"
                                    value="{{ isset($contrato) ? $contrato->antecedencia : old('antecedencia') }}" placeholder="{{ __('Nº Dias') }}"
                                    required="true" aria-required="true"/>
                                    @if ($errors->has('antecedencia'))
                                        <span id="antecedencia-error" class="error text-danger"
                                            for="input-antecedencia">{{ $errors->first('antecedencia') }}</span>
                                    @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-4" id="col-contrato" style="display: {{ isset($contrato) && $contrato->mostracontrato == 1 ? 'block' : 'none' }} }}">
        <div class="card mb-4">
            <div class="card-body ">
                <div class="row">
                    <div class="col-md-12 col-lg-12">
                        <h4 class="mb-3 bg-light">Dados do Contrato</h4>
                    </div>
                    <div class="col-md-12 col-lg-12">
                        <div class="row">
                            <div class="row">
                                {{-- Nome --}}
                                <div class="col-8">
                                    <div class="input-group input-group-static my-3 {{ $errors->has('nome') ? ' is-invalid' : '' }}">
                                        <label>{{ __('Nome do Contrato') }}</label>
                                        <input class="form-control nome {{ $errors->has('nome') ? ' is-invalid' : '' }}"
                                        name="nome" id="input-nome" type="text"
                                        value="{{ isset($contrato) ? $contrato->nome : old('nome') }}" placeholder="{{ __('Nome') }}"
                                        />
                                        @if ($errors->has('nome'))
                                            <span id="nome-error" class="error text-danger"
                                                for="input-nome">{{ $errors->first('nome') }}</span>
                                        @endif
                                    </div>
                                </div>
                                {{-- Valor do Contrato --}}
                                <div class="col-4">
                                    <div class="input-group input-group-static my-3 {{ $errors->has('valoracordocontrato') ? ' is-invalid' : '' }}">
                                        <label>{{ __('Valor Acordado') }}</label>
                                        <input class="form-control{{ $errors->has('valoracordocontrato') ? ' is-invalid' : '' }}"
                                        name="valoracordocontrato" id="input-valoracordocontrato" type="number"  step="any"
                                        value="{{ isset($contrato) ? $contrato->valoracordocontrato : old('valoracordocontrato') }}" placeholder="{{ __('R$') }}"
                                    />
                                        @if ($errors->has('valoracordocontrato'))
                                            <span id="valoracordocontrato-error" class="error text-danger"
                                                for="input-valoracordocontrato">{{ $errors->first('valoracordocontrato') }}</span>
                                        @endif
                                    </div>
                                </div>
                            </div>

                            {{-- Data Início --}}
                            <div class="col-4">
                                <div
                                    class="input-group input-group-static my-3 {{ $errors->has('datainicio') ? ' is-invalid' : '' }}">
                                    <label>{{ __('Data Início') }}</label>
                                    <input class="form-control {{ $errors->has('datainicio') ? ' is-invalid' : '' }}"
                                        name="datainicio" id="input-datainicio" type="date"
                                        value="{{ isset($contrato) ? $contrato->datainicio : old('datainicio') }}"
                                        placeholder="{{ __('Data de Início') }}"/>
                                    @if ($errors->has('datainicio'))
                                        <span id="datainicio-error" class="error text-danger"
                                            for="input-datainicio">{{ $errors->first('datainicio') }}</span>
                                    @endif
                                </div>
                            </div>
                            <div class="col-4">
                                <div
                                    class="input-group input-group-static my-3 {{ $errors->has('datafim') ? ' is-invalid' : '' }}">
                                    <label>{{ __('Data Entrega') }}</label>
                                    <input class="form-control {{ $errors->has('datafim') ? ' is-invalid' : '' }}"
                                        name="datafim" id="input-datafim" type="date"
                                        value="{{ isset($contrato) ? $contrato->datafim : old('datafim') }}"
                                        placeholder="{{ __('Prazo de Entrega') }}"  />
                                    @if ($errors->has('datafim'))
                                        <span id="datafim-error" class="error text-danger"
                                            for="input-datafim">{{ $errors->first('datafim') }}</span>
                                    @endif
                                </div>
                            </div>
                            {{-- Data Conclusão --}}
                            <div class="col-4">
                                <div
                                    class="input-group input-group-static my-3 {{ $errors->has('dataconclusao') ? ' is-invalid' : '' }}">
                                    <label>{{ __('Data Conclusão') }}</label>
                                    <input class="form-control {{ $errors->has('dataconclusao') ? ' is-invalid' : '' }}"
                                        name="dataconclusao" id="input-dataconclusao" type="date"
                                        value="{{ isset($contrato) ? $contrato->dataconclusao : old('dataconclusao') }}"
                                        placeholder="{{ __('Data de Entrega') }}"  />
                                    @if ($errors->has('dataconclusao'))
                                        <span id="dataconclusao-error" class="error text-danger"
                                            for="input-dataconclusao">{{ $errors->first('dataconclusao') }}</span>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>


    <div class="col-md-12">
        <div class="card mb-4">
            <div class="card-body ">
                <div class="row">
                    <div class="col-md-12 col-lg-12">
                        <h4 class="mb-3 bg-light">Itens de Recorrência
                        @if(isset($contratoItem))
                            <a style="float:right" class="insertRecord btn btn-info btn-sm" data-id="{{ isset($contrato) ? $contrato->idcontrato : old('idcontrato') }}" >+ adicionar item</a>
                        @endif</h4>
                    </div>
                    <div class="col-md-12 col-lg-12">
                        <div class="row">
                            <div class="col-md-12">
                                <div class="table-responsive">
                                    <table class='table table-hover table-striped table-bordered table-sm' id="tab_itens">
                                        <thead>
                                            <tr class="info" style="font-size:14px;">
                                                <th class="th-sm">AÇÃO</th>
                                                <th class="w-75">PRODUTO</th>
                                                <th class="th-sm">QTD</th>
                                                <th class="th-sm">UN</th>
                                                <th class="th-sm">VALOR UN.</th>
                                                <th class="th-sm">VALOR TOTAL</th>

                                            </tr>
                                        </thead>
                                        <tbody class="resultbody">
                                            @if(isset($contratoItem))
                                                @foreach ($contratoItem as $itens)
                                                <tr id="{{ isset($itens) ? $itens->idcontratoitem : old('idcontratoitem') }}">
                                                    <input class='form-control input-sm'style='width:100%;' type="hidden" name="idcontratoitem[]" value="{{ isset($itens) ? $itens->idcontratoitem : old('idcontratoitem') }}">
                                                    <input class='form-control input-sm'style='width:100%;' type="hidden" name="idcontrato[]" value="{{ isset($itens) ? $itens->idcontrato : old('idcontrato') }}">
                                                    @if (!isset($contrato))
                                                        <td class="custom-tbl" style="text-align: center;">
                                                            <a class="deleteRecord btn-sm text-danger material-icons text-sm me-2" data-id="{{ $itens->idcontratoitem }}" style="cursor: pointer;" >delete</a>
                                                        </td>
                                                    @endif

                                                    <td colspan="{{ isset($contrato) ? '2' : '1' }}">
                                                        <select class="form-control input-sm" name="idprodserv[]" {{ isset($contrato) ? 'disabled' : ''  }} onchange="getSelectedValue(this)">
                                                            <option value="">- Selecionar -</option>
                                                            @foreach($produtoServico as $prod)
                                                                <option value="{{ $prod->idprodserv }}"
                                                                        data-unidade="{{ $prod->unidade }}"
                                                                        data-valorvenda="{{ $prod->valorvenda }}"
                                                                        {{ ((isset($itens) && $prod->idprodserv == $itens->idprodserv) || (old('idprodserv') == $prod->idprodserv)) ? 'selected' : '' }}>{{$prod->prodserv}}</option>
                                                            @endforeach
                                                        </select>
                                                    </td>
                                                    <td class="custom-tbl">
                                                        <input {{ isset($contrato) ? 'readonly' : ''  }} style="text-align: right;" step="0.01" class='form-control input-sm'style='width:100%;' type="text" name="qtd[]" name="qtd[]" value="{{ isset($itens) ? number_format($itens->qtd, 2, ',','') : old('qtd') }}" onblur="updateValorItem(this)" oninput="formatarEntradaNumerica(this);updateValorItem(this)" >
                                                    </td>
                                                    <td class="custom-tbl">
                                                        <input {{ isset($contrato) ? 'readonly' : ''  }} class='form-control input-sm'style='width:100%;' type="text" name="un[]" value="{{ isset($itens) ? $itens->un : old('un') }}">
                                                    </td>
                                                    <td class="custom-tbl">
                                                        <input {{ isset($contrato) ? 'readonly' : ''  }} style="text-align: right;" step="0.01" class='form-control input-sm'style='width:100%;' type="text" name="valorun[]" value="{{ isset($itens) ? number_format($itens->valorun, 2, ',','') : old('valorun') }}" onblur="updateValorItem(this)" oninput="formatarEntradaNumerica(this);updateValorItem(this)">
                                                    </td>
                                                    <td class="custom-tbl">
                                                        <input {{ isset($contrato) ? 'readonly' : ''  }} style="text-align: right;" step="0.01" class='form-control input-sm'style='width:100%;' type="number" name="valoritem[]" value="{{ isset($itens) ? $itens->valoritem : old('valoritem') }}" readonly>
                                                    </td>

                                                </tr>
                                                @endforeach
                                            @endif
                                        </tbody>

                                        <tfoot>
                                            <tr class='info'>
                                                <td style='width:65%;text-align:right;padding:4px;font-size:12px;' colspan='5'>VALOR DOS ITENS:</td>
                                                <td style='padding:0px;font-size:12px;'>
                                                    <input style="text-align:right;" class="form-control  input-sm {{ $errors->has('valorcontrato') ? ' is-invalid' : '' }}"
                                                        name="valorcontrato" id="input-valorcontrato" type="number" step="0.01" {{ isset($contrato) ? 'readonly' : '' }}
                                                        value="{{ isset($contrato) ? $contrato->valorcontrato : old('valorcontrato') }}" placeholder="{{ __('Valor da NF') }}" readonly/>
                                                        @if ($errors->has('valorcontrato'))
                                                            <span id="valorcontrato-error" class="error text-danger"
                                                                for="input-valorcontrato">{{ $errors->first('valorcontrato') }}</span>
                                                        @endif

                                                </td>
                                            </tr>
                                            <tr class='info'>
                                                <td style='width:65%;text-align:right;padding:4px;font-size:12px;' colspan='5'>VALOR DO DESCONTO (-):</td>
                                                <td style='padding:0px;font-size:12px;'>

                                                <input style="text-align:right;padding-right: 15px;" class="form-control  input-sm {{ $errors->has('descontocontrato') ? ' is-invalid' : '' }}" {{ isset($contrato) ? 'readonly' : '' }}
                                                        name="descontocontrato" id="input-descontocontrato" type="text" step="0.01"  placeholder="{{ __('Valor do Desconto') }}"
                                                        value="{{ isset($contrato) ? number_format($contrato->descontocontrato, 2, ',','') : old('descontocontrato') }}" onblur="updatevalorcontrato()" oninput="formatarEntradaNumerica(this);updatevalorcontrato()"/>
                                                        @if ($errors->has('descontocontrato'))
                                                            <span id="descontocontrato-error" class="error text-danger"
                                                                for="input-descontocontrato">{{ $errors->first('descontocontrato') }}</span>
                                                        @endif

                                                </td>
                                            </tr>
                                            <tr class='info'>
                                                <td style='width:65%;text-align:right;padding:4px;font-size:12px;' colspan='5'>VALOR TOTAL:</td>
                                                <td style='padding:0px;font-size:12px;'>

                                                <input style="text-align:right;" class="form-control  input-sm {{ $errors->has('totalcontrato') ? ' is-invalid' : '' }}" {{ isset($contrato) ? 'readonly' : '' }}
                                                        name="totalcontrato" id="input-totalcontrato" type="number" step="0.01"
                                                        value="{{ isset($contrato) ? $contrato->totalcontrato : old('totalcontrato') }}" placeholder="{{ __('Valor Total da NF') }}" readonly/>
                                                        @if ($errors->has('totalcontrato'))
                                                            <span id="totalcontrato-error" class="error text-danger"
                                                                for="input-totalcontrato">{{ $errors->first('totalcontrato') }}</span>
                                                        @endif

                                                </td>
                                            </tr>
                                        </tfoot>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>

    <div class="col-md-{{ isset($contrato) && $contrato->mostraendereco == 1 ? '6' : '12'  }}" id="col-veiculos">
        <div class="card mb-4">
            <div class="card-body ">
                <div class="row">
                    <div class="col-md-12 col-lg-12">
                        <h4 class="mb-3 bg-light">Veículo(s) do Contrato
                        @if(isset($contrato))
                            <a style="float:right" class="insertVeiculo btn btn-info btn-sm" data-id="{{ isset($contrato) ? $contrato->idcontrato : old('idcontrato') }}" >+ adicionar item</a>
                        @endif
                        </h4>

                    </div>
                    <div class="col-md-12 col-lg-12">
                        <div class="row">
                            <div class="col-md-12">
                                <div class="table-responsive">
                                    <table class='table table-hover table-striped table-bordered table-sm' id="tab_logic">
                                        <thead>
                                            <tr class="info" style="font-size:14px;">
                                                <th class="th-sm text-center" >AÇÃO</th>
                                                <th class="w-75">VEÍCULO</th>
                                            </tr>
                                        </thead>
                                        <tbody class="resultbody">
                                            @if(isset($contratosveiculos))
                                                @foreach ($contratosveiculos as $contratoveiculo)

                                                <tr id="{{ isset($contratoveiculo) ? $contratoveiculo->idcontratoveiculo : old('idcontratoveiculo') }}">
                                                        <input class='form-control input-sm'style='width:100%;' type="hidden" name="idcontratoveiculo[]" value="{{ isset($contratoveiculo) ? $contratoveiculo->idcontratoveiculo : old('idcontratoveiculo') }}">
                                                        <input class='form-control input-sm'style='width:100%;' type="hidden" name="idcontrato[]" value="{{ isset($contratoveiculo) ? $contratoveiculo->idcontrato : old('idcontrato') }}">
                                                        <td class="custom-tbl text-center">
                                                            <a class="deleteRecord btn-sm text-danger material-icons text-sm me-2" data-id="{{ $contratoveiculo->idcontratoveiculo }}" style="cursor: pointer;" >delete</a>
                                                        </td>
                                                        <td class="custom-tbl">
                                                        <select class="form-control input-sm" name="idveiculo[]" >
                                                            <option value="">- Selecionar -</option>
                                                            @foreach($veiculos as $veiculo)
                                                                <option value="{{ $veiculo->idveiculo }}"
                                                                        {{ ((isset($contratoveiculo) && $veiculo->idveiculo == $contratoveiculo->idveiculo) || (old('idveiculo') == $veiculo->idveiculo)) ? 'selected' : '' }}>{{$veiculo->marca}}/{{$veiculo->modelo}} | {{$veiculo->placa}}
                                                                </option>
                                                            @endforeach
                                                        </select>
                                                    </td>
                                                </tr>
                                                @endforeach
                                            @endif
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-6" id="col-endereco" style="display: {{ isset($contrato) && $contrato->mostraendereco == 1 ? 'block' : 'none' }}">
        <div class="card mb-4">
            <div class="card-body ">
                <div class="row">
                    <div class="col-md-12 col-lg-12">
                        <h4 class="mb-3 bg-light">Endereço do Local</h4>
                    </div>
                    <div class="col-md-12 col-lg-12">
                        <div class="row">
                            {{-- Cep --}}
                            <div class="col-4">
                                <div class="input-group input-group-static my-3 {{ $errors->has('cep') ? ' is-invalid' : '' }}">
                                    <label>{{ __('Cep') }}</label>
                                    <input class="form-control cep {{ $errors->has('cep') ? ' is-invalid' : '' }}"
                                    name="cep" id="input-cep" type="text"
                                    value="{{ isset($contrato) ? $contrato->cep : old('cep') }}" placeholder="{{ __('Cep') }}"
                                     />
                                    @if ($errors->has('cep'))
                                        <span id="cep-error" class="error text-danger"
                                            for="input-cep">{{ $errors->first('cep') }}</span>
                                    @endif
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            {{-- Endereço --}}
                            <div class="col-5">
                                <div class="input-group input-group-static my-3 {{ $errors->has('endereco') ? ' is-invalid' : '' }}">
                                    <label>{{ __('Endereço') }}</label>
                                    <input class="form-control{{ $errors->has('endereco') ? ' is-invalid' : '' }}"
                                    name="endereco" id="input-endereco" type="text"
                                    value="{{ isset($contrato) ? $contrato->endereco : old('endereco') }}" placeholder="{{ __('Endereço') }}"
                                     />
                                    @if ($errors->has('endereco'))
                                        <span id="endereco-error" class="error text-danger"
                                            for="input-endereco">{{ $errors->first('endereco') }}</span>
                                    @endif
                                </div>
                            </div>
                            {{-- Número --}}
                            <div class="col-2">
                                <div class="input-group input-group-static my-3 {{ $errors->has('numero') ? ' is-invalid' : '' }}">
                                    <label>{{ __('Número') }}</label>
                                    <input class="form-control{{ $errors->has('numero') ? ' is-invalid' : '' }}"
                                    name="numero" id="input-numero" type="text"
                                    value="{{ isset($contrato) ? $contrato->numero : old('numero') }}" placeholder="{{ __('Número') }}"
                                     />
                                    @if ($errors->has('numero'))
                                        <span id="numero-error" class="error text-danger"
                                            for="input-numero">{{ $errors->first('numero') }}</span>
                                    @endif
                                </div>
                            </div>
                            {{-- Complemento --}}
                            <div class="col-5">
                                <div class="input-group input-group-static my-3 {{ $errors->has('complemento') ? ' is-invalid' : '' }}">
                                    <label>{{ __('Complemento') }}</label>
                                    <input class="form-control{{ $errors->has('complemento') ? ' is-invalid' : '' }}"
                                    name="complemento" id="input-complemento" type="text"
                                    value="{{ isset($contrato) ? $contrato->complemento : old('complemento') }}" placeholder="{{ __('Complemento') }}"
                                    />
                                    @if ($errors->has('complemento'))
                                        <span id="complemento-error" class="error text-danger"
                                            for="input-complemento">{{ $errors->first('complemento') }}</span>
                                    @endif
                                </div>
                            </div>
                            {{-- Bairro --}}
                            <div class="col-5">
                                <div class="input-group input-group-static my-3 {{ $errors->has('bairro') ? ' is-invalid' : '' }}">
                                    <label>{{ __('Bairro') }}</label>
                                    <input class="form-control{{ $errors->has('bairro') ? ' is-invalid' : '' }}"
                                    name="bairro" id="input-bairro" type="text"
                                    value="{{ isset($contrato) ? $contrato->bairro : old('bairro') }}" placeholder="{{ __('Bairro') }}"
                                     />
                                    @if ($errors->has('bairro'))
                                        <span id="bairro-error" class="error text-danger"
                                            for="input-bairro">{{ $errors->first('bairro') }}</span>
                                    @endif
                                </div>
                            </div>
                            {{-- Cidade --}}
                            <div class="col-5">
                                <div class="input-group input-group-static my-3 {{ $errors->has('cidade') ? ' is-invalid' : '' }}">
                                    <label>{{ __('Cidade') }}</label>
                                    <input class="form-control{{ $errors->has('cidade') ? ' is-invalid' : '' }}"
                                    name="cidade" id="input-cidade" type="text"
                                    value="{{ isset($contrato) ? $contrato->cidade : old('cidade') }}" placeholder="{{ __('Cidade') }}"
                                     />
                                    @if ($errors->has('cidade'))
                                        <span id="cidade-error" class="error text-danger"
                                            for="input-cidade">{{ $errors->first('cidade') }}</span>
                                    @endif
                                </div>
                            </div>
                            {{-- Estado --}}
                            <div class="col-2">
                                <div class="input-group input-group-static my-3 {{ $errors->has('estado') ? ' is-invalid' : '' }}">
                                    <label>{{ __('Estado') }}</label>
                                    <input class="form-control{{ $errors->has('estado') ? ' is-invalid' : '' }}"
                                    name="estado" id="input-estado" type="text"
                                    value="{{ isset($contrato) ? $contrato->estado : old('estado') }}" placeholder="{{ __('Estado') }}"
                                     />
                                    @if ($errors->has('estado'))
                                        <span id="estado-error" class="error text-danger"
                                            for="input-estado">{{ $errors->first('estado') }}</span>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>


</div>


<div class="row">
    <div class="col-md-6">
        @include('partials.status', ['model' => $contrato ?? null])
    </div>
    @if(isset($contrato))
    <div class="col-md-6">
        @include('partials.upload', ['model' => $contrato])
    </div>
    @endif

</div>

<div class="card mb-4">
    <div class="card-footer ml-auto mr-auto">
        <button id="submit-button" type="submit" class="btn btn-success">{{ __((isset($contrato) ? 'Atualizar' : 'Adicionar').' Assinatura') }}</button>
        <a href="{{ route('admin.contratos.index') }}"
                   class="btn btn-light">{{ __('Voltar') }}</a>
        @if(isset($contrato))
        <a class="btn bg-gradient-dark" href="{{route('admin.contratos.create')}}"><i
                    class="material-icons text-sm">add</i>&nbsp;&nbsp;Nova Assinatura</a>
        @endif
    </div>
</div>

@push('js')
<script>
    // Oculta card de dados do contrato caso switch seja checkado
    $('#switchMostraContrato').on('change', function() {
        const colContrato = $('#col-contrato');
        const colRecorrencia = $('#col-recorrencia');

        if (this.checked) {
            colContrato.show();

            if (colRecorrencia.hasClass('col-md-12')) {
                colRecorrencia.removeClass('col-md-12');
                colRecorrencia.addClass('col-md-8');
            }
        } else {
            $('#col-contrato').hide();

            if (colRecorrencia.hasClass('col-md-8')) {
                colRecorrencia.removeClass('col-md-8');
                colRecorrencia.addClass('col-md-12');
            }
        }
    });

    $('#switchMostraEndereco').on('change', function() {
        const colEndereco = $('#col-endereco');
        const colVeiculos = $('#col-veiculos');

        if (this.checked) {
            colEndereco.show();

            if (colVeiculos.hasClass('col-md-12')) {
                colVeiculos.removeClass('col-md-12');
                colVeiculos.addClass('col-md-6');
            }
        } else {
            $('#col-endereco').hide();

            if (colVeiculos.hasClass('col-md-6')) {
                colVeiculos.removeClass('col-md-6');
                colVeiculos.addClass('col-md-12');
            }
        }
    });
</script>

{{-- @TODO: criar mascaras --}}
{{-- Select2 --}}
    <script src="{{ asset('assets/js/plugins/select2.min.js') }}"></script>
    <script>
        $('.select2').select2();

            $(document).on("click", ".deleteRecord", function(){
                var id = $(this).data("id");
                var token = $("meta[name='csrf-token']").attr("content");
                $.ajax({
                    url: "../../contratoveiculo/"+id,
                    type: 'DELETE',
                    data: {
                        "id": id,
                        "_token": token,
                    },
                    success: function (){
                        console.log("it Works");
                        var row = $('#'+id).remove();
                    }
                    });
                });


                $(".insertVeiculo").click(function(){
                var id = $(this).data("id");
                var token = $("meta[name='csrf-token']").attr("content");
                $.ajax({
                    url: "../../contratoveiculoadd/"+id,
                    type: 'POST',
                    data: {
                        "id": id,
                        "_token": token,
                    },
                    success: function (response){
                        console.log("it Works");
                        var idContratoVeiculo = response.success;
                        var tr = montaHtmlVeiculo(idContratoVeiculo);
                        $('#tab_logic').append(tr);

                    }
                    });
                });


            function montaHtmlVeiculo(idcontratoveiculo){
                var trHTML = '<tr id="'+idcontratoveiculo+'">' +
                                    '<input class="form-control input-sm" style="width:100%;" type="hidden" name="idcontratoveiculo[]" value="'+idcontratoveiculo+'" onfocus="focused(this)" onfocusout="defocused(this)">' +
                                    '<input class="form-control input-sm" style="width:100%;" type="hidden" name="idcontrato[]" value="28" onfocus="focused(this)" onfocusout="defocused(this)">' +
                                '<td class="custom-tbl text-center">' +
                                    '<a class="deleteRecord btn-sm text-danger material-icons text-sm me-2" data-id="'+idcontratoveiculo+'" style="cursor: pointer;">delete</a>' +
                                '</td>' +
                                '<td class="custom-tbl">' +
                                    '<select class="form-control input-sm" name="idveiculo[]" onchange="getSelectedValue(this)" required="true" aria-required="true">' +
                                        '<option value="">- Selecionar -</option><?=$optveiculos;?>'+
                                    '</select>' +
                                '</td>' +
                            '</tr>';
                return trHTML;
            }



    </script>
<script>



$('.select2').select2();

    $(document).on("click", ".deleteRecord", function(){
        var id = $(this).data("id");
        var token = $("meta[name='csrf-token']").attr("content");
        $.ajax({
            url: "../../contratoitem/"+id,
            type: 'DELETE',
            data: {
                "id": id,
                "_token": token,
            },
            success: function (){
                console.log("it Works");
                var row = $('#'+id).remove();
                //row.style.display = 'none';
                updatevalorcontrato();
            }
            });
        });



    function montaHtml(idcontratoitem, idcontrato){
        var trHTML = '<tr id="'+idcontratoitem+'">' +
                            '<input class="form-control input-sm" style="width:100%;" type="hidden" name="idcontratoitem[]" value="'+idcontratoitem+'" onfocus="focused(this)" onfocusout="defocused(this)">' +
                            '<input class="form-control input-sm" style="width:100%;" type="hidden" name="idcontrato[]" value="'+idcontrato+'" onfocus="focused(this)" onfocusout="defocused(this)">' +
                        '<td class="custom-tbl" style="text-align: center;">' +
                            '<a class="deleteRecord btn-sm text-danger material-icons text-sm me-2" data-id="'+idcontratoitem+'" style="cursor: pointer;">delete</a>' +
                        '</td>' +
                        '<td class="custom-tbl">' +
                            '<select class="form-control input-sm" name="idprodserv[]" onchange="getSelectedValue(this)">' +
                                '<option value="">- Selecionar -</option><?=$opt;?>'+
                            '</select>' +
                        '</td>' +
                        '<td class="custom-tbl">' +
                            '<input style="text-align: right;" class="form-control input-sm" style="width:100%;" type="text" name="qtd[]" step="0.01" value="" onfocus="focused(this)" onfocusout="defocused(this)" onblur="updateValorItem(this)" oninput="formatarEntradaNumerica(this);updateValorItem(this)" >' +
                        '</td>' +
                        '<td class="custom-tbl">' +
                            '<input class="form-control input-sm" style="width:100%;" type="text" name="un[]" value="" onfocus="focused(this)" onfocusout="defocused(this)">' +
                        '</td>' +
                        '<td class="custom-tbl">' +
                            '<input style="text-align: right;" class="form-control input-sm" style="width:100%;" type="text" name="valorun[]" step="0.01" value="" onfocus="focused(this)" onfocusout="defocused(this)" onblur="updateValorItem(this)" oninput="formatarEntradaNumerica(this);updateValorItem(this)" >' +
                        '</td>' +
                        '<td class="custom-tbl">' +
                            '<input style="text-align: right;" class="form-control input-sm" style="width:100%;" type="number" name="valoritem[]"  step="0.01" value="" onfocus="focused(this)" onfocusout="defocused(this)">' +
                        '</td>' +
                    '</tr>';
        return trHTML;
    }

    $(".insertRecord").click(function(){



        var id = $(this).data("id");
        var token = $("meta[name='csrf-token']").attr("content");
        $.ajax({
            url: "../../contratoitemadd/"+id,
            type: 'POST',
            data: {
                "id": id,
                "_token": token,
            },
            success: function (response){
                console.log("it Works");
                var idContratoItem = response.success;
                var tr = montaHtml(idContratoItem);
                $('#tab_itens').append(tr);

            }
            });
        });

</script>
<script>
function getSelectedValue(select) {
var selectedOption = select.options[select.selectedIndex];
var prodData = selectedOption.dataset;
var row = select.closest('tr');
// Preencha os outros campos com os dados obtidos
row.querySelector("input[name='un[]']").value = prodData.unidade;
row.querySelector("input[name='valorun[]']").value = prodData.valorvenda;
//    row.querySelector("input[name='qtd[]']").max = prodData.qtdmax;
row.querySelector("input[name='qtd[]']").focus();
row.querySelector("input[name='qtd[]']").blur();
updatevalorcontrato();

}

function updateValorItem(element) {
//debugger;
var row = element.closest('tr'); // Encontra o elemento pai <tr>
var qtd = converterParaNumero(row.querySelector("input[name='qtd[]']").value);
var valorUn = converterParaNumero(row.querySelector("input[name='valorun[]']").value);
if (!isNaN(parseFloat(valorUn)) && valorUn !== "" && valorUn !== undefined) {
// O valor é válido e não é NaN
    valorUn = (valorUn);
    //alert(0);
} else {
// O valor é inválido ou NaN
    valorUn.value = 0;
   // alert(1);
}

if (!isNaN(parseFloat(qtd)) && qtd.value !== "" && qtd !== undefined) {
// O valor é válido e não é NaN
    qtd = (qtd);
} else {
// O valor é inválido ou NaN
    qtd = 0;
}
var valorItem = qtd * valorUn;
var valorItemInput = row.querySelector("input[name='valoritem[]']");
valorItemInput.value = valorItem.toFixed(2);
// valorItemInput.value = valorItemInput.value.replace('.', ',');
updatevalorcontrato();
}

function updatevalorcontrato() {
//debugger;
var valorItemInputs = document.querySelectorAll("input[name='valoritem[]']");
var valorcontrato = 0;

// Itera sobre os campos e soma os valores
for (var i = 0; i < valorItemInputs.length; i++) {

    valorItemInputs[i].value = valorItemInputs[i].value.replace(',', '.');
    var valorItem = parseFloat(valorItemInputs[i].value);
    if (!isNaN(valorItem)) {
        valorcontrato += valorItem;
    }
}

// Atualiza o campo de valor total
var valorcontratoInput = document.querySelector("input[name='valorcontrato']");
if (valorcontratoInput) {
    valorcontratoInput.value = valorcontrato.toFixed(2);
}
console.log(1);
//Busca o valor do campo Desconto
var descontocontratoInput = document.querySelector("input[name='descontocontrato']");

// Atualiza o campo de valor total
var totalcontratoInput = document.querySelector("input[name='totalcontrato']");
console.log(1);
var valorcontrato = parseFloat(valorcontratoInput.value); // Supondo que valorcontratoInput é o valor original
var desconto = parseFloat(descontocontratoInput.value); // Converte o valor do desconto para um número
if (desconto) {
    var total = valorcontrato - desconto; // Calcula o total
}else{
    var total = valorcontrato;
}
totalcontratoInput.value = total.toFixed(2); // Formata o número com dois dígitos decimais e define o valor do input
console.log(12);
}

function atualizarTodosItens() {
// Seleciona todas as linhas da tabela no corpo da tabela com classe 'resultbody'
var linhas = document.querySelectorAll("#tab_logic tbody.resultbody tr");

// Itera por cada linha
linhas.forEach(function(row) {
    // Encontra o primeiro input de quantidade na linha para usar como argumento para a função updateValorItem
    var inputQtd = row.querySelector("input[name='qtd[]']");

    // Chama a função updateValorItem passando o input encontrado como argumento
    if (inputQtd) {
        updateValorItem(inputQtd);
    }
});
}


// Chama a função ApresentaDados quando a página é carregada
document.addEventListener('DOMContentLoaded', function() {
atualizarTodosItens();
});
// Chamar a função atualizarTodosItens quando necessário


</script>

<script>

    function formatarEntradaNumerica(el) {
        // Primeiro, substitui todos os pontos por vírgulas
        let valor = el.value.replace(/\./g, ',');

        // Remove caracteres que não são dígitos ou vírgula
        valor = valor.replace(/[^0-9,]/g, '');

        // Permite apenas uma vírgula
        let partes = valor.split(',');
        if (partes.length > 2) {
            valor = partes[0] + ',' + partes.slice(1).join('');
        }

        el.value = valor;
    }

    function converterParaNumero(valor) {
        // Verifica se o valor é não nulo e não vazio
        if (valor) {
            // Converte vírgulas em pontos
            var valorConvertido = valor.replace(',', '.');

            // Converte para float e verifica se é NaN. Se for NaN, retorna 0
            var numero = parseFloat(valorConvertido);
            return isNaN(numero) ? 0 : numero;
        }
        return 0;
    }
    </script>
    @include('partials.upload-js')
@endpush
