@php
    use Carbon\Carbon;
@endphp
<x-layout bodyClass="g-sidenav-show  bg-dark-silk">
    <x-navbars.sidebar activePage="eventos"></x-navbars.sidebar>
    <main class="main-content position-relative max-height-vh-100 h-100 border-radius-lg ">
        <!-- Navbar -->
        <x-navbars.navs.auth titlePage="Eventos"></x-navbars.navs.auth>
        <!-- End Navbar -->
        <div class="container-fluid py-4">
            <div class="row">
                <div class="col-12">
                    <div class="card my-4">
                        <div class="card-header p-0 position-relative mt-n4 mx-3 z-index-2">
                            <div class="bg-gradient-primary shadow-primary border-radius-lg pt-4 pb-3">
                                <h5 class="mx-3">Eventos</h5>
                            </div>
                        </div>
                        <div class="m-3 d-flex flex-row flex-wrap gap-3 align-items-center justify-content-between">
                            <div class="d-flex flex-wrap align-content-center gap-2">
                                <button class="btn btn-sm m-0 text-center shadow-none"  style="background-color: #e5e5e5; color: #344767; border-radius: 20px; font-size: .7rem" data-bs-toggle="modal" data-bs-target="#filterModal">
                                    <i class="fa fa-filter me-1" style="font-size: .7rem" aria-hidden="true"></i> <span id="filter-count">Filtro</span>
                                </button>
                                <div class="col-auto d-flex align-items-center">
                                    <input type="checkbox" class="btn-check"  id="btn-check-inativo" autocomplete="off"
                                    {{ \Request::get('status') === 'INATIVO' ? 'checked' : '' }}>
                                    <label class="btn btn-sm shadow-sm m-0 text-center border-2 d-flex align-items-center shadow-none" style="background-color: #dddddd; color: #344767; border-radius: 20px; padding: 10px 24px" for="btn-check-inativo">
                                        <i class="fa fa-times-circle-o me-2" style="font-size: .9rem;" aria-hidden="true"></i>
                                        <span style="font-size: .7rem">Inativo</span>
                                        <i class="fa fa-times ps-3 {{ \Request::get('status') === 'INATIVO' ? '' : 'd-none' }}" style="font-weight: 600; font-size: .8rem" id="btn-check-hide" aria-hidden="true"></i>
                                    </label>
                                </div>
                                <div class="col-auto d-flex align-items-center">
                                    <a href="{{ route('admin.eventos.index') }}?clear=true" class="btn shadow-none m-0 text-center border-2" style="background-color: #dddddd; color: #344767; border-radius: 20px; font-size: .7rem">
                                        <i class="fa fa-trash me-1" style="font-size: .8rem" aria-hidden="true"></i> Limpar filtros
                                    </a>
                                </div>
                                @include('partials.filter-text', ['route' => route('admin.eventos.search')])
                            </div>
                            <div class="col-auto text-end">
                                <a class="btn bg-gradient-dark mb-0" href="{{route('admin.eventos.create')}}">
                                    <i class="material-icons text-sm">add</i>&nbsp;&nbsp;Adicionar Evento
                                </a>
                            </div>
                        </div>
                        <div class="card-body px-0 pb-2">
                            {{-- Messagens da session --}}
                            @include('partials.session-message')
                            <div class="table-responsive p-0">
                                <table class="table align-items-center mb-0">
                                    <thead>
                                        <tr>
                                            <th
                                                class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                                ID
                                            </th>
                                            <th
                                                class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                                Cliente
                                            </th>
                                            <th
                                                class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                                Tipo
                                            </th>
                                            <th
                                                class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                                Evento
                                            </th>
                                            <th
                                                class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 text-center">
                                                Início
                                            </th>

                                            <th
                                                class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 text-center">
                                                Fim
                                            </th>
                                            <th
                                                class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 text-center">
                                                Duração
                                            </th>
                                            <th
                                                class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 text-center">
                                                Qtd
                                            </th>
                                            <th
                                                class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                                Status
                                            </th>
                                            <th class="text-secondary opacity-7 d-none"></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($eventos as $evento)
                                            <tr data-url="{{route('admin.eventos.edit', $evento->idevento)}}" style="cursor: pointer;">
                                                <td>
                                                    <div class="d-flex px-2 py-1">
                                                        <div class="d-flex flex-column justify-content-center">
                                                            <p class="mb-0 text-sm">{{ $evento->idevento }}</p>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>
                                                    <div class="d-flex px-2 py-1">
                                                        <div class="d-flex flex-column justify-content-center">
                                                            <p class="mb-0 text-sm">
                                                                <span class="badge badge-sm bg-gradient-success" style="background: {{ $evento->cliente->cor ?? '' }} ">{{ $evento->cliente->razaosocial ?? $evento->cliente->nome ?? '-' }}</span>

                                                            </p>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>
                                                    <div class="d-flex px-2 py-1">
                                                        <div class="d-flex flex-column justify-content-center">
                                                            <p class="mb-0 text-sm">{{ $evento->eventotipo->eventotipo }}</p>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>
                                                    <div class="d-flex px-2 py-1">
                                                        <div class="d-flex flex-column justify-content-center">
                                                            <p class="mb-0 text-sm">
                                                                {{ $evento->evento  }}
                                                            </p>
                                                        </div>
                                                    </div>
                                                </td>

                                                <td>
                                                    <div class="d-flex flex-column text-center">
                                                    <p class="mb-0 text-sm">{{ Carbon::parse($evento->data)->format('d/m/y') }} {{ ($evento->eventotipo->hora == 'SIM') ? Carbon::parse($evento->hora)->format('H:i') : '' }}</p>
                                                    </div>
                                                </td>

                                                <td>
                                                    <div class="d-flex flex-column text-center">
                                                    <p class="mb-0 text-sm">{{ Carbon::parse($evento->datafim)->format('d/m/y') }} {{ ($evento->eventotipo->hora == 'SIM') ? Carbon::parse($evento->horafim)->format('H:i') : '' }}</p>
                                                    </div>
                                                </td>

                                                @php


                                                    // Combine data e hora:
                                                    $startDateTime = Carbon::parse($evento->data . ' ' . $evento->hora);

                                                    // Combine datafim e horafim:
                                                    $endDateTime = Carbon::parse($evento->datafim . ' ' . $evento->horafim);

                                                    // Calcule a diferença:
                                                    $duration = $startDateTime->diff($endDateTime);

                                                    // Verifique se a diferença é maior que 1 dia:
                                                    if ($duration->days > 1) {
                                                        if($evento->eventotipo->hora == 'SIM'){
                                                            // Formate a diferença para mostrar em dias, horas, minutos, etc.:
                                                            $durationString = $duration->format('%d dias %H:%I');
                                                        }else{
                                                            // Formate a diferença para mostrar em dias, horas, minutos, etc.:
                                                            $durationString = $duration->format('%d dias');
                                                        }

                                                    } else {
                                                        // Formate a diferença para mostrar apenas horas e minutos:
                                                        $durationString = $duration->format('%H:%I');
                                                    }
                                                @endphp
                                                </td>
                                                <td>
                                                    <div class="d-flex flex-column text-center">
                                                    <p class="mb-0 text-sm">{{ $durationString }}</p>
                                                    </div>
                                                </td>
                                                <td>
                                                    <div class="d-flex flex-column text-center">
                                                    <p class="mb-0 text-sm">{{ $evento->qtd }}</p>
                                                    </div>
                                                </td>
                                                <td data-noclicked="true" class="pe-3">
                                                    <div class="progress mb-1" style="width: 100%;">
                                                        <div class="progress-bar {{ $evento->status === 'CONCLUÍDO' ? 'bg-success' : ($evento->status === 'EM EXECUÇÃO' ? 'bg-info' : ($evento->status === 'PENDENTE' ? 'bg-warning' : 'bg-danger')) }}" role="progressbar" style="height: 10px; width: 50%;" data-iditem="{{ $evento->idevento }}" data-status="CANCELADO" data-bs-toggle="tooltip" data-bs-title="Cancelado"></div>
                                                        <div class="progress-bar {{ $evento->status === 'CONCLUÍDO' ? 'bg-success' : ($evento->status === 'EM EXECUÇÃO' ? 'bg-info' : ($evento->status === 'CANCELADO' ? 'bg-secondary' : 'bg-warning')) }}" role="progressbar" style="height: 10px; width: 50%;" data-iditem="{{ $evento->idevento }}" data-status="PENDENTE" data-bs-toggle="tooltip" data-bs-title="Pendente"></div>
                                                        <div class="progress-bar {{ $evento->status === 'CONCLUÍDO' ? 'bg-success' : ($evento->status === 'PENDENTE' || $evento->status === 'CANCELADO' ? 'bg-secondary' : 'bg-info' ) }}" role="progressbar" style="height: 10px; width: 50%;" data-iditem="{{ $evento->idevento }}" data-status="EM EXECUÇÃO" data-bs-toggle="tooltip" data-bs-title="Em execução"></div>
                                                        <div class="progress-bar {{ $evento->status === 'CONCLUÍDO' ? 'bg-success' : 'bg-secondary' }}" role="progressbar" style="height: 10px; width: 50%;" data-iditem="{{ $evento->idevento }}" data-status="CONCLUÍDO" data-bs-toggle="tooltip" data-bs-title="Concluído"></div>
                                                    </div>
                                                    <div>
                                                        <span id="status-{{ $evento->idevento }}" style="font-size: .8rem; text-transform: capitalize">{{ Str::lower($evento->status) }}</span>
                                                    </div>
                                                </td>
                                                <td class="align-middle text-center d-none">
                                                    <a rel="tooltip" class="btn btn-success btn-sm btn-link"
                                                        href="{{route('admin.eventos.edit', $evento->idevento)}}" data-original-title=""
                                                        title="">
                                                        <i class="material-icons">edit</i>
                                                        <div class="ripple-container"></div>
                                                    </a>
                                                    <form action="{{route('admin.eventos.destroy', $evento->idevento)}}" class="d-inline" method="POST">
                                                        @csrf
                                                        @method('delete')
                                                        <button type="button" class="btn btn-danger btn-sm btn-link"
                                                            data-original-title="" title=""
                                                            onclick="confirm('{{ __('Você tem certeza que deseja apagar esse Evento ?') }}') ? this.parentElement.submit() : ''">
                                                            <i class="material-icons">close</i>
                                                            <div class="ripple-container"></div>
                                                        </button>
                                                    </form>
                                                </td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <x-footers.auth></x-footers.auth>
        </div>
    </main>
    <x-plugins></x-plugins>
</x-layout>
@include('partials.update-status-progress', ['route' => route('admin.eventos.update', ['evento' => ':id']), 'redirect' => 0, 'options' => [
    'CANCELADO' => 'bg-danger',
    'PENDENTE' => 'bg-warning',
    'EM EXECUÇÃO' => 'bg-info',
    'CONCLUÍDO' => 'bg-success'
]])
@include('partials.filter-inativo', ['routeSearch' => route('admin.eventos.search'), 'routeIndex' => route('admin.eventos.index')])
@include('partials.filters', [
    'route' => route('admin.eventos.search'),
    'filters' => [
        ['label' => 'Nº Evento', 'value' => 'idevento', 'inputType' => 'text'],
        ['label' => 'Evento', 'value' => 'evento', 'inputType' => 'text'],
        ['label' => 'Cliente', 'value' => 'idcliente', 'inputType' => 'select', 'options' => $clientes, 'valueField' => 'idpessoa', 'textField' => ['razaosocial', 'nome']],
        ['label' => 'Tipo', 'value' => 'ideventotipo', 'inputType' => 'select', 'options' => $eventoTipos, 'valueField' => 'ideventotipo', 'textField' => 'eventotipo'],
        ['label' => 'Data de Início', 'value' => 'data', 'inputType' => 'date'],
        ['label' => 'Data de Fim', 'value' => 'datafim', 'inputType' => 'date'],
        ['label' => 'Status', 'value' => 'status', 'inputType' => 'select', 'options' => [
            ['status' => 'CANCELADO', 'label' => 'Cancelado'],
            ['status' => 'PENDENTE', 'label' => 'Pendente'],
            ['status' => 'EM EXECUÇÃO', 'label' => 'Em execução'],
            ['status' => 'CONCLUÍDO', 'label' => 'Concluído'],
        ], 'valueField' => 'status', 'textField' => 'label']
    ]
])
