<meta name="csrf-token" content="{{ csrf_token() }}">
<div class="card mb-4">
    <div class="card-header p-0 position-relative mt-n4 mx-3 z-index-2">
        <div class="bg-gradient-primary shadow-primary border-radius-lg pt-4 pb-3">
            <h5 class="mx-3">Forma de Pagamento</h5>
        </div>
    </div>
    <div class="card-body ">
    {{-- Messagens da session --}}
        @include('partials.session-message')
        @if ($errors->any() || session('error'))
        <div class="row">
            <div class="col-sm-12">
                <div class="alert alert-danger">
                    <button type="button" class="close" data-dismiss="alert"
                            aria-label="Close">
                        <i class="tim-icons icon-simple-remove"></i>
                    </button>
                    <span>{{$errors->any() ? $errors->first() : session('error')}}</span>
                </div>
            </div>
        </div>
            @endif

        <div class="row">
            @if (isset($formaPagamento))
            <div class="col-md-9 col-lg-9">
                <span class="badge badge-sm bg-light mb-3 text-dark"># <?=$formaPagamento->idformapagamento;?></span>
            </div>
            <div class="col-md-3 col-lg-3">
                <span class="float-end badge badge-sm {{$bg_status}}"><?=$formaPagamento->status;?></span>
            </div>
        @endif
        </div>
    </div>
</div>
<div class="card mb-4">
    <div class="card-body ">
        <div class="row">
            <div class="col-md-12 col-lg-12">
                <h4 class="mb-3 bg-light">Dados Cadastrais</h4>
            </div>
            <div class="col-md-12 col-lg-12">
                <div class="row">
                    {{-- Forma de pagamento --}}
                    <div class="col-4">
                        <div class="input-group input-group-static my-3 {{ $errors->has('formapagamento') ? ' is-invalid' : '' }}">
                            <label>{{ __('Forma de pagamento') }}</label>
                            <input class="form-control{{ $errors->has('formapagamento') ? ' is-invalid' : '' }}"
                            name="formapagamento" id="input-formapagamento" type="text"
                            value="{{ isset($formaPagamento) ? $formaPagamento->formapagamento : old('formapagamento') }}" placeholder="{{ __('Forma de pagamento') }}"/>
                            @if ($errors->has('formapagamento'))
                                <span id="formapagamento-error" class="error text-danger"
                                    for="input-formapagamento">{{ $errors->first('formapagamento') }}</span>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>


@if(isset($formaPagamento))
    @include('partials.upload', ['model' => $formaPagamento])
@endif
@include('partials.status', ['model' => $formaPagamento ?? null])


<div class="card mb-4">
    <div class="card-footer ml-auto mr-auto">
        <button id="submit-button" type="submit" class="btn btn-success">{{ __((isset($formaPagamento) ? 'Atualizar' : 'Adicionar').' Forma de Pagamento') }}</button>
        <a href="{{ route('admin.forma-pagamento.index') }}"
                   class="btn btn-light">{{ __('Voltar') }}</a>
    </div>
</div>

@push('js')
    @include('partials.upload-js')
@endpush
