<!-- EventoTipo View -->
<meta name="csrf-token" content="{{ csrf_token() }}">
<div class="card mb-4">
    <div class="card-header p-0 position-relative mt-n4 mx-3 z-index-2">
        <div class="bg-gradient-primary shadow-primary border-radius-lg pt-4 pb-3">
            <h5 class="mx-3">Divisão</h5>
        </div>
    </div>
    <div class="card-body ">
        <!-- Mensagens da session -->
        @include('partials.session-message')
        @if ($errors->any() || session('error'))
        <div class="row">
            <div class="col-sm-12">
                <div class="alert alert-danger">
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <i class="tim-icons icon-simple-remove"></i>
                    </button>
                    <span>{{$errors->any() ? $errors->first() : session('error')}}</span>
                </div>
            </div>
        </div>
        @endif

        <div class="row">
            @if (isset($item))
            <div class="col-md-9 col-lg-9"> 
                <span class="badge badge-sm bg-light mb-3 text-dark"># {{$item->iditem}}</span>
            </div>
            @endif
        </div>
    </div>
</div>
<div class="card mb-4">
    <div class="card-body ">
        <div class="row">
            <div class="col-md-12 col-lg-12">
                <h4 class="mb-3 bg-light">Dados Cadastrais</h4>
            </div>
            <!-- Empresa -->
            <div class="col-8">
                <div class="input-group input-group-static my-3">
                    <label class="ms-0">Empresa</label>
                    <select class="form-control" name="idempresa">
                        <option value="" disabled="disabled">- Selecionar -</option>
                        @foreach($empresas as $empresa)
                            <option value="{{ $empresa->idempresa }}" {{ ((isset($item) && $empresa->idempresa == $item->idempresa) || (old('idempresa') == $empresa->idempresa)) ? 'selected' : '' }}>{{$empresa->razaosocial}}</option>
                        @endforeach
                    </select>
                </div>
            </div>
               <!-- Grupo Item -->
               <div class="col-8">
                <div class="input-group input-group-static my-3">
                    <label class="ms-0">Centro de Custo</label>
                    <select class="form-control" name="idgrupoitem">
                        <option value="" disabled="disabled">- Selecionar -</option>
                        @foreach($grupoitens as $grupoitem)
                            <option value="{{ $grupoitem->idgrupoitem }}" {{ ((isset($item) && $grupoitem->idgrupoitem == $item->idgrupoitem) || (old('idgrupoitem') == $grupoitem->idgrupoitem)) ? 'selected' : '' }}>{{$grupoitem->grupoitem}}</option>
                        @endforeach
                    </select>
                </div>
            </div>
            <!-- Item -->
            <div class="col-8">
                <div class="input-group input-group-static my-3 {{ $errors->has('item') ? ' is-invalid' : '' }}">
                    <label>Nome do Item</label>
                    <input class="form-control {{ $errors->has('item') ? ' is-invalid' : '' }}" name="item" id="input-item" type="text" value="{{ isset($item) ? $item->item : old('item') }}" required="true" aria-required="true"/>
                    @if ($errors->has('item'))
                        <span id="item-error" class="error text-danger" for="input-item">{{ $errors->first('item') }}</span>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>

<div class="card mb-4">
    <div class="card-footer ml-auto mr-auto">
        <button id="submit-button" type="submit" class="btn btn-success">{{ __(isset($item) ? 'Atualizar' : 'Adicionar') . ' Divisão' }}</button>
        <a href="{{ route('admin.grupoitens.index') }}" class="btn btn-light">{{ __('Voltar') }}</a>
    </div>
</div>

@push('js')
    @include('partials.upload-js')
@endpush
