@push('css')
    {{-- Select2 --}}
    <link rel="stylesheet" href="{{ asset('assets/css/select2.min.css') }}">
@endpush
<meta name="csrf-token" content="{{ csrf_token() }}">
<div class="card mb-4">
    <div class="card-header p-0 position-relative mt-n4 mx-3 z-index-2">
        <div class="bg-gradient-primary shadow-primary border-radius-lg pt-4 pb-3">
            <h5 class="mx-3">Contas a Pagar</h5>
        </div>
    </div>
    <div class="card-body ">
    {{-- Messagens da session --}}
        @include('partials.session-message')
        @if ($errors->any() || session('error'))
        <div class="row">
            <div class="col-sm-12">
                <div class="alert alert-danger">
                    <button type="button" class="close" data-dismiss="alert"
                            aria-label="Close">
                        <i class="tim-icons icon-simple-remove"></i>
                    </button>
                    <span>{{$errors->any() ? $errors->first() : session('error')}}</span>
                </div>
            </div>
        </div>
            @endif

        <div class="row">
            @if (isset($parcela))
            <div class="col-md-9 col-lg-9">
                <span class="badge badge-sm bg-light mb-3 text-dark"># <?=$parcela->idnfparcela;?></span>
            </div>
            <div class="col-md-3 col-lg-3">
                <span class="float-end badge badge-sm {{$bg_status}}"><?=$parcela->status;?></span>
            </div>
        @endif
        </div>
    </div>
</div>
<div class="row">

<div class="col-md-6">
        <div class="card mb-4">
            <div class="card-body ">
                <div class="row">
                    <div class="col-md-12 col-lg-12">
                        <h4 class="mb-3 bg-light">
                            Dados {{ __(($parcela->tipo == "C" ? 'da Venda' : 'da Compra')) }}
                            @if(isset($nf))
                                <a target="_blank" href="/admin/{{ $parcela->tipo == 'C' ? 'vendas' : 'compras' }}/{{$nf->idnf}}/edit">
                                    # {{$nf->idnf}} <i class="fas fa-link"></i>
                                </a>
                            @else
                                #{{ old('idnf') }}
                            @endif
                        </h4>
                    </div>

                    <div class="col-md-12 col-lg-12">
                        <div class="row">
                        {{-- Empresa --}}
                            <div class="col-9">
                                <div class="input-group input-group-static my-3">
                                    <label class="ms-0">Empresa</label>
                                    <input class="form-control razaosocial {{ $errors->has('razaosocial') ? ' is-invalid' : '' }}"
                                    name="razaosocial" id="input-razaosocial" type="text"
                                    value="{{ isset($empresa) ? $empresa->razaosocial : old('razaosocial') }}" placeholder="{{ __('razaosocial') }}"
                                    readonly aria-readonly="true" disabled aria-disabled="true"/>
                                </div>
                            </div>

                            {{-- Data entrada --}}
                            <div class="col-3">
                                <div  class="input-group input-group-static my-3 {{ $errors->has('dataentrada') ? ' is-invalid' : '' }}">
                                    <label>{{ __('Data Entrada') }}</label>
                                    <input class="form-control {{ $errors->has('dataentrada') ? ' is-invalid' : '' }}"
                                        name="dataentrada" id="input-dataentrada" type="date"
                                        value="{{ isset($nf) ? $nf->dataentrada : old('dataentrada') }}"
                                        placeholder="{{ __('Data entrada') }}"  readonly aria-readonly="true" disabled aria-disabled="true" />
                                    @if ($errors->has('dataentrada'))
                                        <span id="dataentrada-error" class="error text-danger"
                                            for="input-dataentrada">{{ $errors->first('dataentrada') }}</span>
                                    @endif
                                    </div>
                            </div>
                            {{-- Pessoa --}}
                            <div class="col-9">
                                <div class="input-group input-group-static my-3">
                                    <label class="ms-0">Cliente</label>
                                        <input class="form-control nome {{ $errors->has('nome') ? ' is-invalid' : '' }}"
                                        name="razaosocial" id="input-razaosocial" type="text"
                                        value="{{ isset($pessoa) ? $pessoa->nome : old('nome') }}" placeholder="{{ __('nome') }}"
                                        readonly aria-readonly="true" disabled aria-disabled="true"/>
                                </div>
                            </div>
                            {{-- Tipo de Produto e Serviço --}}
                            <div class="col-3">
                                <div class="input-group input-group-static my-3">
                                    <label class="ms-0">Tipo</label>
                                        <input class="form-control prodservtipo {{ $errors->has('prodservtipo') ? ' is-invalid' : '' }}"
                                        name="razaosocial" id="input-razaosocial" type="text"
                                        value="{{ isset($tipoProdutoServico) ? $tipoProdutoServico->prodservtipo : old('prodservtipo') }}" placeholder="{{ __('prodservtipo') }}"
                                        readonly aria-readonly="true" disabled aria-disabled="true"/>
                                </div>
                            </div>
                            {{-- Dados Financeiros do Cliente --}}
                            <div class="col-12">
                                <div class="input-group input-group-static my-3">
                                    <label class="ms-0">Dados Financeiros do Cliente</label>
                                    <input class="form-control observacao {{ $errors->has('observacao') ? ' is-invalid' : '' }}"
                                    type="text"
                                    value="{{ isset($pessoa) ? $pessoa->observacao : old('observacao') }}" placeholder="{{ __('Observação') }}"
                                    required="true" aria-required="true" disabled aria-disabled="true"/>
                                </div>
                            </div>


                            {{-- Veículo --}}
                            @if (isset($veiculo))
                            <div class="col-8">
                                <div class="input-group input-group-static my-3">
                                    <label class="ms-0">Veículo</label>
                                    <input class="form-control placa {{ $errors->has('placa') ? ' is-invalid' : '' }}"
                                        name="placa" id="input-placa" type="text"
                                        value="{{$veiculo->placa}} - {{$veiculo->marca}} - {{$veiculo->modelo}}" placeholder="{{ __('placa') }}"
                                        readonly aria-readonly="true" disabled aria-disabled="true"/>

                                </div>
                            </div>
                            @endif
                            {{-- KM --}}
                            @if (isset($veiculo))
                            <div class="col-4">
                                <div class="input-group input-group-static my-3 {{ $errors->has('km') ? ' is-invalid' : '' }}">
                                    <label>{{ __('KM') }}</label>
                                    <input class="form-control km {{ $errors->has('km') ? ' is-invalid' : '' }}"
                                        name="razaosocial" id="input-razaosocial" type="text"
                                        value="{{ isset($nf) ? $nf->km : old('km') }}" placeholder="{{ __('km') }}"
                                        readonly aria-readonly="true" disabled aria-disabled="true"/>
                                    {{ $nf->km }}
                                </div>
                            </div>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-6">
        <div class="card mb-4">
            <div class="card-body ">
                <div class="row">
                    <div class="col-md-12 col-lg-12">
                        <h4 class="mb-3 bg-light">Dados Financeiros</h4>
                    </div>
                    <div class="col-md-12 col-lg-12">
                        <div class="row">

                            {{-- Tipo --}}
                            <div class="col-3">
                                <div class="input-group input-group-static my-3" >
                                    <label class="ms-0">Tipo</label>
                                    <select class="form-control" name="tipo" disabled aria-disabled="true">
                                        <option value="" disabled="disabled">- Selecionar -</option>

                                        <option value="C" {{ ((isset($parcela) && $parcela->tipo == "C") || old('tipo') == "C") ? 'selected' : '' }}>Crédito</option>
                                        <option value="D" {{ ((isset($parcela) && $parcela->tipo == "D") || old('tipo') == "D") ? 'selected' : '' }}>Débito</option>

                                    </select>
                                </div>
                            </div>
                            @if ($agencias->isNotEmpty())

                            {{-- Agência --}}
                            <div class="col-3">
                                <div class="input-group input-group-static my-3">
                                    <label class="ms-0">Agência</label>
                                    <select class="form-control" name="idagencia" {{ isset($parcela) && $parcela->status == 'CONCLUÍDO' ? 'disabled' : '' }}>
                                        <option value="" disabled="disabled">- Selecionar -</option>
                                        @foreach($agencias as $agencia)
                                            <option value="{{ $agencia->idagencia }}" {{ ((isset($parcela) && $agencia->idagencia == $parcela->idagencia) || (old('idagencia') == $agencia->idagencia)) ? 'selected' : '' }}>{{ "$agencia->nome - $agencia->nagencia" }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            @endif

                            {{-- Data Vencimento --}}
                            <div class="col-3">
                                <div
                                    class="input-group input-group-static my-3 {{ $errors->has('datavencimento') ? ' is-invalid' : '' }}">
                                    <label>{{ __('Data Vencimento') }}</label>
                                    <input class="form-control {{ $errors->has('datavencimento') ? ' is-invalid' : '' }}"
                                        {{ isset($parcela) && $parcela->status == 'CONCLUÍDO' ? 'disabled' : '' }}
                                        name="datavencimento" id="input-datavencimento" type="date"
                                        value="{{ isset($parcela) ? $parcela->datavencimento : old('datavencimento') }}"
                                        placeholder="{{ __('Data vencimento') }}" required="true" aria-required="true" />
                                    @if ($errors->has('datavencimento'))
                                        <span id="datavencimento-error" class="error text-danger"
                                            for="input-datavencimento">{{ $errors->first('datavencimento') }}</span>
                                    @endif
                                </div>
                            </div>

                            {{-- Data Trasnsação --}}
                            <div class="col-3">
                                <div
                                    class="input-group input-group-static my-3 {{ $errors->has('datatransacao') ? ' is-invalid' : '' }}">
                                    <label>{{ __('Data Transação') }}</label>
                                    <input class="form-control {{ $errors->has('datatransacao') ? ' is-invalid' : '' }}"
                                        {{ isset($parcela) && $parcela->status == 'CONCLUÍDO' ? 'disabled' : '' }}
                                        name="datatransacao" id="input-datatransacao" type="date"
                                        value="{{ isset($parcela) && $parcela->datatransacao ? Carbon\Carbon::parse($parcela->datatransacao)->format('Y-m-d') : (old('datatransacao') ?: '') }}"
                                        placeholder="{{ __('Data Transação') }}" aria-required="true" />

                                    @if ($errors->has('datatransacao'))
                                        <span id="datatransacao-error" class="error text-danger"
                                            for="input-datatransacao">{{ $errors->first('datatransacao') }}</span>
                                    @endif
                                </div>
                            </div>

                            {{-- Pagamento --}}
                            <div class="col-6">
                                <div class="input-group input-group-static my-3">
                                    <label class="ms-0">Forma de Pagamento</label>
                                    <input class="form-control parcela {{ $errors->has('parcela') ? ' is-invalid' : '' }}"
                                    name="parcela" id="input-parcela" type="text"
                                    value="{{ isset($formaPagamento) ? $formaPagamento->formapagamento : old('formapagamento') }}" placeholder="{{ __('Forma Pagamento') }}"
                                    required="true" aria-required="true" disabled aria-disabled="true"/>
                                </div>
                            </div>

                            {{-- Parcela --}}
                            <div class="col-3">
                                <div class="input-group input-group-static my-3 {{ $errors->has('parcela') ? ' is-invalid' : '' }}">
                                    <label>{{ __('Parcela') }}</label>
                                    <input class="form-control parcela {{ $errors->has('parcela') ? ' is-invalid' : '' }}"
                                    name="parcela" id="input-parcela" type="text"
                                    value="{{ isset($parcela) ? $parcela->parcela.'/'.$nf->qtdparcela : old('parcela') }}" placeholder="{{ __('Parcela') }}"
                                    required="true" aria-required="true" disabled aria-disabled="true"/>
                                    @if ($errors->has('parcela'))
                                        <span id="parcela-error" class="error text-danger"
                                            for="input-parcela">{{ $errors->first('parcela') }}</span>
                                    @endif
                                </div>
                            </div>

                            {{-- Valor --}}
                            <div class="col-3">
                                <div class="input-group input-group-static my-3 {{ $errors->has('valor') ? ' is-invalid' : '' }}">
                                    <label>{{ __('Valor') }}</label>
                                    <input class="form-control valor {{ $errors->has('valor') ? ' is-invalid' : '' }}"
                                    name="valor" id="input-valor" type="text"
                                    {{ isset($parcela) && $parcela->status == 'CONCLUÍDO' ? 'disabled' : '' }}
                                    value="{{ isset($parcela) ? number_format($parcela->valor, 2, ',', '.') : old('valor') }}" placeholder="{{ __('Valor') }}"
                                    required="true" aria-required="true"/>
                                    @if ($errors->has('parcela'))
                                        <span id="valor-error" class="error text-danger"
                                            for="input-valor">{{ $errors->first('valor') }}</span>
                                    @endif
                                </div>
                            </div>

                            {{-- Observação --}}
                            <div class="col-12">
                                <div class="input-group input-group-static my-3">
                                    <label class="ms-0">Observação</label>
                                    <input class="form-control observacao {{ $errors->has('observacao') ? ' is-invalid' : '' }}"
                                    name="observacao" id="input-observacao" type="text"
                                    value="{{ isset($nf) ? $nf->observacao : old('observacao') }}" placeholder="{{ __('Observação') }}"
                                    required="true" aria-required="true" disabled aria-disabled="true"/>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>


<div class="row">
    <div class="col-md-6">
        @include('partials.status', ['model' => $parcela ?? null])
    </div>
    @if(isset($parcela))
    <div class="col-md-6">
        @include('partials.upload', ['model' => $parcela])
    </div>
    @endif

</div>

<div class="card mb-4">
    <div class="card-footer ml-auto mr-auto">
        <button id="submit-button" type="submit" class="btn btn-success">{{ __((isset($parcela) ? 'Atualizar' : 'Adicionar').' Parcela') }}</button>
        <a href="{{ route('admin.nfparcelasdebito.index') }}"
                   class="btn btn-light">{{ __('Voltar') }}</a>
    </div>
</div>
@push('js')
    {{-- Select2 --}}
    <script src="{{ asset('assets/js/plugins/select2.min.js') }}"></script>

    <script>
        $('#input-status').on('change', function() {
            if ($(this).val() == 'CONCLUÍDO') {
                $('#input-datatransacao').prop('required', true);
            } else {
                $('#input-datatransacao').prop('required', false);
            }
        })
    </script>

    @include('partials.upload-js')
@endpush
