<div class="card ">
    <div class="card-header card-header-primary">
        <h4 class="card-title">{{ __('Adicionar nova Obra') }}</h4>
        <p class="card-category"></p>
    </div>
    <div class="card-body ">
        <div class="row">
            <div class="col-md-12 text-right">
                <a href="{{ route('admin.obras.index') }}"
                   class="btn btn-sm btn-primary">{{ __('Voltar para a lista') }}</a>
            </div>
        </div>
        {{-- Messagens da session --}}
        @include('partials.session-message')
        <div class="row">
            {{-- Nome --}}
            <div class="col-8">
                <div class="input-group input-group-static my-3 {{ $errors->has('nome') ? ' is-invalid' : '' }}">
                    <label>{{ __('Nome') }}</label>
                    <input class="form-control nome {{ $errors->has('nome') ? ' is-invalid' : '' }}"
                    name="nome" id="input-nome" type="text"
                    value="{{ isset($obra) ? $obra->nome : old('nome') }}" placeholder="{{ __('Nome') }}"
                    required="true" aria-required="true"/>
                    @if ($errors->has('nome'))
                        <span id="nome-error" class="error text-danger"
                            for="input-nome">{{ $errors->first('nome') }}</span>
                    @endif
                </div>
            </div>
            {{-- Empresa --}}
            <div class="col-6">
                <div class="input-group input-group-static my-3">
                    <label class="ms-0">Empresa</label>
                    <select class="form-control" name="idempresa">
                        <option value="" disabled="disabled">- Selecionar -</option>
                    @foreach($empresas as $empresa)
                        <option value="{{ $empresa->idempresa }}" {{ ((isset($obra) && $empresa->idempresa == $obra->empresa->idempresa) || (old('idempresa') == $empresa->idempresa)) ? 'selected' : '' }}>{{$empresa->razaosocial}}</option>
                    @endforeach
                    </select>
                </div>
            </div>
            {{-- Pessoa --}}
            <div class="col-8">
                <div class="input-group input-group-static my-3">
                    <label class="ms-0">Pessoa</label>
                    <select class="form-control" name="idpessoa">
                        <option value=''>Selecionar</option>
                        @foreach($pessoas as $pessoa)
                            <option value="{{ $pessoa->idpessoa }}" {{ ((isset($obra) && ($pessoa->idpessoa && $pessoa->idpessoa == $obra->pessoa->idpessoa)) || (old('idpessoa') == $pessoa->idpessoa)) ? 'selected' : '' }}>{{$pessoa->nome}}</option>
                        @endforeach
                    </select>
                </div>
            </div>
            {{-- Cep --}}
            <div class="col-8">
                <div class="input-group input-group-static my-3 {{ $errors->has('cep') ? ' is-invalid' : '' }}">
                    <label>{{ __('Cep') }}</label>
                    <input class="form-control cep {{ $errors->has('cep') ? ' is-invalid' : '' }}"
                    name="cep" id="input-cep" type="text"
                    value="{{ isset($obra) ? $obra->cep : old('cep') }}" placeholder="{{ __('Cep') }}"
                    required="true" aria-required="true"/>
                    @if ($errors->has('cep'))
                        <span id="cep-error" class="error text-danger"
                            for="input-cep">{{ $errors->first('cep') }}</span>
                    @endif
                </div>
            </div>
            {{-- Endereço --}}
            <div class="col-8">
                <div class="input-group input-group-static my-3 {{ $errors->has('endereco') ? ' is-invalid' : '' }}">
                    <label>{{ __('Endereço') }}</label>
                    <input class="form-control{{ $errors->has('endereco') ? ' is-invalid' : '' }}"
                    name="endereco" id="input-endereco" type="text"
                    value="{{ isset($obra) ? $obra->endereco : old('endereco') }}" placeholder="{{ __('Endereço') }}"
                    required="true" aria-required="true"/>
                    @if ($errors->has('endereco'))
                        <span id="endereco-error" class="error text-danger"
                            for="input-endereco">{{ $errors->first('endereco') }}</span>
                    @endif
                </div>
            </div>
            {{-- Número --}}
            <div class="col-8">
                <div class="input-group input-group-static my-3 {{ $errors->has('numero') ? ' is-invalid' : '' }}">
                    <label>{{ __('Número') }}</label>
                    <input class="form-control{{ $errors->has('numero') ? ' is-invalid' : '' }}"
                    name="numero" id="input-numero" type="text"
                    value="{{ isset($obra) ? $obra->numero : old('numero') }}" placeholder="{{ __('Número') }}"
                    required="true" aria-required="true"/>
                    @if ($errors->has('numero'))
                        <span id="numero-error" class="error text-danger"
                            for="input-numero">{{ $errors->first('numero') }}</span>
                    @endif
                </div>
            </div>
            {{-- Complemento --}}
            <div class="col-8">
                <div class="input-group input-group-static my-3 {{ $errors->has('complemento') ? ' is-invalid' : '' }}">
                    <label>{{ __('Complemento') }}</label>
                    <input class="form-control{{ $errors->has('complemento') ? ' is-invalid' : '' }}"
                    name="complemento" id="input-complemento" type="text"
                    value="{{ isset($obra) ? $obra->complemento : old('complemento') }}" placeholder="{{ __('Complemento') }}"
                    required="true" aria-required="true"/>
                    @if ($errors->has('complemento'))
                        <span id="complemento-error" class="error text-danger"
                            for="input-complemento">{{ $errors->first('complemento') }}</span>
                    @endif
                </div>
            </div>
            {{-- Bairro --}}
            <div class="col-8">
                <div class="input-group input-group-static my-3 {{ $errors->has('bairro') ? ' is-invalid' : '' }}">
                    <label>{{ __('Bairro') }}</label>
                    <input class="form-control{{ $errors->has('bairro') ? ' is-invalid' : '' }}"
                    name="bairro" id="input-bairro" type="text"
                    value="{{ isset($obra) ? $obra->bairro : old('bairro') }}" placeholder="{{ __('Bairro') }}"
                    required="true" aria-required="true"/>
                    @if ($errors->has('bairro'))
                        <span id="bairro-error" class="error text-danger"
                            for="input-bairro">{{ $errors->first('bairro') }}</span>
                    @endif
                </div>
            </div>
            {{-- Cidade --}}
            <div class="col-8">
                <div class="input-group input-group-static my-3 {{ $errors->has('cidade') ? ' is-invalid' : '' }}">
                    <label>{{ __('Cidade') }}</label>
                    <input class="form-control{{ $errors->has('cidade') ? ' is-invalid' : '' }}"
                    name="cidade" id="input-cidade" type="text"
                    value="{{ isset($obra) ? $obra->cidade : old('cidade') }}" placeholder="{{ __('Cidade') }}"
                    required="true" aria-required="true"/>
                    @if ($errors->has('cidade'))
                        <span id="cidade-error" class="error text-danger"
                            for="input-cidade">{{ $errors->first('cidade') }}</span>
                    @endif
                </div>
            </div>
            {{-- Estado --}}
            <div class="col-8">
                <div class="input-group input-group-static my-3 {{ $errors->has('estado') ? ' is-invalid' : '' }}">
                    <label>{{ __('Estado') }}</label>
                    <input class="form-control{{ $errors->has('estado') ? ' is-invalid' : '' }}"
                    name="estado" id="input-estado" type="text"
                    value="{{ isset($obra) ? $obra->estado : old('estado') }}" placeholder="{{ __('Estado') }}"
                    required="true" aria-required="true"/>
                    @if ($errors->has('estado'))
                        <span id="estado-error" class="error text-danger"
                            for="input-estado">{{ $errors->first('estado') }}</span>
                    @endif
                </div>
            </div>
            {{-- Status --}}
            <div class="col-8">
                <div class="input-group input-group-static my-3 {{ $errors->has('status') ? ' is-invalid' : '' }}">
                    <label>{{ __('Status') }}</label>
                    <select class="form-control" name="status">
                        <option value='ATIVO' {{ ((isset($obra) && $obra->status == 'ATIVO') || (old('status') == 'ATIVO')) ? 'selected' : '' }}>Ativo</option>
                        <option value='INATIVO' {{ ((isset($obra) && $obra->status == 'INATIVO') || (old('status') == 'INATIVO')) ? 'selected' : '' }}>Inativo</option>
                    </select>
                    @if ($errors->has('status'))
                        <span id="status-error" class="error text-danger"
                            for="input-status">{{ $errors->first('status') }}</span>
                    @endif
                </div>
            </div>
        </div>
    </div>
    <div class="card-footer ml-auto mr-auto">
        <button type="submit" class="btn btn-primary">{{ __((isset($obra) ? 'Atualizar' : 'Adicionar').' Obra') }}</button>
    </div>
</div>
{{-- @TODO: criar mascaras --}}
