<div class="modal fade" id="pagamentoModal" tabindex="-1" aria-labelledby="pagamentoModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
      <div class="modal-content">
        <div class="modal-header">
            <h1 class="modal-title fs-5" id="pagamentoModalLabel"><i class="fa fa-credit-card me-sm-1" aria-hidden="true"></i> Pagamento</h1>
            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <div class="modal-body">
            <div class="col-12 d-flex flex-wrap flex-row align-items-center justify-content-between mb-2">
                {{-- Informações --}}
                <div class="col-6 d-flex align-items-start justify-content-center flex-column flex-wrap">
                    <p class="text-xs"><span class="font-weight-bolder">Plano:</span> {{ auth()->user()->tenant->plano->nome }}</p>
                    <p class="text-xs"><span class="font-weight-bolder">Valor:</span> R$ {{ number_format(auth()->user()->tenant->plano->valor, 2, ',', '.') }}</p>
                    <p class="d-flex align-items-center gap-2 text-xs fw-bold">
                        Chave pix: <span class="badge badge-sm border border-1 text-secondary overflow-x-scroll" style="width: 150px; scrollbar-width: none" onclick="copyToClipboard(this);" id="chave-pix">{{ $pagamento->chavepix }}</span> <i class="fa fa-clipboard" onclick="copyToClipboard(document.getElementById('chave-pix'));" aria-hidden="true"></i>
                    </p>
                    <p class="text-xs"><span class="font-weight-bolder">Status: </span> <span id="status-payment">Aguardando pagamento...</span></p>
                </div>
                {{-- QRCode --}}
                <div class="col-6 d-flex align-items-center justify-content-center">
                  <div class="qr-code">
                      <img src="{{ $pagamento->qrcodeurl }}" style="width: 150px">
                  </div>
                </div>
            </div>
            <div class="col-12 text-start">
                <span class="w-100"><i class="fa fa-info-circle" aria-hidden="true"></i> Após a confirmação do pagamento, o plano ficará ativo.</span>
            </div>
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-outline-secondary btn-sm" data-bs-dismiss="modal">Cancelar</button>
          <button type="button" class="btn btn-dark btn-sm">Confirmar</button>
        </div>
      </div>
    </div>
</div>
@push('js')
    <script>
        function copyToClipboard(element) {
            var text = element.textContent || element.innerText;
            var ol = window.getSelection();
            var w = window;
            var range = document.createRange();
            range.selectNodeContents(element);
            ol.removeAllRanges();
            ol.addRange(range);
            w.document.execCommand('copy');
            alert('Copiado para a área de transferência');
        }
    </script>
@endpush
