<meta name="csrf-token" content="{{ csrf_token() }}">
<div class="card mb-4">
    <div class="card-header p-0 position-relative mt-n4 mx-3 z-index-2">
        <div class="bg-gradient-primary shadow-primary border-radius-lg pt-4 pb-3">
            <h5 class="mx-3">Plano Funcionalidade</h5>
        </div>
    </div>
    <div class="card-body ">
        {{-- Messagens da session --}}
        @include('partials.session-message')
        @if ($errors->any() || session('error'))
            <div class="row">
                <div class="col-sm-12">
                    <div class="alert alert-danger">
                        <button type="button" class="close" data-dismiss="alert"
                                aria-label="Close">
                            <i class="tim-icons icon-simple-remove"></i>
                        </button>
                        <span>{{$errors->any() ? $errors->first() : session('error')}}</span>
                    </div>
                </div>
            </div>
        @endif

        <div class="row">
            @if (isset($planoFuncionalidade))
                <div class="col-md-9 col-lg-9">
                    <span class="badge badge-sm bg-light mb-3 text-dark"># <?=$planoFuncionalidade->idplanofuncionalidade;?></span>
                </div>
                <div class="col-md-3 col-lg-3">
                    <span class="float-end badge badge-sm {{$bg_status}}"><?=$planoFuncionalidade->status;?></span>
                </div>
            @endif
        </div>
    </div>
</div>

<div class="row">
    <div class="col-md-6">
        <div class="card mb-4">
            <div class="card-body ">
                <div class="row">
                    <div class="col-md-12 col-lg-12">
                        <h4 class="mb-3 bg-light">Dados Cadastrais</h4>
                    </div>
                    <div class="col-12 col-lg-12">
                        <div class="row">
                            <div class="col-md-6" id="container-plano">
                                <div class="input-group input-group-static my-3">
                                    <label class="ms-0">Plano</label>
                                    <select class="form-control" name="idplano">
                                        <option value="" >- Selecionar -</option>
                                        @foreach($planos as $plano)
                                            <option value="{{ $plano->idplano }}" {{ ((isset($planoFuncionalidade) && $plano->idplano == $planoFuncionalidade->idplano) || (old('idplano') == $plano->idplano)) ? 'selected' : '' }}>{{$plano->nome}}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-6" id="container-funcionalidade">
                                <div class="input-group input-group-static my-3">
                                    <label class="ms-0">Funcionalidade</label>
                                    <select class="form-control" name="idfuncionalidade" id="idfuncionalidade">
                                        <option value="" >- Selecionar -</option>
                                        @foreach($funcionalidades as $funcionalidade)
                                            <option data-isquantitative="{{ $funcionalidade->quantitativo }}" value="{{ $funcionalidade->idfuncionalidade }}" {{ ((isset($planoFuncionalidade) && $funcionalidade->idfuncionalidade == $planoFuncionalidade->idfuncionalidade) || (old('idfuncionalidade') == $funcionalidade->idfuncionalidade)) ? 'selected' : '' }}>{{$funcionalidade->nome}}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-4 d-none" id="container-qtd">
                                <div class="input-group input-group-static my-3 {{ $errors->has('tagtipo') ? ' is-invalid' : '' }}">
                                    <label id="label-qtd">{{ __('Quantidade') }}</label>
                                    <input class="form-control{{ $errors->has('qtd') ? ' is-invalid' : '' }}"
                                    name="qtd" id="input-qtd" type="text" inputmode="numeric" pattern="[0-9]*"
                                    value="{{ isset($planoFuncionalidade) ? $planoFuncionalidade->qtd : old('qtd') }}" placeholder="{{ __('Quantidade') }}"
                                    required="true" aria-required="true"/>
                                    @if ($errors->has('qtd'))
                                        <span id="qtd-error" class="error text-danger"
                                            for="input-qtd">{{ $errors->first('qtd') }}</span>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    {{-- Status --}}
    <div class="col-md-6">
        @include('partials.status', ['model' => $planoFuncionalidade ?? null])
    </div>
</div>
<div class="row">
    <div class="col-md-12">
        <div class="card mb-4">
            <div class="card-footer ml-auto mr-auto">
                <button id="submit-button" type="submit" class="btn btn-success">{{ __((isset($planoFuncionalidade) ? 'Atualizar' : 'Adicionar').' Plano Funcionalidade') }}</button>
                <a href="{{ route('admin.plano-funcionalidade.index') }}"
                        class="btn btn-light">{{ __('Voltar') }}</a>
                @if(isset($planoFuncionalidade))
                <a class="btn bg-gradient-dark" href="{{route('admin.plano-funcionalidade.create')}}"><i
                            class="material-icons text-sm">add</i>&nbsp;&nbsp;Nova Plano Funcionalidade</a>
                @endif
            </div>
        </div>
    </div>
</div>
