<meta name="csrf-token" content="{{ csrf_token() }}">
<div class="card mb-4">
    <div class="card-header p-0 position-relative mt-n4 mx-3 z-index-2">
        <div class="bg-gradient-primary shadow-primary border-radius-lg pt-4 pb-3">
            <h5 class="mx-3">Planos</h5>
        </div>
    </div>
    <div class="card-body ">
        {{-- Messagens da session --}}
        @include('partials.session-message')
        @if ($errors->any() || session('error'))
            <div class="row">
                <div class="col-sm-12">
                    <div class="alert alert-danger">
                        <button type="button" class="close" data-dismiss="alert"
                                aria-label="Close">
                            <i class="tim-icons icon-simple-remove"></i>
                        </button>
                        <span>{{$errors->any() ? $errors->first() : session('error')}}</span>
                    </div>
                </div>
            </div>
        @endif

        <div class="row">
            @if (isset($plano))
                <div class="col-md-9 col-lg-9">
                    <span class="badge badge-sm bg-light mb-3 text-dark"># <?=$plano->idplano;?></span>
                </div>
                <div class="col-md-3 col-lg-3">
                    <span class="float-end badge badge-sm {{$bg_status}}"><?=$plano->status;?></span>
                </div>
            @endif
        </div>
    </div>
</div>

<div class="row">
    <div class="col-md-6">
        <div class="card mb-4">
            <div class="card-body ">
                <div class="row">
                    <div class="col-md-12 col-lg-12">
                        <h4 class="mb-3 bg-light">Dados Cadastrais</h4>
                    </div>
                    <div class="col-12 col-lg-12">
                        <div class="row">
                            <div class="col-md-12">
                                <div class="input-group input-group-static my-3">
                                    <label class="ms-0">Produto/Serviço Vinculado</label>
                                    <select class="form-control" name="idprodserv">
                                        <option value="" >- Selecionar -</option>
                                        @foreach($prodservs as $prodserv)
                                            <option value="{{ $prodserv->idprodserv }}" {{ ((isset($plano) && $prodserv->idprodserv == $plano->idprodserv) || (old('idprodserv') == $prodserv->idprodserv)) ? 'selected' : '' }}>{{$prodserv->prodserv}}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="input-group input-group-static my-3 {{ $errors->has('tagtipo') ? ' is-invalid' : '' }}">
                                    <label id="label-nome">{{ __('Nome') }}</label>
                                    <input class="form-control{{ $errors->has('nome') ? ' is-invalid' : '' }}"
                                    name="nome" id="input-nome" type="text"
                                    value="{{ isset($plano) ? $plano->nome : old('nome') }}" placeholder="{{ __('Nome') }}"
                                    required="true" aria-required="true"/>
                                    @if ($errors->has('nome'))
                                        <span id="nome-error" class="error text-danger"
                                            for="input-nome">{{ $errors->first('nome') }}</span>
                                    @endif
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="input-group input-group-static my-3 {{ $errors->has('tagtipo') ? ' is-invalid' : '' }}">
                                    <label id="label-valor">{{ __('Valor') }}</label>
                                    <input class="form-control{{ $errors->has('nome') ? ' is-invalid' : '' }}"
                                    name="valor" id="input-valor" type="text" oninput="inputCash(this)"
                                    value="{{ isset($plano) ? str_replace('.', ',', $plano->valor) : old('valor') }}" placeholder="{{ __('Valor') }}"
                                    required="true" aria-required="true"/>
                                    @if ($errors->has('valor'))
                                        <span id="valor-error" class="error text-danger"
                                            for="input-valor">{{ $errors->first('valor') }}</span>
                                    @endif
                                </div>
                            </div>
                            <div class="col-6">
                            <div class="form-check form-switch d-flex align-items-center gap-3 mb-3">
                                <input class="form-check-input" {{ isset($plano) && $plano->gratuito ? 'checked' : '' }} type="checkbox" name="gratuito" role="switch" id="switchGratuito">
                                <label class="form-check-label m-0" for="switchGratuito">Gratuito</label>
                                <p class="m-0 p-0" data-bs-toggle="tooltip" data-bs-title="Não será apresentado Checkout de Pagamento no cadastro."><i class="fa fa-question-circle-o" aria-hidden="true"></i></p>
                            </div>
                       
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    {{-- Status --}}
    <div class="col-md-6">
        @include('partials.status', ['model' => $plano ?? null])
    </div>
</div>
<div class="row">
    <div class="col-md-12">
        <div class="card mb-4">
            <div class="card-footer ml-auto mr-auto">
                <button id="submit-button" type="submit" class="btn btn-success">{{ __((isset($plano) ? 'Atualizar' : 'Adicionar').' Plano') }}</button>
                <a href="{{ route('admin.planos.index') }}"
                        class="btn btn-light">{{ __('Voltar') }}</a>
                @if(isset($plano))
                <a class="btn bg-gradient-dark" href="{{route('admin.planos.create')}}"><i
                            class="material-icons text-sm">add</i>&nbsp;&nbsp;Nova Plano</a>
                @endif
            </div>
        </div>
    </div>
</div>

<script>
    const inputCash = (input) => {
        let value = input.value.replace(/\D/g, '');

        value = Number(value) / 100;

        const [intPart, decPart] = value.toFixed(2).split('.');

        input.value = intPart.replace(/(\d)(?=(\d{3})+(?!\d))/g, '$1.') + ',' + decPart.padStart(2, '0');
    }
</script>
