<x-layout bodyClass="g-sidenav-show  bg-dark-silk">
    <x-navbars.sidebar activePage="produto-servico"></x-navbars.sidebar>
    <main class="main-content position-relative max-height-vh-100 h-100 border-radius-lg ">
        <!-- Navbar -->
        <x-navbars.navs.auth titlePage="Produtos e Serviços"></x-navbars.navs.auth>
        <!-- End Navbar -->
        <div class="container-fluid py-4">
            <div class="row">
                <div class="col-12">
                    <div class="card my-4">
                        <div class="card-header p-0 position-relative mt-n4 mx-3 z-index-2">
                            <div class="bg-gradient-primary shadow-primary border-radius-lg pt-4 pb-3">
                                <h5 class="mx-3">Produto / Serviço</h5>
                            </div>
                        </div>
                        <div class="row m-0">
                            <div class="col-6 text-left">
                                <form action="{{route('admin.produto-servico.search')}}" class="navbar-form mt-3" method="get">
                                    <div class="input-group input-group-outline d-flex align-items-center">
                                        <input type="text" name="search" class="form-control"
                                               placeholder="Buscar pelo nome do produto-servico..." value="{{ \Request::get('search') }}">
                                        <button type="submit" class="btn btn-primary btn-round btn-just-icon m-0">
                                            <i class="material-icons">search</i>
                                            <div class="ripple-container"></div>
                                        </button>
                                    </div>
                                </form>
                            </div>
                            <div class="col-6 my-3 text-end">
                                <a class="btn bg-gradient-dark mb-0" href="{{route('admin.produto-servico.create')}}"><i
                                        class="material-icons text-sm">add</i>&nbsp;&nbsp;Adicionar Produto / Serviço</a>
                            </div>
                        </div>
                        <div class="card-body px-0 pb-2">
                            {{-- Messagens da session --}}
                            @include('partials.session-message')
                            <div class="table-responsive p-0">
                                <table class="table align-items-center mb-0">
                                    <thead>
                                        <tr>
                                            <th
                                                class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 text-start">
                                                ID
                                            </th>
                                            <th
                                                class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                                Empresa
                                            </th>
                                            <th
                                                class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                                Produto/Serviço
                                            </th>
                                            <th
                                                class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                                Subtipo

                                            <th
                                                class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                                Nome
                                            </th>

                                            <th
                                                class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 ">
                                                Vlr Compra
                                            </th>
                                            <th
                                                class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                                Vlr Venda
                                            </th>
                                            <th
                                                class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 ">
                                                Alerta
                                            </th>
                                            <th
                                                class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 ">
                                                Estoque
                                            </th>
                                            <th
                                                class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                                Status
                                            </th>
                                            <th class="text-secondary opacity-7 d-none"></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($produtosServicos as $produtoServico)
                                        <tr data-url="{{route('admin.produto-servico.edit', $produtoServico->idprodserv)}}" style="cursor: pointer;">
                                            <td>
                                                <div class="d-flex px-2 py-1">
                                                    <div class="d-flex flex-column justify-content-center">
                                                        <p class="mb-0 text-sm">
                                                        {{ $produtoServico->idprodserv }}</p>
                                                    </div>
                                                </div>
                                            </td>
                                            <td>
                                                    <div class="d-flex px-2 py-1">
                                                        <div class="d-flex flex-column justify-content-center">
                                                            <p class="mb-0 text-sm">{{ $produtoServico->empresa->sigla }}</p>
                                                        </div>
                                                    </div>
                                                </td>
                                            <td>
                                                <div class="d-flex px-2 py-1">
                                                    <div class="d-flex flex-column justify-content-center">
                                                        <p class="mb-0 text-sm">
                                                        {{ $produtoServico->tipo == 'p' ? 'Produto' : 'Serviço' }}
                                                    </p>
                                                    </div>
                                                </div>
                                            </td>
                                             <td>
                                                <div class="d-flex px-2 py-1">
                                                    <div class="d-flex flex-column justify-content-center">
                                                        @if($produtoServico->tipos->isNotEmpty())
                                                            @foreach($produtoServico->tipos as $tipo)
                                                                <p class="mb-0 text-sm">{{ $tipo->prodservtipo }}</p>
                                                            @endforeach
                                                        @else
                                                            <p class="mb-0 text-sm">Sem tipo associado</p>
                                                        @endif
                                                    </div>
                                                </div>
                                            </td>
                                            <td>
                                                <div class="d-flex px-2 py-1">
                                                    <div class="d-flex flex-column justify-content-center">
                                                        <p class="mb-0 text-sm">
                                                        {{ $produtoServico->prodserv }}</p>
                                                    </div>
                                                </div>
                                            </td>
                                            <td>
                                                <div class="d-flex px-2 py-1">
                                                    <div class="d-flex flex-column justify-content-center">
                                                        <p class="mb-0 text-sm">
                                                        R$ {{ number_format($produtoServico->valorcompra, 2, ',', '.') }}</p>
                                                    </div>
                                                </div>
                                            </td>
                                            <td>
                                                <div class="d-flex px-2 py-1">
                                                    <div class="d-flex flex-column justify-content-center">
                                                        <p class="mb-0 text-sm">
                                                        R$ {{ number_format($produtoServico->valorvenda, 2, ',', '.') }}</p>
                                                    </div>
                                                </div>
                                            </td>
                                            <td>
                                                <div class="d-flex px-2 py-1">
                                                    <div class="d-flex flex-column justify-content-center">
                                                        <p class="mb-0 text-sm">{{ $produtoServico->tipo == 'p' ? $produtoServico->estoqueminimo : '-' }}</p>
                                                    </div>
                                                </div>
                                            </td>

                                            <td>
                                                <div class="d-flex px-2 py-1">
                                                    <div class="d-flex flex-column justify-content-center">
                                                        <p class="mb-0 text-sm
                                                        @if ($produtoServico->tipo == 's' or (
                                                             $estoqueAtualPorProduto[$produtoServico->idprodserv] >= $produtoServico->estoqueminimo || $produtoServico->estoqueminimo = 0))

                                                            @else
                                                                text-danger font-weight-bold
                                                            @endif">{{ $produtoServico->tipo  == 'p' ? $estoqueAtualPorProduto[$produtoServico->idprodserv] : '-' }}</p>
                                                    </div>
                                                </div>
                                            </td>
                                            <td data-noclicked="true">
                                                <div class="form-check form-switch d-flex align-items-center gap-3 mb-3">
                                                    <input class="form-check-input status" data-iditem="{{ $produtoServico->idprodserv}}" {{ isset($produtoServico) && $produtoServico->status === 'ATIVO' ? 'checked' : '' }} type="checkbox" role="switch" id="switchstatus">
                                                </div>
                                            </td>
                                            <td class="align-middle text-center d-none">
                                                <a rel="tooltip" class="btn btn-success btn-sm btn-link"
                                                    href="{{route('admin.produto-servico.edit', $produtoServico->idprodserv)}}" data-original-title=""
                                                    title="">
                                                    <i class="material-icons">edit</i>
                                                    <div class="ripple-container"></div>
                                                </a>
                                                <form action="{{route('admin.produto-servico.destroy', $produtoServico->idprodserv)}}" class="d-inline" method="POST">
                                                    @csrf
                                                    @method('delete')
                                                    <button type="button" class="btn btn-sm btn-danger btn-link"
                                                        data-original-title="" title=""
                                                        onclick="confirm('{{ __('Você tem certeza que deseja apagar esse Produto / Serviço ?') }}') ? this.parentElement.submit() : ''">
                                                        <i class="material-icons">close</i>
                                                        <div class="ripple-container"></div>
                                                    </button>
                                                </form>
                                            </td>
                                        </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <x-footers.auth></x-footers.auth>
        </div>
    </main>
    <x-plugins></x-plugins>
</x-layout>
@include('partials.update-status-switch', ['route' => route('admin.produto-servico.update', ['produto_servico' => ':id']), 'redirect' => 0])
