<meta name="csrf-token" content="{{ csrf_token() }}">
<input type="hidden" name="idtagretira" value="{{ isset($tagRetira) ? $tagRetira->idtagretira : '' }}">
<div class="card mb-4">
    <div class="card-header p-0 position-relative mt-n4 mx-3 z-index-2">
        <div class="bg-gradient-primary shadow-primary border-radius-lg pt-4 pb-3">
            <h5 class="mx-3">Gestão de Tags</h5>
        </div>
    </div>
    <div class="card-body ">
        {{-- Messagens da session --}}
        @include('partials.session-message')
        @if ($errors->any() || session('error'))
            <div class="row">
                <div class="col-sm-12">
                    <div class="alert alert-danger">
                        <button type="button" class="close" data-dismiss="alert"
                                aria-label="Close">
                            <i class="tim-icons icon-simple-remove"></i>
                        </button>
                        <span>{{$errors->any() ? $errors->first() : session('error')}}</span>
                    </div>
                </div>
            </div>
        @endif

        <div class="row">
            @if (isset($tagRetira))
                <div class="col-md-9 col-lg-9">
                    <span class="badge badge-sm bg-light mb-3 text-dark"># <?=$tagRetira->idtag;?></span>
                </div>
                <div class="col-md-3 col-lg-3">
                    <span class="float-end badge badge-sm {{$bg_status}}"><?=$tagRetira->status;?></span>
                </div>
            @endif
        </div>
    </div>
</div>

<div class="row">
    <div class="col-md-4">
        <div class="card mb-4">
            <div class="card-body ">
                <div class="row">
                    <div class="col-md-12 col-lg-12">
                        <h4 class="mb-3 bg-light">Dados Cadastrais</h4>
                    </div>
                    <div class="col-12 col-lg-12">
                        <div class="row">
                            {{-- Empresa --}}
                            <div class="col-md-12">
                                <div class="input-group input-group-static my-3">
                                    <label class="ms-0">Empresa</label>
                                    <select class="form-control" id="idempresa" name="idempresa" required>
                                        <option value="" disabled="disabled">- Selecionar -</option>
                                    @if (isset($empresas))
                                        @foreach($empresas as $empresa)
                                            <option value="{{ $empresa->idempresa }}" {{ ((isset($tagRetira) && $empresa->idempresa == $tagRetira->empresa->idempresa) || (old('idempresa') == $empresa->idempresa)) ? 'selected' : '' }}>{{$empresa->razaosocial}}</option>
                                        @endforeach
                                    @endif
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            {{-- Colaborador --}}
                            <div class="col-md-6">
                                <div class="input-group input-group-static my-3">
                                    <label class="ms-0">Colaborador</label>
                                    <select class="form-control" id="idpessoa" name="idpessoa" required>
                                        <option value="" disabled="disabled">- Selecionar -</option>
                                        @if (isset($pessoas))
                                            @foreach($pessoas as $pessoa)
                                                <option value="{{ $pessoa->idpessoa }}" {{ ((isset($tagRetira) && $pessoa->idpessoa == $tagRetira->pessoa->idpessoa) || (old('idpessoa') == $pessoa->idpessoa)) ? 'selected' : '' }}>{{$pessoa->nome}}</option>
                                            @endforeach
                                        @endif
                                    </select>
                                </div>
                            </div>
                            {{-- Tag --}}
                            <div class="col-md-6">
                                <div class="input-group input-group-static my-3">
                                    <label class="ms-0">Tag</label>
                                    <select class="form-control" name="idtag" id="idtag" required>
                                        <option value="" disabled="disabled" {{ isset($tagRetira) ? '' : 'selected' }}>- Selecionar -</option>
                                    @foreach($tags as $tag)
                                        <option value="{{ $tag->idtag }}" {{ ((isset($tagRetira) && $tag->idtag == $tagRetira->tag->idtag) || (old('idtag') == $tag->idtag)) ? 'selected' : '' }}>{{ isset($tag->tagTipo) ? $tag->tagTipo->tagtipo ." / ". $tag->tag : $tag->tag }}</option>
                                    @endforeach
                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card mb-4">
            <div class="card-body">
                <div class="row">
                    <div class="col-md-12 col-lg-12">
                        <h4 class="mb-3 bg-light">Informações de Período</h4>
                    </div>
                    <div class="col-12 col-lg-12">
                        <div class="row">
                            {{-- Data de Início --}}
                            <div class="col-md-6">
                                <div class="input-group input-group-static my-3 {{ $errors->has('datainicio') ? ' is-invalid' : '' }}">
                                    <label id="label-prodserv">{{ __('Data de Início') }}</label>
                                    <input class="form-control{{ $errors->has('datainicio') ? ' is-invalid' : '' }}"
                                    name="datainicio" id="input-datainicio" type="datetime-local" required
                                    value="{{ isset($tagRetira) && $tagRetira->datainicio ? Carbon\Carbon::parse($tagRetira->datainicio)->format('Y-m-d H:i') : old('datainicio') }}" placeholder="{{ __('Data de Início') }}"
                                    aria-required="true"/>
                                    @if ($errors->has('datainicio'))
                                        <span id="datainicio-error" class="error text-danger"
                                            for="input-datainicio">{{ $errors->first('datainicio') }}</span>
                                    @endif
                                </div>
                            </div>
                            {{-- Data de Fim --}}
                            <div class="col-md-6">
                                <div class="input-group input-group-static my-3 {{ $errors->has('datafim') ? ' is-invalid' : '' }}">
                                    <label id="label-prodserv">{{ __('Data de Fim') }}</label>
                                    <input class="form-control{{ $errors->has('datafim') ? ' is-invalid' : '' }}"
                                    name="datafim" id="input-datafim" type="datetime-local"
                                    value="{{ isset($tagRetira) && $tagRetira->datafim ? Carbon\Carbon::parse($tagRetira->datafim)->format('Y-m-d H:i') : old('datafim') }}" placeholder="{{ __('Data de Fim') }}"
                                    aria-required="true"/>
                                    @if ($errors->has('datafim'))
                                        <span id="datafim-error" class="error text-danger"
                                            for="input-datafim">{{ $errors->first('datafim') }}</span>
                                    @endif
                                </div>
                            </div>
                            {{-- Data de Devolução --}}
                            <div class="col-md-12">
                                <div class="input-group input-group-static my-3 {{ $errors->has('datadevolucao') ? ' is-invalid' : '' }}">
                                    <label id="label-prodserv">{{ __('Data de Devolução') }}</label>
                                    <input class="form-control{{ $errors->has('datadevolucao') ? ' is-invalid' : '' }}"
                                    name="datadevolucao" id="input-datadevolucao" type="datetime-local"
                                    value="{{ isset($tagRetira) && $tagRetira->datadevolucao ? Carbon\Carbon::parse($tagRetira->datadevolucao)->format('Y-m-d H:i') : old('datadevolucao') }}" placeholder="{{ __('Data de Devolução') }}"
                                    aria-required="true"/>
                                    @if ($errors->has('datadevolucao'))
                                        <span id="datadevolucao-error" class="error text-danger"
                                            for="input-datadevolucao">{{ $errors->first('datadevolucao') }}</span>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-5">
        <div class="card mb-4">
            <div class="card-body">
                <div class="row">
                    <div class="col-md-12 col-lg-12">
                        <h4 class="mb-3 bg-light">Reservas Futuras</h4>
                    </div>
                    <div class="col-12 col-lg-12">
                        <div class="row">
                            {{-- Tabela de tags retiradas --}}
                            <div class="table-responsive">
                                <table class="table" style="font-size: .8rem;" id="table-tags-retiradas">
                                    <thead>
                                        <tr>
                                            <th class="text-center">Colaborador</th>
                                            <th class="text-center">Data de Início</th>
                                            <th class="text-center">Data de Fim</th>
                                            <th class="text-center">Status</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        {{-- Aqui será preenchido dinamicamente --}}
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="row">
    {{-- Status --}}
    <div class="col-md-4">
        @include('partials.status', ['model' => $tagRetira ?? null])
    </div>
    <div class="col-md-3">
        <div class="card mb-4">
            <div class="card-body">
                <div class="row">
                    <div class="col-md-12 col-lg-12">
                        <h4 class="mb-3 bg-light">Informações Adicionais</h4>
                    </div>
                    <div class="col-12 col-lg-12">
                        <div class="row">
                            {{-- Data de Devolução --}}
                            <div class="col-md-12">
                                <div class="input-group input-group-static my-3 {{ $errors->has('observacao') ? ' is-invalid' : '' }}">
                                    <label id="label-prodserv">{{ __('Observação') }}</label>
                                    <input class="form-control{{ $errors->has('observacao') ? ' is-invalid' : '' }}"
                                    name="observacao" id="input-observacao" type="text"
                                    value="{{ isset($tagRetira) ? $tagRetira->observacao : old('observacao') }}" placeholder="{{ __('Infomarções adicionais sobre a reserva...') }}"
                                    aria-required="true" />
                                    @if ($errors->has('observacao'))
                                        <span id="observacao-error" class="error text-danger"
                                            for="input-observacao">{{ $errors->first('observacao') }}</span>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="row">
    <div class="col-md-12">
        <div class="card mb-4">
            <div class="card-footer ml-auto mr-auto">
                <button id="submit-button" type="submit" class="btn btn-success">{{ __((isset($tagRetira) ? 'Atualizar' : 'Adicionar').' Tag Retira') }}</button>
                <a href="{{ route('admin.tagsretira.index') }}"
                        class="btn btn-light">{{ __('Voltar') }}</a>
                @if(isset($tagRetira))
                <a class="btn bg-gradient-dark" href="{{route('admin.tagsretira.create')}}"><i
                            class="material-icons text-sm">add</i>&nbsp;&nbsp;Nova Tag Retira</a>
                @endif
            </div>
        </div>
    </div>
</div>
