<x-layout bodyClass="g-sidenav-show  bg-dark-silk">
    <x-navbars.sidebar activePage="tagretira"></x-navbars.sidebar>
    <main class="main-content position-relative max-height-vh-100 h-100 border-radius-lg ">
        <!-- Navbar -->
        <x-navbars.navs.auth titlePage="Gestão de Tags"></x-navbars.navs.auth>
        <!-- End Navbar -->
        <div class="container-fluid py-4">
            <div class="row">
                <div class="col-12">
                    <div class="card my-4">
                        <div class="card-header p-0 position-relative mt-n4 mx-3 z-index-2">
                            <div class="bg-gradient-primary shadow-primary border-radius-lg pt-4 pb-3">
                                <h5 class="mx-3">Gestão de Tags</h5>
                            </div>
                        </div>
                        <div class="row m-0">
                            <div class="col-6 d-flex align-items-center justify-content-between text-left">
                                <form action="{{route('admin.tagsretira.search')}}" class="navbar-form d-flex align-items-center gap-3" method="get">
                                    <div class="input-group input-group-outline d-flex align-items-center col-3">
                                        <input type="text" name="search" class="form-control"
                                               placeholder="Buscar pelo nome do colaborador..." value="{{ \Request::get('search') }}">
                                        <button type="submit" class="btn btn-primary btn-round btn-just-icon m-0">
                                            <i class="material-icons">search</i>
                                            <div class="ripple-container"></div>
                                        </button>
                                        <a href="{{ route('admin.tagsretira.index', ['clear' => 'true']) }}" class="btn btn-dark btn-round btn-just-icon m-0">
                                            <i class="material-icons">delete</i>
                                        </a>
                                    </div>
                                    <div class="col-3">
                                        <select name="status" id="status-search" class="form-control border border-2 text-center" style="border-radius: 20px;">
                                            <option value="" disabled selected>Filtro</option>
                                            @foreach ($statusOptions as $status => $value)
                                                <option value="{{ $status }}" {{ \Request::get('status') === $status ? 'selected' : '' }}>{{ $value }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                    <div class="col-auto">
                                        <input type="checkbox" class="btn-check"  id="btn-check-inativo" autocomplete="off"
                                        {{ \Request::get('status') === 'INATIVO' ? 'checked' : '' }}>
                                        <label class="btn btn-outline-info shadow-sm p-0 m-0 pt-2 pb-2 ps-4 pe-4" style="text-transform: none; border-radius: 20px; font-size: .9rem" for="btn-check-inativo"><i class="fa fa-times-circle-o" aria-hidden="true"></i> Inativo <i class="fa fa-times ps-3 {{ \Request::get('status') === 'INATIVO' ? '' : 'd-none' }}" style="font-weight: 600;" id="btn-check-hide" aria-hidden="true"></i></label>
                                    </div>
                                </form>
                            </div>
                            <div class="col-6 my-3 text-end">
                                <a class="btn bg-gradient-dark mb-0" href="{{route('admin.tagsretira.create')}}"><i
                                        class="material-icons text-sm">add</i>&nbsp;&nbsp;Adicionar Reserva de Tag</a>
                            </div>
                        </div>
                        <div class="card-body px-0 pb-2">
                            {{-- Messagens da session --}}
                            @include('partials.session-message')
                            <div class="table-responsive p-0">
                                <table class="table align-items-center mb-0">
                                    <thead>
                                        <tr>
                                            <th
                                                class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                                ID
                                            </th>
                                            <th
                                                class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                                Colaborador
                                            </th>
                                            <th
                                                class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                                Empresa
                                            </th>
                                            <th
                                                class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                                Tag Tipo
                                            </th>
                                            <th
                                                class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                                Tag
                                            </th>
                                            <th
                                                class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                                Status
                                            </th>
                                            <th class="text-secondary opacity-7 d-none"></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($tagRetiradas as $tagRetira)
                                            <tr data-url="{{route('admin.tagsretira.edit', ['tagsretira' => $tagRetira])}}" style="cursor: pointer;">
                                                <td class="align-middle text-center">
                                                    <p class="mb-0 text-sm">
                                                    {{ $tagRetira->idtagretira }}</p>
                                                </td>
                                                <td class="align-middle text-center">
                                                    <p class="mb-0 text-sm">
                                                    {{ $tagRetira->pessoa->nome ?? $tagRetira->criadopor }}</p>
                                                </td>
                                                <td class="align-middle text-center">
                                                    <p class="mb-0 text-sm">{{ $tagRetira->empresa->sigla }}</p>
                                                </td>
                                                <td class="align-middle text-center">
                                                    <p class="mb-0 text-sm">
                                                    {{ $tagRetira->tag->tagtipo->tagtipo }}</p>
                                                </td>
                                                <td class="align-middle text-center">
                                                    <p class="mb-0 text-sm">
                                                    {{ $tagRetira->tag->tag }}</p>
                                                </td>
                                                <td data-noclicked="true" class="pe-3">
                                                    <div class="progress mb-1" style="width: 100%;">
                                                        <div class="progress-bar {{ $tagRetira->status === 'CONCLUÍDO' ? 'bg-success' : ($tagRetira->status === 'EM ANDAMENTO' ? 'bg-info' : ($tagRetira->status === 'RESERVADA' ? 'bg-dark' : 'bg-danger')) }}" role="progressbar" style="height: 10px; width: 20%;" data-iditem="{{ $tagRetira->idtagretira }}" data-status="CANCELADO" data-bs-toggle="tooltip" data-bs-title="Cancelado"></div>
                                                        <div class="progress-bar {{ $tagRetira->status === 'CONCLUÍDO' ? 'bg-success' : ($tagRetira->status === 'EM ANDAMENTO' ? 'bg-info' : ($tagRetira->status === 'RESERVADA' ? 'bg-dark' : ($tagRetira->status === 'CANCELADO' ? 'bg-secondary' : 'bg-warning'))) }}" role="progressbar" style="height: 10px; width: 20%;" data-iditem="{{ $tagRetira->idtagretira }}" data-status="PENDENTE" data-bs-toggle="tooltip" data-bs-title="Pendente"></div>
                                                        <div class="progress-bar {{ $tagRetira->status === 'CONCLUÍDO' ? 'bg-success' : ($tagRetira->status === 'EM ANDAMENTO' ? 'bg-info' : ($tagRetira->status === 'RESERVADA' ? 'bg-dark' : 'bg-secondary' )) }}" role="progressbar" style="height: 10px; width: 20%;" data-iditem="{{ $tagRetira->idtagretira }}" data-status="RESERVADA" data-bs-toggle="tooltip" data-bs-title="Reservada"></div>
                                                        <div class="progress-bar {{ $tagRetira->status === 'CONCLUÍDO' ? 'bg-success' : ($tagRetira->status === 'EM ANDAMENTO' ? 'bg-info' : 'bg-secondary') }}" role="progressbar" style="height: 10px; width: 20%;" data-iditem="{{ $tagRetira->idtagretira }}" data-status="EM ANDAMENTO" data-bs-toggle="tooltip" data-bs-title="Em andamento"></div>
                                                        <div class="progress-bar {{ $tagRetira->status === 'CONCLUÍDO' ? 'bg-success' : 'bg-secondary' }}" role="progressbar" style="height: 10px; width: 20%;" data-iditem="{{ $tagRetira->idtagretira }}" data-status="CONCLUÍDO" data-bs-toggle="tooltip" data-bs-title="Concluído"></div>
                                                    </div>
                                                    <div>
                                                        <span id="status-{{ $tagRetira->idtagretira }}" style="font-size: .8rem; text-transform: capitalize">{{ Str::lower($tagRetira->status) }}</span>
                                                    </div>
                                                </td>
                                                <td class="align-middle text-center d-none">
                                                    <a rel="tooltip" class="btn btn-success btn-sm btn-link"
                                                        href="{{route('admin.tagsretira.edit', ['tagsretira' => $tagRetira])}}" data-original-title=""
                                                        title="">
                                                        <i class="material-icons">edit</i>
                                                        <div class="ripple-container"></div>
                                                    </a>
                                                    <form action="{{route('admin.tagsretira.destroy', ['tagsretira' => $tagRetira])}}" class="d-inline" method="POST">
                                                        @csrf
                                                        @method('delete')
                                                        <button type="button" class="btn btn-sm btn-danger btn-link"
                                                            data-original-title="" title=""
                                                            onclick="confirm('{{ __('Você tem certeza que deseja apagar esse Tag Retira ?') }}') ? this.parentElement.submit() : ''">
                                                            <i class="material-icons">close</i>
                                                            <div class="ripple-container"></div>
                                                        </button>
                                                    </form>
                                                </td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <x-footers.auth></x-footers.auth>
        </div>
    </main>
    <x-plugins></x-plugins>
</x-layout>
@include('partials.update-status-progress', ['route' => route('admin.tagsretira.update', ['tagsretira' => ':id']), 'redirect' => 0, 'options' => [
    'CANCELADO' => 'bg-danger',
    'PENDENTE' => 'bg-warning',
    'RESERVADA' => 'bg-dark',
    'EM ANDAMENTO' => 'bg-info',
    'CONCLUÍDO' => 'bg-success'
]])
@include('partials.filter-inativo', ['statusCustom' => 'CANCELADO', 'routeSearch' => route('admin.tagsretira.search'), 'routeIndex' => route('admin.tagsretira.index')])
