<meta name="csrf-token" content="{{ csrf_token() }}">
<input type="hidden" name="idtagtipo" value="{{ isset($tagTipo) ? $tagTipo->idtagtipo : '' }}">
<div class="card mb-4">
    <div class="card-header p-0 position-relative mt-n4 mx-3 z-index-2">
        <div class="bg-gradient-primary shadow-primary border-radius-lg pt-4 pb-3">
            <h5 class="mx-3">Tag Tipos</h5>
        </div>
    </div>
    <div class="card-body ">
        {{-- Messagens da session --}}
        @include('partials.session-message')
        @if ($errors->any() || session('error'))
            <div class="row">
                <div class="col-sm-12">
                    <div class="alert alert-danger">
                        <button type="button" class="close" data-dismiss="alert"
                                aria-label="Close">
                            <i class="tim-icons icon-simple-remove"></i>
                        </button>
                        <span>{{$errors->any() ? $errors->first() : session('error')}}</span>
                    </div>
                </div>
            </div>
        @endif

        <div class="row">
            @if (isset($tagTipo))
                <div class="col-md-9 col-lg-9">
                    <span class="badge badge-sm bg-light mb-3 text-dark"># <?=$tagTipo->idtag;?></span>
                </div>
                <div class="col-md-3 col-lg-3">
                    <span class="float-end badge badge-sm {{$bg_status}}"><?=$tagTipo->status;?></span>
                </div>
            @endif
        </div>
    </div>
</div>

<div class="row">
    <div class="col-md-6">
        <div class="card mb-4">
            <div class="card-body ">
                <div class="row">
                    <div class="col-md-12 col-lg-12">
                        <h4 class="mb-3 bg-light">Dados Cadastrais</h4>
                    </div>
                    <div class="col-12 col-lg-12">
                        <div class="row">
                            {{-- Empresa --}}
                            <div class="col-md-12">
                                <div class="input-group input-group-static my-3">
                                    <label class="ms-0">Empresa</label>
                                    <select class="form-control" name="idempresa">
                                        <option value="" disabled="disabled">- Selecionar -</option>
                                    @foreach($empresas as $empresa)
                                        <option value="{{ $empresa->idempresa }}" {{ ((isset($tagTipo) && $empresa->idempresa == $tagTipo->empresa->idempresa) || (old('idempresa') == $empresa->idempresa)) ? 'selected' : '' }}>{{$empresa->razaosocial}}</option>
                                    @endforeach
                                    </select>
                                </div>
                            </div>
                        </div>

                        {{-- TagTipo --}}
                        <div class="col-md-12">
                            <div class="input-group input-group-static my-3 {{ $errors->has('tagtipo') ? ' is-invalid' : '' }}">
                                <label id="label-prodserv">{{ __('Tag Tipo ') }}</label>
                                <input class="form-control{{ $errors->has('tagtipo') ? ' is-invalid' : '' }}"
                                name="tagtipo" id="input-tagtipo" type="text"
                                value="{{ isset($tagTipo) ? $tagTipo->tagtipo : old('tagtipo') }}" placeholder="{{ __('Tag Tipo') }}"
                                required="true" aria-required="true"/>
                                @if ($errors->has('tagtipo'))
                                    <span id="tagtipo-error" class="error text-danger"
                                        for="input-tagtipo">{{ $errors->first('tagtipo') }}</span>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        {{-- Status --}}
        <div class="col-md-12">
            @include('partials.status', ['model' => $tagTipo ?? null])
        </div>
    </div>

    <div class="col-md-6">
        <div class="card mb-4">
            <div class="card-body ">
                <div class="row">
                    <div class="col-md-12 col-lg-12">
                        <h4 class="mb-3 bg-light">Parâmetros</h4>
                    </div>
                    <div class="col-12 col-lg-12">
                        <div class="accordion d-flex flex-column" style="gap: .7rem;" id="accordionExample">
                            <div class="accordion-item border border-1 rounded-3 pe-2 ps-2">
                                <h2 class="accordion-header w-100">
                                    <button class="accordion-button d-flex align-items-center justify-content-between w-100" type="button" data-bs-toggle="collapse" data-bs-target="#collapseOne" aria-expanded="true" aria-controls="collapseOne">
                                        <span class="d-flex align-items-center justify-content-between w-100">
                                            <span>Especificações de Identificação</span>
                                            <i class="fa fa-chevron-down text-dark"></i>
                                        </span>
                                    </button>
                                </h2>
                                <div id="collapseOne" class="accordion-collapse collapse" data-bs-parent="#accordionExample">
                                    <div class="accordion-body">
                                        <div class="row ps-3">
                                            {{-- Marca --}}
                                            <div class="col-md-3">
                                                <div class="form-check form-switch">
                                                    <input class="form-check-input" {{ isset($tagTipo) && $tagTipo->marca ? 'checked' : ''  }} name="marca" type="checkbox" role="switch" id="flexSwitchCheckChecked">
                                                    <label class="form-check-label" for="flexSwitchCheckChecked">Marca</label>
                                                </div>
                                            </div>

                                            {{-- Modelo --}}
                                            <div class="col-md-3">
                                                <div class="form-check form-switch">
                                                    <input class="form-check-input" {{ isset($tagTipo) && $tagTipo->modelo ? 'checked' : '' }} name="modelo" type="checkbox" role="switch" id="switchModelo">
                                                    <label class="form-check-label" for="switchModelo">Modelo</label>
                                                </div>
                                            </div>

                                            {{-- Número de Série --}}
                                            <div class="col-md-3">
                                                <div class="form-check form-switch">
                                                    <input class="form-check-input" {{ isset($tagTipo) && $tagTipo->numeroserie ? 'checked' : '' }} name="numeroserie" type="checkbox" role="switch" id="switchNumeroSerie">
                                                    <label class="form-check-label" for="switchNumeroSerie">Número de Série</label>
                                                </div>
                                            </div>

                                            {{-- Ano de Fabricação --}}
                                            <div class="col-md-3">
                                                <div class="form-check form-switch">
                                                    <input class="form-check-input" {{ isset($tagTipo) && $tagTipo->anofabricacao ? 'checked' : '' }} name="anofabricacao" type="checkbox" role="switch" id="switchAnoFabricacao">
                                                    <label class="form-check-label" for="switchAnoFabricacao">Ano de Fabricação</label>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="accordion-item  border border-1 rounded-3 pe-2 ps-2">
                                <h2 class="accordion-header">
                                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseTwo" aria-expanded="false" aria-controls="collapseTwo">
                                        <span class="d-flex align-items-center justify-content-between w-100">
                                            <span>Dimensões</span>
                                            <i class="fa fa-chevron-down text-dark"></i>
                                        </span>
                                    </button>
                                </h2>
                                <div id="collapseTwo" class="accordion-collapse collapse" data-bs-parent="#accordionExample">
                                <div class="accordion-body">
                                    <div class="row ps-3">
                                        {{-- Altura --}}
                                        <div class="col-md-3">
                                            <div class="form-check form-switch">
                                                <input class="form-check-input" {{ isset($tagTipo) && $tagTipo->altura ? 'checked' : '' }} name="altura" type="checkbox" role="switch" id="switchAltura">
                                                <label class="form-check-label" for="switchAltura">Altura</label>
                                            </div>
                                        </div>

                                        {{-- Largura --}}
                                        <div class="col-md-3">
                                            <div class="form-check form-switch">
                                                <input class="form-check-input" {{ isset($tagTipo) && $tagTipo->largura ? 'checked' : '' }} name="largura" type="checkbox" role="switch" id="switchLargura">
                                                <label class="form-check-label" for="switchLargura">Largura</label>
                                            </div>
                                        </div>

                                        {{-- Comprimento --}}
                                        <div class="col-md-3">
                                            <div class="form-check form-switch">
                                                <input class="form-check-input" {{ isset($tagTipo) && $tagTipo->comprimento ? 'checked' : '' }} name="comprimento" type="checkbox" role="switch" id="switchComprimento">
                                                <label class="form-check-label" for="switchComprimento">Comprimento</label>
                                            </div>
                                        </div>

                                        {{-- Peso --}}
                                        <div class="col-md-3">
                                            <div class="form-check form-switch">
                                                <input class="form-check-input" {{ isset($tagTipo) && $tagTipo->peso ? 'checked' : '' }} name="peso" type="checkbox" role="switch" id="switchPeso">
                                                <label class="form-check-label" for="switchPeso">Peso</label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                </div>
                            </div>
                            <div class="accordion-item border border-1 rounded-3 pe-2 ps-2">
                                <h2 class="accordion-header">
                                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseThree" aria-expanded="false" aria-controls="collapseThree">
                                    <span class="d-flex align-items-center justify-content-between w-100">
                                        <span>Características</span>
                                        <i class="fa fa-chevron-down text-dark"></i>
                                    </span>
                                </button>
                                </h2>
                                <div id="collapseThree" class="accordion-collapse collapse" data-bs-parent="#accordionExample">
                                <div class="accordion-body">
                                    <div class="row ps-3">
                                        {{-- Cor --}}
                                        <div class="col-md-4">
                                            <div class="form-check form-switch">
                                                <input class="form-check-input" {{ isset($tagTipo) && $tagTipo->cor ? 'checked' : '' }} name="cor" type="checkbox" role="switch" id="switchCor">
                                                <label class="form-check-label" for="switchCor">Cor</label>
                                            </div>
                                        </div>

                                        {{-- Material --}}
                                        <div class="col-md-4">
                                            <div class="form-check form-switch">
                                                <input class="form-check-input" {{ isset($tagTipo) && $tagTipo->material ? 'checked' : '' }} name="material" type="checkbox" role="switch" id="switchMaterial">
                                                <label class="form-check-label" for="switchMaterial">Material</label>
                                            </div>
                                        </div>

                                        {{-- Combustível --}}
                                        <div class="col-md-4">
                                            <div class="form-check form-switch">
                                                <input class="form-check-input" {{ isset($tagTipo) && $tagTipo->combustivel ? 'checked' : '' }} name="combustivel" type="checkbox" role="switch" id="switchCombustivel">
                                                <label class="form-check-label" for="switchCombustivel">Combustível</label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                </div>
                            </div>
                            <div class="accordion-item border border-1 rounded-3 pe-2 ps-2">
                                <h2 class="accordion-header">
                                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseFour" aria-expanded="false" aria-controls="collapseFour">
                                        <span class="d-flex align-items-center justify-content-between w-100">
                                            <span>Manutenção</span>
                                            <i class="fa fa-chevron-down text-dark"></i>
                                        </span>
                                    </button>
                                </h2>
                                <div id="collapseFour" class="accordion-collapse collapse" data-bs-parent="#accordionExample">
                                    <div class="accordion-body">
                                        <div class="row ps-3">
                                            {{-- Data de Manutenção --}}
                                            <div class="col-md-4">
                                                <div class="form-check form-switch">
                                                    <input class="form-check-input" {{ isset($tagTipo) && $tagTipo->datamanutencao ? 'checked' : '' }} name="datamanutencao" type="checkbox" role="switch" id="switchDataManutencao">
                                                    <label class="form-check-label" for="switchDataManutencao">Data de Manutenção</label>
                                                </div>
                                            </div>

                                            {{-- Data Próxima Manutenção --}}
                                            <div class="col-md-4">
                                                <div class="form-check form-switch">
                                                    <input class="form-check-input" {{ isset($tagTipo) && $tagTipo->dataproximamanutencao ? 'checked' : '' }} name="dataproximamanutencao" type="checkbox" role="switch" id="switchDataProximaManutencao">
                                                    <label class="form-check-label" for="switchDataProximaManutencao">Data Próxima Manutenção</label>
                                                </div>
                                            </div>

                                            {{-- Garantia --}}
                                            <div class="col-md-4">
                                                <div class="form-check form-switch">
                                                    <input class="form-check-input" {{ isset($tagTipo) && $tagTipo->garantia ? 'checked' : '' }} name="garantia" type="checkbox" role="switch" id="switchGarantia">
                                                    <label class="form-check-label" for="switchGarantia">Garantia</label>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="accordion-item border border-1 rounded-3 pe-2 ps-2">
                                <h2 class="accordion-header">
                                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseFive" aria-expanded="false" aria-controls="collapseFive">
                                        <span class="d-flex align-items-center justify-content-between w-100">
                                            <span>Especificações Técnicas</span>
                                            <i class="fa fa-chevron-down text-dark"></i>
                                        </span>
                                    </button>
                                </h2>
                                <div id="collapseFive" class="accordion-collapse collapse" data-bs-parent="#accordionExample">
                                    <div class="accordion-body">
                                        <div class="row ps-3">
                                            {{-- Processador --}}
                                            <div class="col-md-3">
                                                <div class="form-check form-switch">
                                                    <input class="form-check-input" {{ isset($tagTipo) && $tagTipo->processador ? 'checked' : '' }} name="processador" type="checkbox" role="switch" id="switchProcessador">
                                                    <label class="form-check-label" for="switchProcessador">Processador</label>
                                                </div>
                                            </div>

                                            {{-- Memória RAM --}}
                                            <div class="col-md-3">
                                                <div class="form-check form-switch">
                                                    <input class="form-check-input" {{ isset($tagTipo) && $tagTipo->memoriaram ? 'checked' : '' }} name="memoriaram" type="checkbox" role="switch" id="switchMemoriaRAM">
                                                    <label class="form-check-label" for="switchMemoriaRAM">Memória RAM</label>
                                                </div>
                                            </div>

                                            {{-- Voltagem --}}
                                            <div class="col-md-3">
                                                <div class="form-check form-switch">
                                                    <input class="form-check-input" {{ isset($tagTipo) && $tagTipo->voltagem ? 'checked' : '' }} name="voltagem" type="checkbox" role="switch" id="switchVoltagem">
                                                    <label class="form-check-label" for="switchVoltagem">Voltagem</label>
                                                </div>
                                            </div>

                                            {{-- Sistema Operacional --}}
                                            <div class="col-md-3">
                                                <div class="form-check form-switch">
                                                    <input class="form-check-input" {{ isset($tagTipo) && $tagTipo->sistemaoperacional ? 'checked' : '' }} name="sistemaoperacional" type="checkbox" role="switch" id="switchSistemaOperacional">
                                                    <label class="form-check-label" for="switchSistemaOperacional">Sistema Operacional</label>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<div class="row">
    <div class="col-md-12">
        <div class="card mb-4">
            <div class="card-footer ml-auto mr-auto">
                <button id="submit-button" type="submit" class="btn btn-success">{{ __((isset($tagTipo) ? 'Atualizar' : 'Adicionar').' Tag Tipo') }}</button>
                <a href="{{ route('admin.tagtipos.index') }}"
                        class="btn btn-light">{{ __('Voltar') }}</a>
                @if(isset($tagTipo))
                <a class="btn bg-gradient-dark" href="{{route('admin.tagtipos.create')}}"><i
                            class="material-icons text-sm">add</i>&nbsp;&nbsp;Nova Tag Tipo</a>
                @endif
            </div>
        </div>
    </div>
</div>
