<meta name="csrf-token" content="{{ csrf_token() }}">
<div class="card mb-4">
    <div class="card-header p-0 position-relative mt-n4 mx-3 z-index-2">
        <div class="bg-gradient-primary shadow-primary border-radius-lg pt-4 pb-3">
            <h5 class="mx-3">Tenants</h5>
        </div>
    </div>
    <div class="card-body ">
        {{-- Messagens da session --}}
        @include('partials.session-message')
        @if ($errors->any() || session('error'))
            <div class="row">
                <div class="col-sm-12">
                    <div class="alert alert-danger">
                        <button type="button" class="close" data-dismiss="alert"
                                aria-label="Close">
                            <i class="tim-icons icon-simple-remove"></i>
                        </button>
                        <span>{{$errors->any() ? $errors->first() : session('error')}}</span>
                    </div>
                </div>
            </div>
        @endif

        <div class="row">
            @if (isset($tenant))
                <div class="col-md-9 col-lg-9">
                    <span class="badge badge-sm bg-light mb-3 text-dark"># <?=$tenant->idtenant;?></span>
                </div>
                <div class="col-md-3 col-lg-3">
                    <span class="float-end badge badge-sm {{$bg_status}}"><?=$tenant->status;?></span>
                </div>
            @endif
        </div>
    </div>
</div>

<div class="row">
    <div class="col-md-6">
        <div class="card mb-4">
            <div class="card-body ">
                <div class="row">
                    <div class="col-md-12 col-lg-12">
                        <h4 class="mb-3 bg-light">Dados Cadastrais</h4>
                    </div>
                    <div class="col-12 col-lg-12">
                        <div class="row">
                            {{-- Consultor --}}
                            <div class="col-md-8">
                                <div class="input-group input-group-static my-3">
                                    <label class="ms-0">Consultor</label>
                                    <select class="form-control" name="idpessoa" id="idpessoa">
                                        <option value="">Sem vínculo</option>
                                    @foreach($pessoas as $pessoa)
                                        <option value="{{ $pessoa->idpessoa }}" {{ ((isset($tenant) && $pessoa->idpessoa == $tenant->idpessoa) || (old('idpessoa') == $pessoa->idpessoa)) ? 'selected' : '' }}>{{$pessoa->nome}}</option>
                                    @endforeach
                                    </select>
                                </div>
                            </div>
                            {{-- Tipo Pessoa --}}
                            <div class="col-md-4">
                                <div class="input-group input-group-static my-3">
                                    <label class="ms-0">Tipo</label>
                                    <select class="form-control" name="tipo">
                                        <option value="">- Selecione -</option>
                                    @foreach($tipos as $value => $label)
                                        <option value="{{ $value }}" {{ ((isset($tenant) && $value == $tenant->tipo) || (old('tipo') == $value)) ? 'selected' : '' }}>{{$label}}</option>
                                    @endforeach
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <div class="input-group input-group-static my-3 {{ $errors->has('tagtipo') ? ' is-invalid' : '' }}">
                                    <label id="label-prodserv">{{ __('Nome') }}</label>
                                    <input class="form-control{{ $errors->has('nome') ? ' is-invalid' : '' }}"
                                    name="nome" id="input-nome" type="text"
                                    value="{{ isset($tenant) ? $tenant->nome : old('nome') }}" placeholder="{{ __('Nome') }}"
                                    required="true" aria-required="true"/>
                                    @if ($errors->has('nome'))
                                        <span id="nome-error" class="error text-danger"
                                            for="input-nome">{{ $errors->first('nome') }}</span>
                                    @endif
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            {{-- Admin Tenant --}}
                            <div class="col-md-12">
                                <div class="form-check form-switch">
                                    <input class="form-check-input" {{ isset($tenant) && $tenant->is_admin_tenant ? 'checked' : ''  }} name="is_admin_tenant" type="checkbox" role="switch" id="flexSwitchCheckChecked">
                                    <label class="form-check-label" for="flexSwitchCheckChecked">Tenant Admin</label>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    {{-- Status --}}
    <div class="col-md-6">
        @include('partials.status', ['model' => $tenant ?? null])
    </div>
</div>
<div class="row">
    <div class="col-md-12">
        <div class="card mb-4">
            <div class="card-footer ml-auto mr-auto">
                <button id="submit-button" type="submit" class="btn btn-success">{{ __((isset($tenant) ? 'Atualizar' : 'Adicionar').' Tenant') }}</button>
                <a href="{{ route('admin.tenants.index') }}"
                        class="btn btn-light">{{ __('Voltar') }}</a>
                @if(isset($tenant))
                <a class="btn bg-gradient-dark" href="{{route('admin.tenants.create')}}"><i
                            class="material-icons text-sm">add</i>&nbsp;&nbsp;Novo Tenant</a>
                @endif
            </div>
        </div>
    </div>
</div>
