<meta name="csrf-token" content="{{ csrf_token() }}">
<div class="card mb-4">
    <div class="card-header p-0 position-relative mt-n4 mx-3 z-index-2">
        <div class="bg-gradient-primary shadow-primary border-radius-lg pt-4 pb-3">
            <h5 class="mx-3">Tipos de Produto/Serviço</h5>
        </div>
    </div>
    <div class="card-body ">
    {{-- Messagens da session --}}
        @include('partials.session-message')
        @if ($errors->any() || session('error'))
        <div class="row">
            <div class="col-sm-12">
                <div class="alert alert-danger">
                    <button type="button" class="close" data-dismiss="alert"
                            aria-label="Close">
                        <i class="tim-icons icon-simple-remove"></i>
                    </button>
                    <span>{{$errors->any() ? $errors->first() : session('error')}}</span>
                </div>
            </div>
        </div>
            @endif

        <div class="row">
            @if (isset($tipoProdutoServico))
            <div class="col-md-9 col-lg-9"> 
                <span class="badge badge-sm bg-light mb-3 text-dark"># <?=$tipoProdutoServico->idprodservtipo;?></span>
            </div>
            <div class="col-md-3 col-lg-3">
                <span class="float-end badge badge-sm {{$bg_status}}"><?=$tipoProdutoServico->status;?></span>
            </div>
        @endif
        </div>
    </div>
</div>
<div class="card mb-4">
    <div class="card-body ">
        <div class="row">
            <div class="col-md-12 col-lg-12">
                <h4 class="mb-3 bg-light">Dados Cadastrais</h4>
            </div>
            <div class="col-md-12 col-lg-12">
            {{-- Empresa --}}
                <div class="col-8">
                    <div class="input-group input-group-static my-3">
                        <label class="ms-0">Empresa</label>
                        <select class="form-control" name="idempresa">
                            <option value="" disabled="disabled">- Selecionar -</option>
                        @foreach($empresas as $empresa)
                            <option value="{{ $empresa->idempresa }}" {{ ((isset($tipoProdutoServico) && $empresa->idempresa == $tipoProdutoServico->empresa->idempresa) || (old('idempresa') == $empresa->idempresa)) ? 'selected' : '' }}>{{$empresa->razaosocial}}</option>
                        @endforeach
                        </select>
                    </div>
                </div>
                {{-- Tipo Produto / Serviço --}}
                <div class="col-8">
                    <div class="input-group input-group-static my-3 {{ $errors->has('prodservtipo') ? ' is-invalid' : '' }}">
                        <label>{{ __('Tipo Produto / Serviço') }}</label>
                        <input class="form-control prodservtipo {{ $errors->has('prodservtipo') ? ' is-invalid' : '' }}"
                        name="prodservtipo" id="input-prodservtipo" type="text"
                        value="{{ isset($tipoProdutoServico) ? $tipoProdutoServico->prodservtipo : old('prodservtipo') }}" placeholder="{{ __('Tipo Produto / Serviço') }}"
                        required="true" aria-required="true"/>
                        @if ($errors->has('prodservtipo'))
                            <span id="prodservtipo-error" class="error text-danger"
                                for="input-prodservtipo">{{ $errors->first('prodservtipo') }}</span>
                        @endif
                    </div>
                </div>
                
            </div>
        </div>
    </div>
</div>

<div class="row">
    <div class="col-md-6">
        @include('partials.status', ['model' => $tipoProdutoServico ?? null])
    </div>
    @if(isset($tipoProdutoServico))
    <div class="col-md-6">
        @include('partials.upload', ['model' => $tipoProdutoServico])
    </div>
    @endif
</div>

<div class="card mb-4">
    <div class="card-footer ml-auto mr-auto">
        <button id="submit-button" type="submit" class="btn btn-success">{{ __((isset($tipoProdutoServico) ? 'Atualizar' : 'Adicionar').' Tipo Produto / Serviço') }}</button>
        <a href="{{ route('admin.tipo-produto-servico.index') }}"
                   class="btn btn-light">{{ __('Voltar') }}</a>
        @if(isset($tipoProdutoServico))
        <a class="btn bg-gradient-dark" href="{{route('admin.tipo-produto-servico.create')}}"><i
                    class="material-icons text-sm">add</i>&nbsp;&nbsp;Novo Tipo Produto/Servico</a>
        @endif
    </div>
</div>

@push('js')
    @include('partials.upload-js')
@endpush
{{-- @TODO: criar mascaras --}}
