<x-layout bodyClass="g-sidenav-show  bg-dark-silk">
    <x-navbars.sidebar activePage="transferencias"></x-navbars.sidebar>
    <main class="main-content position-relative max-height-vh-100 h-100 border-radius-lg ">
        <!-- Navbar -->
        <x-navbars.navs.auth titlePage="Transferências"></x-navbars.navs.auth>
        <!-- End Navbar -->
        <div class="container-fluid py-4">
            <div class="row">
                <div class="col-12">
                    <div class="card my-4">
                        <div class="card-header p-0 position-relative mt-n4 mx-3 z-index-2">
                            <div class="bg-gradient-primary shadow-primary border-radius-lg pt-4 pb-3">
                                <h5 class="mx-3">Transferências</h5>
                            </div>
                        </div>
                        <div class="row m-0">
                            <div class="col-6 d-flex align-items-center justify-content-between text-left">
                                <form action="{{route('admin.transferencias.search')}}" class="navbar-form d-flex align-items-center gap-3 col-7" method="get">
                                    <div class="col-4 input-group input-group-outline d-flex align-items-center">
                                        <input type="text" name="search" class="form-control"
                                               placeholder="Buscar pelo nome do transferencias..." value="{{ \Request::get('search') }}">
                                        <button type="submit" class="btn btn-primary btn-round btn-just-icon m-0">
                                            <i class="material-icons">search</i>
                                            <div class="ripple-container"></div>
                                        </button>
                                        <a href="{{ route('admin.transferencias.index', ['clear' => 'true']) }}" class="btn btn-dark btn-round btn-just-icon m-0">
                                            <i class="material-icons">delete</i>
                                        </a>
                                    </div>
                                    <div class="col-3">
                                        <select name="status" id="status-search" class="form-control border border-2 text-center" style="border-radius: 20px;">
                                            <option value="" disabled selected>Filtro</option>
                                            @foreach ($statusOptions as $status => $value)
                                                <option value="{{ $status }}" {{ \Request::get('status') === $status ? 'selected' : '' }}>{{ $value }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                    <div class="col-auto">
                                        <input type="checkbox" class="btn-check"  id="btn-check-inativo" autocomplete="off"
                                        {{ \Request::get('status') === 'INATIVO' ? 'checked' : '' }}>
                                        <label class="btn btn-outline-info shadow-sm p-0 m-0 pt-2 pb-2 ps-4 pe-4" style="text-transform: none; border-radius: 20px; font-size: .9rem" for="btn-check-inativo"><i class="fa fa-times-circle-o" aria-hidden="true"></i> Inativo <i class="fa fa-times ps-3 {{ \Request::get('status') === 'INATIVO' ? '' : 'd-none' }}" style="font-weight: 600;" id="btn-check-hide" aria-hidden="true"></i></label>
                                    </div>
                                </form>
                            </div>
                            <div class="col-6 my-3 text-end">
                                <div class="m-0 d-flex align-items-center justify-content-end">
                                    <button type="button" class="btn btn-primary m-0" data-bs-toggle="modal" data-bs-target="#modalTransferencia">
                                        <i class="fa fa-exchange me-2" aria-hidden="true"></i> Transferência
                                    </button>
                                </div>
                            </div>
                        </div>
                        <div class="card-body px-0 pb-2">
                            {{-- Messagens da session --}}
                            @include('partials.session-message')
                            <div class="table-responsive p-0">
                                <table class="table align-items-center mb-0">
                                    <thead>
                                        <tr>
                                            <th
                                                class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                                Empresa
                                            </th>
                                            <th
                                                class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                                Agência Origem
                                            </th>
                                            <th
                                                class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                                Agência Destino
                                            </th>
                                            <th
                                                class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                                Valor
                                            </th>
                                            <th
                                                class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                                Data transferência
                                            </th>
                                            <th class="text-secondary opacity-7 d-none"></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($nfs as $transferkey => $group)
                                            <tr
                                                data-data="{{ $group['nf1']->dataemissao }}"
                                                data-valor="{{ $group['nf1']->valornf }}"
                                                data-observacao="{{ $group['nf1']->observacao }}"
                                                data-agencia-saida="{{ $group['nf1']->idagencia }}"
                                                data-agencia-entrada="{{ $group['nf2']->idagencia }}"
                                                data-centro-custo="{{ $group['nf1']->nfitem[0]->idgrupoitem }}"
                                                style="cursor: pointer;">
                                                <td>
                                                    <div class="d-flex px-2 py-1">
                                                        <div class="d-flex flex-column justify-content-center">
                                                            <p class="mb-0 text-sm">{{ $group['nf1']->empresa->sigla }}</p>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>
                                                    <div class="d-flex px-2 py-1">
                                                        <div class="d-flex flex-column justify-content-center">
                                                            <p class="mb-0 text-sm">{{ $group['nf1']->agencia->nome }}</p>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>
                                                    <div class="d-flex px-2 py-1">
                                                        <div class="d-flex flex-column justify-content-center">
                                                            <p class="mb-0 text-sm">{{ $group['nf2']->agencia->nome }}</p>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>
                                                    <div class="d-flex px-2 py-1">
                                                        <div class="d-flex flex-column justify-content-center">
                                                            <p class="mb-0 text-sm">{{ number_format($group['nf1']->valornf, 2, ',', '.') }}</p>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>
                                                    <div class="d-flex px-2 py-1">
                                                        <div class="d-flex flex-column justify-content-center">
                                                            <p class="mb-0 text-sm">{{ Carbon\Carbon::parse($group['nf1']->dataemissao)->format('d/m/Y') }}</p>
                                                        </div>
                                                    </div>
                                                </td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <x-footers.auth></x-footers.auth>
        </div>
    </main>
    <x-plugins></x-plugins>
</x-layout>
@include('partials.filter-inativo', ['routeSearch' => route('admin.transferencias.search'), 'routeIndex' => route('admin.transferencias.index')])
@include('partials.agencia-transferencia')
<script>
    $(document).ready(function() {
        // Passar os dados para o modal
        $('.table tbody tr td').on('click', function() {
            // recupera os dados do tr
            let data = $(this).closest('tr').data();

            // define todos os inputs e selects como readonly
            $('#modalTransferencia').find('input').prop('readonly', true);
            $('#modalTransferencia').find('select').prop('disabled', true);

            // adiciona um subtitle no modal

            $('#modalTransferencia').find('.modal-title').text('Transferência realizada');
            $('#modalTransferencia').find('.modal-header').after('<h6 class="ps-3 pt-3 fw-normal subtitle">Não é possivel alterar os dados, apenas visualizar.</h6>');

            // preenche os inputs com os dados recebidos
            $('#modalTransferencia').find('input[name="datatransferencia"]').val(new Date(data['data']).toISOString().split('T')[0]);
            $('#modalTransferencia').find('input[name="valortransferencia"]').val(parseFloat(data['valor']).toFixed(2).replace('.', ','));
            $('#modalTransferencia').find('input[name="observacaotransferencia"]').val(data['observacao']);
            // Seleciona os options de acordo com os dados
            $('#modalTransferencia').find('select[name="agenciasaida"]').val(data['agenciaSaida']);
            $('#modalTransferencia').find('select[name="agenciaentrada"]').val(data['agenciaEntrada']);
            $('#modalTransferencia').find('select[name="centrodecustotransferencia"]').val(data['centroCusto']);

            // abre o modal
            $('#modalTransferencia').modal('show');

            // remove os botões abrir o modal
            $('#modalTransferencia').find('hr').hide();
            $('#modalTransferencia').find('button[type="button"]').hide();
            $('#modalTransferencia').find('button[type="submit"]').hide();

            // sempre que o modal fechar, limpar os dados
            $('#modalTransferencia').on('hide.bs.modal', function() {
                $('#modalTransferencia').find('input[name="datatransferencia"]').val('');
                $('#modalTransferencia').find('input[name="valortransferencia"]').val('');
                $('#modalTransferencia').find('input[name="observacaotransferencia"]').val('');
                $('#modalTransferencia').find('select[name="agenciasaida"]').val('');
                $('#modalTransferencia').find('select[name="agenciaentrada"]').val('');
                $('#modalTransferencia').find('select[name="centrodecustotransferencia"]').val('');


                // mostra os botões abrir o modal novamente
                setTimeout(() => {
                    $('#modalTransferencia').find('hr').show();
                    $('#modalTransferencia').find('button[type="button"]').show();
                    $('#modalTransferencia').find('button[type="submit"]').show();

                    // volta os inputs e selects como readonly
                    $('#modalTransferencia').find('input').prop('readonly', false);
                    $('#modalTransferencia').find('select').prop('disabled', false);

                    // remove o subtitle
                    $('#modalTransferencia').find('.modal-title').text('Transferência entre agências');
                    $('#modalTransferencia').find('.subtitle').remove();
                }, 500);
            })
        });
    });
</script>
