@push('css')
    {{-- Select2 --}}
    <link rel="stylesheet" href="{{ asset('assets/css/select2.min.css') }}">
@endpush
<meta name="csrf-token" content="{{ csrf_token() }}">

<div class="card mb-4">
    <div class="card-header p-0 position-relative mt-n4 mx-3 z-index-2">
        <div class="bg-gradient-primary shadow-primary border-radius-lg pt-4 pb-3">
            <h5 class="mx-3">Gerenciamento de Usuários</h5>
        </div>
    </div>
    <div class="card-body ">
    {{-- Messagens da session --}}
        @include('partials.session-message')
        @if ($errors->any() || session('error'))
        <div class="row">
            <div class="col-sm-12">
                <div class="alert alert-danger">
                    <button type="button" class="close" data-dismiss="alert"
                            aria-label="Close">
                        <i class="tim-icons icon-simple-remove"></i>
                    </button>
                    <span>{{$errors->any() ? $errors->first() : session('error')}}</span>
                </div>
            </div>
        </div>
        @endif

        <div class="row">
            @if (isset($user))
            <div class="col-md-9 col-lg-9">
                <span class="badge badge-sm bg-light mb-3 text-dark"># <?=$user->id;?></span>
            </div>
            <div class="col-md-3 col-lg-3">
                <span class="float-end badge badge-sm {{$bg_status}}"><?=$user->status;?></span>
            </div>
            @endif
        </div>
    </div>
</div>
<div class="row">
    <div class="col-md-6">
        <div class="card mb-4">
            <div class="card-body">
                <div class="row">
                    <div class="col-md-12 col-lg-12">
                        <h4 class="mb-3 bg-light">Dados do Usuário</h4>
                    </div>
                    <div class="col-md-12 col-lg-12">
                        <div class="row">
                            {{-- Nome --}}
                            <div class="col-md-4">
                            <div class="input-group input-group-static my-3 {{ $errors->has('name') ? ' is-invalid' : '' }}">
                                    <label>{{ __('Nome') }}</label>
                                    <input class="form-control"
                                            name="name" id="input-name" type="text"
                                            placeholder="{{ __('Nome') }}" value="{{ isset($user) ? $user->name : old('nome') }}"
                                            required="true" aria-required="true"/>
                                    @if ($errors->has('name'))
                                        <span id="name-error" class="error text-danger"
                                                for="input-name">{{ $errors->first('name') }}</span>
                                    @endif
                                </div>
                            </div>

                            {{-- Email --}}
                            <div class="col-md-4">
                                <div class="input-group input-group-static my-3 {{ $errors->has('email') ? ' is-invalid' : '' }}">
                                    <label>{{ __('E-mail') }}</label>
                                    <input class="form-control"
                                            name="email" id="input-email" type="email"
                                            placeholder="{{ __('Email') }}"
                                        value="{{ isset($user) ? $user->email : old('email') }}"/>
                                    @if ($errors->has('email'))
                                        <span id="email-error" class="error text-danger"
                                                for="input-email">{{ $errors->first('email') }}</span>
                                    @endif
                                </div>
                            </div>
                            {{-- Username --}}
                            <div class="col-md-4">
                                <div class="input-group input-group-static my-3 {{ $errors->has('username') ? ' is-invalid' : '' }}">
                                    <label>{{ __('Usuário') }}</label>
                                    <input class="form-control"
                                            name="username" id="input-username" type="text"
                                            placeholder="{{ __('username') }}"
                                        value="{{ isset($user) ? $user->username : old('username') }}" required/>
                                    @if ($errors->has('username'))
                                        <span id="username-error" class="error text-danger"
                                                for="input-username">{{ $errors->first('username') }}</span>
                                    @endif
                                </div>
                            </div>
                            {{-- Tipo --}}
                            <div class="col-md-4">
                                <div class="input-group input-group-static my-3 {{ $errors->has('role_id') ? ' is-invalid' : '' }}">
                                    <label>{{ __('Tipo de Acesso') }}</label>
                                    <select class="form-control" name="role_id" id="input-role_id"
                                            required="true" aria-required="true">
                                            @foreach($roles as $role)
                                            <option class="text-dark" value="{{$role->id}}"
                                                {{ (isset($user) && $user->hasRole($role->name)) ? 'selected' : '' }}>
                                                {{$role->name}}
                                            </option>
                                            @endforeach
                                    </select>
                                </div>
                            </div>

                            @if (Auth::user()->tenant->is_admin_tenant)
                            {{-- Tipo de Pessoa --}}
                            <div class="col-md-4">
                                <div class="input-group input-group-static my-3 {{ $errors->has('role_id') ? ' is-invalid' : '' }}">
                                    <label>{{ __('Cadastro de Representante') }}</label>
                                    <select class="form-control" name="idrepresentante" id="input-idrepresentante">
                                        <option value="" selected disabled="disabled">- Selecionar -</option>
                                        @foreach($pessoas as $pessoa)
                                            <option class="text-dark" value="{{$pessoa->idpessoa}}"
                                                {{ (isset($user) && $user->idrepresentante == $pessoa->idpessoa) ? 'selected' : '' }}>
                                                {{$pessoa->nome}}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-6">
        <div class="card mb-4">
            <div class="card-body ">
                <div class="row">
                    <div class="col-md-12 col-lg-12">
                        <h4 class="mb-3 bg-light">Alterar Senha</h4>
                    </div>
                    <div class="col-md-12 col-lg-12">
                        <div class="row">
                            {{-- Senha --}}
                            <div class="col-md-6">
                                <div class="input-group input-group-static my-3 {{ $errors->has('password') ? ' is-invalid' : '' }}">
                                    <label for="input-password">{{ __(' Senha') }}</label>
                                    <input class="form-control"
                                        input type="password" name="password" id="input-password"
                                        placeholder="{{ __('Senha') }}"/>
                                    @if ($errors->has('password'))
                                        <span id="name-error" class="error text-danger"
                                                for="input-name">{{ $errors->first('password') }}</span>
                                    @endif
                                </div>
                            </div>
                            {{-- Confirmar Senha --}}
                            <div class="col-md-6">
                                <div class="input-group input-group-static my-3 {{ $errors->has('password_confirmation') ? ' is-invalid' : '' }}">
                                        <label for="input-password-confirmation">{{ __('Confirmar senha') }}</label>
                                        <input class="form-control" name="password_confirmation"
                                                id="input-password-confirmation" type="password"
                                                placeholder="{{ __('Confirmar senha') }}"/>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="row">
    <div class="col-md-6">
        @include('partials.status', ['model' => $user ?? null])
    </div>
    @if(isset($user))
    <div class="col-md-6">
        @include('partials.upload', ['model' => $user])
    </div>
    @endif
</div>

<div class="row">
    <div class="col-md-12">
        <div class="card mb-4">
            <div class="card-footer ml-auto mr-auto">
                <button id="submit-button" type="submit" class="btn btn-success">{{ __((isset($user) ? 'Atualizar' : 'Adicionar').' Usuário') }}</button>
                <a href="{{ route('admin.users.index') }}"
                        class="btn btn-light">{{ __('Voltar') }}</a>
            </div>
        </div>
    </div>
</div>

@push('js')
<script>
$(document).ready(function() {
    $('#submit-button').click(function(event) {
        var password = $('#input-password').val();
        var confirmPassword = $('#input-password-confirmation').val();

        if (password !== confirmPassword) {
            event.preventDefault(); // Impede o envio do formulário
            alert("A senha e a confirmação de senha não correspondem.");
        }
    });
});
</script>
@include('partials.upload-js')
@endpush
{{-- @TODO: criar mascaras --}}
