@php
    use Carbon\Carbon;
@endphp
@push('css')
    {{-- Select2 --}}
    <link rel="stylesheet" href="{{ asset('assets/css/select2.min.css') }}">
@endpush
<div class="card mb-4">
    <div class="card-header p-0 position-relative mt-n4 mx-3 z-index-2">
        <div class="bg-gradient-primary shadow-primary border-radius-lg pt-4 pb-3">
            <h5 class="mx-3">Gerenciamento de Frota</h5>
        </div>
    </div>
    <div class="card-body ">
    {{-- Messagens da session --}}
        @include('partials.session-message')
        @if ($errors->any() || session('error'))
        <div class="row">
            <div class="col-sm-12">
                <div class="alert alert-danger">
                    <button type="button" class="close" data-dismiss="alert"
                            aria-label="Close">
                        <i class="tim-icons icon-simple-remove"></i>
                    </button>
                    <span>{{$errors->any() ? $errors->first() : session('error')}}</span>
                </div>
            </div>
        </div>
            @endif

        <div class="row">
            @if (isset($veiculo))
            <div class="col-md-9 col-lg-9">
                <span class="badge badge-sm bg-light mb-3 text-dark"># <?=$veiculo->idveiculo;?></span>
            </div>
            <div class="col-md-3 col-lg-3">
                <span class="float-end badge badge-sm {{$bg_status}}"><?=$veiculo->status;?></span>
            </div>
        @endif
        </div>
    </div>
</div>

<div class="row">
    <div class="col-md-6">
        <div class="card mb-4">
            <div class="card-body ">
                <div class="row">
                    <div class="col-md-12 col-lg-12">
                        <h4 class="mb-3 bg-light">Dados Cadastrais</h4>
                    </div>
                    <div class="col-12 col-lg-12">
                        <div class="row">
                            {{-- Empresa --}}
                            <div class="col-6">
                                <div class="input-group input-group-static my-3">
                                    <label class="ms-0">Empresa</label>
                                    <select class="form-control" name="idempresa">
                                        <option value="" disabled="disabled">- Selecionar -</option>
                                    @foreach($empresas as $empresa)
                                        <option value="{{ $empresa->idempresa }}" {{ ((isset($veiculo) && $empresa->idempresa == $veiculo->empresa->idempresa) || (old('idempresa') == $empresa->idempresa)) ? 'selected' : '' }}>{{$empresa->razaosocial}}</option>
                                    @endforeach
                                    </select>
                                </div>
                            </div>
                            {{-- Pessoa --}}
                            <div class="col-6">
                                <div class="input-group input-group-static my-3">
                                    <label class="ms-0">Responsável</label>
                                    <select class="form-control" name="idpessoa">
                                        <option value="">- Selecionar -</option>
                                        @foreach($pessoas as $pessoa)
                                            <option value="{{ $pessoa->idpessoa }}" {{ ((isset($veiculo) && $veiculo->idpessoa && $pessoa->idpessoa == $veiculo->pessoa->idpessoa) || (old('idpessoa') == $pessoa->idpessoa)) ? 'selected' : '' }}>{{$pessoa->nome}}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                        {{-- Rastreador --}}
                        <div class="col-6">
                            <div class="input-group input-group-static my-3 {{ $errors->has('rastreador') ? ' is-invalid' : '' }}">
                                <label>{{ __('Rastreador') }}</label>
                                <input class="form-control placa {{ $errors->has('rastreador') ? ' is-invalid' : '' }}"
                                name="rastreador" id="input-rastreador" type="text"
                                value="{{ isset($veiculo) ? $veiculo->rastreador : old('rastreador') }}" placeholder="{{ __('Rastreador') }}"
                                />
                                @if ($errors->has('rastreador'))
                                    <span id="rastreador-error" class="error text-danger"
                                        for="input-rastreador">{{ $errors->first('rastreador') }}</span>
                                @endif
                            </div>
                        </div>
                        {{-- Crv --}}
                        <div class="col-6">
                            <div class="input-group input-group-static my-3 {{ $errors->has('crv') ? ' is-invalid' : '' }}">
                                <label>{{ __('Crv') }}</label>
                                <input class="form-control crv {{ $errors->has('crv') ? ' is-invalid' : '' }}"
                                name="crv" id="input-crv" type="text"
                                value="{{ isset($veiculo) ? $veiculo->crv : old('crv') }}" placeholder="{{ __('Crv') }}"
                                />
                                @if ($errors->has('crv'))
                                    <span id="crv-error" class="error text-danger"
                                        for="input-crv">{{ $errors->first('crv') }}</span>
                                @endif
                            </div>
                        </div>
                        {{-- Renavan --}}
                        <div class="col-6">
                            <div class="input-group input-group-static my-3 {{ $errors->has('renavan') ? ' is-invalid' : '' }}">
                                <label>{{ __('Renavan') }}</label>
                                <input class="form-control renavan {{ $errors->has('renavan') ? ' is-invalid' : '' }}"
                                name="renavan" id="input-renavan" type="text"
                                value="{{ isset($veiculo) ? $veiculo->renavan : old('renavan') }}" placeholder="{{ __('Renavan') }}"
                                />
                                @if ($errors->has('renavan'))
                                    <span id="renavan-error" class="error text-danger"
                                        for="input-renavan">{{ $errors->first('renavan') }}</span>
                                @endif
                            </div>
                        </div>
                        {{-- Chassi --}}
                        <div class="col-6">
                            <div class="input-group input-group-static my-3 {{ $errors->has('chassi') ? ' is-invalid' : '' }}">
                                <label>{{ __('Chassi') }}</label>
                                <input class="form-control chassi {{ $errors->has('chassi') ? ' is-invalid' : '' }}"
                                name="chassi" id="input-chassi" type="text"
                                value="{{ isset($veiculo) ? $veiculo->chassi : old('chassi') }}" placeholder="{{ __('Chassi') }}"
                                />
                                @if ($errors->has('chassi'))
                                    <span id="chassi-error" class="error text-danger"
                                        for="input-chassi">{{ $errors->first('chassi') }}</span>
                                @endif
                            </div>
                        </div>
                        {{-- Dashboard --}}
                        <div class="col-6">
                            <div class="row ps-0 my-1">
                                <label cla>Exibir em Relatórios</label>
                            </div>
                            <div class="row">
                                <div class="input-group input-group-static my-3 {{ $errors->has('dashboard') ? ' is-invalid' : '' }}">
                                    <input class=""
                                    name="dashboard" id="input-dashboard" type="checkbox"
                                    {{ isset($veiculo) && $veiculo->dashboard ? 'checked' : '' }}  />
                                    <label style="margin-left: 8px;"> {{ __('Dashboard') }}</label>
                                    @if ($errors->has('km'))
                                        <span id="dashboard-error" class="error text-danger"
                                            for="input-dashboard">{{ $errors->first('dashboard') }}</span>
                                    @endif
                                </div>
                            </div>
                        </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-6">
        <div class="card mb-4">
            <div class="card-body ">
                <div class="row">
                    <div class="col-md-12 col-lg-12">
                        <h4 class="mb-3 bg-light">Características</h4>
                    </div>
                    <div class="col-12 col-lg-12">
                        <div class="row">
                            {{-- Placa --}}
                            <div class="col-6">
                                <div class="input-group input-group-static my-3 {{ $errors->has('placa') ? ' is-invalid' : '' }}">
                                    <label>{{ __('Placa') }}</label>
                                    <input class="form-control placa {{ $errors->has('placa') ? ' is-invalid' : '' }}"
                                    name="placa" id="input-placa" type="text"
                                    value="{{ isset($veiculo) ? $veiculo->placa : old('placa') }}" placeholder="{{ __('Placa') }}"
                                    required="true" aria-required="true"/>
                                    @if ($errors->has('placa'))
                                        <span id="placa-error" class="error text-danger"
                                            for="input-placa">{{ $errors->first('placa') }}</span>
                                    @endif
                                </div>
                            </div>
                            {{-- Sigla/Apelido --}}
                            <div class="col-6">
                                <div class="input-group input-group-static my-3 {{ $errors->has('sigla') ? ' is-invalid' : '' }}">
                                    <label>{{ __('Sigla/Apelido') }}</label>
                                    <input class="form-control sigla {{ $errors->has('sigla') ? ' is-invalid' : '' }}"
                                    name="sigla" id="input-sigla" type="text"
                                    value="{{ isset($veiculo) ? $veiculo->sigla : old('sigla') }}" placeholder="{{ __('Sigla/Apelido') }}"
                                    />
                                    @if ($errors->has('sigla'))
                                        <span id="sigla-error" class="error text-danger"
                                            for="input-sigla">{{ $errors->first('sigla') }}</span>
                                    @endif
                                </div>
                            </div>
                        </div>
                        <div class="row">

                            <div class="col-6">
                                {{-- Marca --}}
                                <div class="input-group input-group-static my-3">
                                    <label class="ms-0">Marca</label>
                                    <select class="form-control" name="marca">
                                        <option value="">- Selecionar -</option>
                                        @foreach($marcas as $key => $marca)
                                            <option value="{{ $key }}" {{ ((isset($veiculo) && $key == $veiculo->marca) || (old('marca') == $key)) ? 'selected' : '' }}>{{$marca}}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            {{-- Modelo --}}
                            <div class="col-6">
                                <div class="input-group input-group-static my-3 {{ $errors->has('modelo') ? ' is-invalid' : '' }}">
                                    <label>{{ __('Modelo') }}</label>
                                    <input class="form-control modelo {{ $errors->has('modelo') ? ' is-invalid' : '' }}"
                                    name="modelo" id="input-modelo" type="text"
                                    value="{{ isset($veiculo) ? $veiculo->modelo : old('modelo') }}" placeholder="{{ __('Modelo') }}"
                                    />
                                    @if ($errors->has('modelo'))
                                        <span id="modelo-error" class="error text-danger"
                                            for="input-modelo">{{ $errors->first('modelo') }}</span>
                                    @endif
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            {{-- Ano --}}
                            <div class="col-6">
                                <div class="input-group input-group-static my-3 {{ $errors->has('ano') ? ' is-invalid' : '' }}">
                                    <label>{{ __('Ano') }}</label>
                                    <input class="form-control ano {{ $errors->has('ano') ? ' is-invalid' : '' }}"
                                    name="ano" id="input-ano" type="text"
                                    value="{{ isset($veiculo) ? $veiculo->ano : old('ano') }}" placeholder="{{ __('Ano') }}"
                                    />
                                    @if ($errors->has('ano'))
                                        <span id="ano-error" class="error text-danger"
                                            for="input-ano">{{ $errors->first('ano') }}</span>
                                    @endif
                                </div>
                            </div>
                            {{-- Cor --}}
                            <div class="col-6">
                                <div class="input-group input-group-static my-3">
                                    <label class="ms-0">Cor</label>
                                    <select class="form-control" name="cor">
                                        <option value="">- Selecionar -</option>
                                        @foreach($cor as $key => $c)
                                            <option value="{{ $key }}" {{ ((isset($veiculo) && $key == $veiculo->cor) || (old('c') == $key)) ? 'selected' : '' }}>{{$c}}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            {{-- KM --}}
                            <div class="col-6">
                                <div class="input-group input-group-static my-3 {{ $errors->has('km') ? ' is-invalid' : '' }}">
                                    <label>{{ __('KM') }}</label>
                                    <input class="form-control km {{ $errors->has('km') ? ' is-invalid' : '' }}"
                                    name="km" id="input-km" type="number"
                                    value="{{ isset($veiculo) ? $veiculo->km : old('km') }}" placeholder="{{ __('KM') }}"
                                    />
                                    @if ($errors->has('km'))
                                        <span id="km-error" class="error text-danger"
                                            for="input-km">{{ $errors->first('km') }}</span>
                                    @endif
                                </div>
                            </div>
                            {{-- Tipo Veiculo --}}
                            <div class="col-6">
                                <div class="input-group input-group-static my-3 {{ $errors->has('tipoveiculo') ? ' is-invalid' : '' }}">
                                    <label>{{ __('Tipo de veículo') }}</label>
                                    <select class="form-control" name="tipoveiculo">
                                        <option value="">- Selecionar -</option>
                                        @foreach($tipoveiculo as $key => $tipo)
                                            <option value="{{ $key }}" {{ ((isset($veiculo) && $key == $veiculo->tipoveiculo) || (old('tipo') == $key)) ? 'selected' : '' }}>{{$tipo}}</option>
                                        @endforeach
                                    </select>
                                    @if ($errors->has('tipoveiculo'))
                                        <span id="tipoveiculo-error" class="error text-danger"
                                            for="input-tipoveiculo">{{ $errors->first('tipoveiculo') }}</span>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="row">
    <div class="col-md-6">
        <div class="row">
            <div class="col-md-12">
                <div class="card mb-4">
                    <div class="card-body ">
                        <div class="row">
                            <div class="col-md-12 col-lg-12">
                                <h4 class="mb-3 bg-light">Seguro</h4>
                            </div>
                            <div class="col-md-6">
                                {{-- Pessoa --}}

                                    <div class="input-group input-group-static my-3">
                                        <label class="ms-0">Seguradora</label>
                                        <select class="form-control" name="idseguradora">
                                            <option value="">- Selecionar -</option>
                                            @foreach($fornecedores as $fornecedor)
                                                <option value="{{ $fornecedor->idpessoa }}" {{ ((isset($veiculo) && $veiculo->idseguradora && $fornecedor->idpessoa == $veiculo->seguradora->idpessoa) || (old('idseguradora') == $fornecedor->idpessoa)) ? 'selected' : '' }}>{{$fornecedor->nome}}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>


                            {{-- Data Vencimento --}}
                            <div class="col-md-3">
                                <div
                                    class="input-group input-group-static my-3 {{ $errors->has('datavencimento') ? ' is-invalid' : '' }}">
                                    <label>{{ __('Data Vencimento') }}</label>
                                    <input class="form-control {{ $errors->has('datavencimento') ? ' is-invalid' : '' }}"
                                        name="datavencimento" id="input-datavencimento" type="date"
                                        value="{{ isset($veiculo) ? $veiculo->datavencimento : old('datavencimento') }}"
                                        placeholder="{{ __('Data emissão') }}" />
                                    @if ($errors->has('datavencimento'))
                                        <span id="datavencimento-error" class="error text-danger"
                                            for="input-datavencimento">{{ $errors->first('datavencimento') }}</span>
                                    @endif
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="input-group input-group-static my-3 {{ $errors->has('apolice') ? ' is-invalid' : '' }}">
                                    <label>{{ __('Apólice') }}</label>
                                    <input class="form-control apolice {{ $errors->has('apolice') ? ' is-invalid' : '' }}"
                                    name="apolice" id="input-apolice" type="text"
                                    value="{{ isset($veiculo) ? $veiculo->apolice : old('apolice') }}" placeholder="{{ __('Apólice') }}"
                                    />
                                    @if ($errors->has('apolice'))
                                        <span id="apolice-error" class="error text-danger"
                                            for="input-apolice">{{ $errors->first('apolice') }}</span>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                @if(isset($veiculo) and isset($veiculo->idseguradora))
                    @include('partials.contato', ['readonly' => true, 'idpessoa' => $veiculo->idseguradora])
                    @include('partials.endereco', ['readonly' => true, 'idpessoa' => $veiculo->idseguradora])
                @endif
            </div>
        </div>
    </div>
</div>


<div class="row">
    <div class="col-md-12">
        <div class="card mb-4">
            <div class="card-body ">
                <div class="row">
                    <div class="col-md-12 col-lg-12">
                        <h4 class="mb-3 bg-light">Contrato(s)
                        </h4>
                    </div>
                    <div class="col-md-12 col-lg-12">
                        <div class="row">
                            <div class="col-md-12">
                                <div class="table-responsive">
                                    <table class='table table-hover table-striped table-bordered table-sm text-sm' id="tab_logic">
                                        <thead>
                                            <tr class="info" style="font-size:14px;">
                                                <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                                    ID
                                                </th>
                                                <th
                                                    class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                                    Tipo
                                                </th>
                                                <th
                                                    class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                                    Nome
                                                </th>
                                                <th
                                                    class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                                    Cliente
                                                </th>
                                                <th
                                                    class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                                    Bairro
                                                </th>
                                                <th
                                                    class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                                    Cidade
                                                </th>
                                                <th
                                                    class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                                    Estado
                                                </th>
                                                <th
                                                    class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                                    Status
                                                </th>
                                                <th
                                                    class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                                    Prazo
                                                </th>
                                                <th
                                                    class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">

                                                </th>
                                            </tr>
                                        </thead>
                                        <tbody class="resultbody">
                                            @if(isset($contratosveiculos))
                                                @foreach ($contratosveiculos as $contratoveiculo)

                                                <tr>
                                                    <td class="custom-tbl text-center">
                                                        {{ $contratoveiculo->idcontrato }}
                                                    </td>
                                                    <td class="custom-tbl">
                                                        {{ $contratoveiculo->contrato->prodservtipo->prodservtipo ?? '-'}}
                                                    </td>
                                                    <td class="custom-tbl">
                                                        {{ $contratoveiculo->contrato->nome }}
                                                    </td>
                                                    <td class="custom-tbl">
                                                        {{ $contratoveiculo->contrato->pessoa->nome ?? '-'}}
                                                    </td>
                                                    <td class="custom-tbl">
                                                        {{ $contratoveiculo->contrato->bairro }}
                                                    </td>
                                                    <td class="custom-tbl">
                                                        {{ $contratoveiculo->contrato->cidade }}
                                                    </td>
                                                    <td class="custom-tbl">
                                                        {{ $contratoveiculo->contrato->estado }}
                                                    </td>
                                                    <td class="custom-tbl">
                                                        <span class="badge badge-sm
                                                            @if ($contratoveiculo->contrato->status == 'ATIVO')
                                                                bg-success
                                                            @elseif ($contratoveiculo->contrato->status == 'INATIVO')
                                                                bg-danger
                                                            @else
                                                                bg-info
                                                            @endif">
                                                            {{ $contratoveiculo->contrato->status }}
                                                        </span>
                                                    </td>
                                                    <td class="custom-tbl">
                                                        {{ Carbon::parse($contratoveiculo->contrato->datafim)->format('d/m/Y')  }}
                                                    </td>
                                                    <td class="custom-tbl">
                                                        <a rel="tooltip" class="btn btn-sm btn-success btn-link"
                                                            href="{{route('admin.contratos.edit', $contratoveiculo->idcontrato)}}" data-original-title=""
                                                            title="">
                                                            <i class="material-icons">edit</i>
                                                            <div class="ripple-container"></div>
                                                        </a>
                                                    </td>
                                                </tr>
                                                @endforeach
                                            @endif
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<div class="row">
    <div class="col-md-6">
        @include('partials.status', ['model' => $veiculo ?? null])
    </div>
    @if(isset($veiculo))
    <div class="col-md-6">
        @include('partials.upload', ['model' => $veiculo])
    </div>
    @endif
</div>
<div class="row">
    <div class="col-md-12">
        <div class="card mb-4">
            <div class="card-footer ml-auto mr-auto">
                <button id="submit-button" type="submit" class="btn btn-success">{{ __((isset($veiculo) ? 'Atualizar' : 'Adicionar').' Veículo') }}</button>
                <a href="{{ route('admin.veiculos.index') }}"
                        class="btn btn-light">{{ __('Voltar') }}</a>
                @if(isset($veiculo))
                <a class="btn bg-gradient-dark" href="{{route('admin.veiculos.create')}}"><i
                            class="material-icons text-sm">add</i>&nbsp;&nbsp;Novo veículo</a>
                @endif
            </div>
        </div>
    </div>
</div>
{{-- @TODO: criar mascaras --}}
@push('js')
    {{-- Select2 --}}
    <script src="{{ asset('assets/js/plugins/select2.min.js') }}"></script>
    <script>
        $('.select2').select2();
    </script>
    @include('partials.upload-js')
@endpush
