@php
    use Carbon\Carbon;
@endphp
<x-layout bodyClass="g-sidenav-show  bg-dark-silk">
    <x-navbars.sidebar activePage="vendas"></x-navbars.sidebar>
    <main class="main-content position-relative max-height-vh-100 h-100 border-radius-lg ">
        <!-- Navbar -->
        <x-navbars.navs.auth titlePage="Vendas"></x-navbars.navs.auth>
        <!-- End Navbar -->
        <div class="container-fluid py-4">
            <div class="row">
                <div class="col-12">
                    <div class="card my-4">
                        <div class="card-header p-0 position-relative mt-n4 mx-3 z-index-2">
                            <div class="bg-gradient-primary shadow-primary border-radius-lg pt-4 pb-3">
                                <h5 class="mx-3">Vendas</h5>
                            </div>
                        </div>
                        <div class="m-3 d-flex flex-row flex-wrap gap-3 align-items-center justify-content-between">
                            <div class="d-flex flex-wrap align-content-center gap-2">
                                <button class="btn btn-sm m-0 text-center shadow-none" id="btn-filters" style="background-color: #e5e5e5; color: #344767; border-radius: 20px; font-size: .7rem" data-bs-toggle="modal" data-bs-target="#filterModal">
                                    <i class="fa fa-filter me-1" style="font-size: .7rem" aria-hidden="true"></i> <span id="filter-count">Filtro</span>
                                </button>
                                <div class="col-auto d-flex align-items-center">
                                    <input type="checkbox" class="btn-check"  id="btn-check-inativo" autocomplete="off"
                                    {{ \Request::get('status') === 'INATIVO' ? 'checked' : '' }}>
                                    <label class="btn btn-sm shadow-sm m-0 text-center border-2 d-flex align-items-center shadow-none" style="background-color: #dddddd; color: #344767; border-radius: 20px; padding: 10px 24px" for="btn-check-inativo">
                                        <i class="fa fa-times-circle-o me-2" style="font-size: .9rem;" aria-hidden="true"></i>
                                        <span style="font-size: .7rem">Inativo</span>
                                        <i class="fa fa-times ps-3 {{ \Request::get('status') === 'INATIVO' ? '' : 'd-none' }}" style="font-weight: 600; font-size: .8rem" id="btn-check-hide" aria-hidden="true"></i>
                                    </label>
                                </div>
                                <div class="col-auto d-flex align-items-center">
                                    <a href="{{ route('admin.vendas.index') }}?clear=true" class="btn shadow-none m-0 text-center border-2" style="background-color: #dddddd; color: #344767; border-radius: 20px; font-size: .7rem">
                                        <i class="fa fa-trash me-1" style="font-size: .8rem" aria-hidden="true"></i> Limpar filtros
                                    </a>
                                </div>
                                @include('partials.filter-text', ['route' => route('admin.vendas.search')])
                            </div>
                            <div class="col-auto text-end">
                                <a class="btn bg-gradient-dark mb-0" href="{{route('admin.vendas.create')}}">
                                    <i class="material-icons text-sm">add</i>&nbsp;&nbsp;Adicionar Venda
                                </a>
                            </div>
                        </div>
                        <div class="card-body px-0 pb-2">
                            {{-- Messagens da session --}}
                            @include('partials.session-message')
                            <div class="table-responsive p-0">
                                <table class="table align-items-center mb-0">
                                    <thead>
                                        <tr>
                                            <th
                                                class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                                ID
                                            </th>
                                            <th
                                                class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                                Empresa
                                            </th>
                                            <!--th
                                                class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                                Cliente
                                            </th-->
                                             <th
                                                class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                                R. Social
                                            </th>
                                            <th
                                                class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                                Tipo
                                            </th>
                                            <th
                                                class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 text-end">
                                                Valor
                                            </th>
                                            <th
                                                class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 text-end">
                                                CRIADO EM
                                            </th>
                                            <th
                                                class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 text-end">
                                                VENCIMENTO
                                            </th>
                                            <th
                                                class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 text-end">
                                                STATUS
                                            </th>
                                            <th class="text-secondary opacity-7 d-none"></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($vendas as $venda)
                                            <tr data-url="{{route('admin.vendas.edit', $venda->idnf)}}" style="cursor: pointer;">
                                                <td>
                                                    <div class="d-flex px-2 py-1">
                                                        <div class="d-flex flex-column justify-content-center">
                                                            <p class="mb-0 text-sm">{{ $venda->idnf }}</p>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>
                                                    <div class="d-flex px-2 py-1">
                                                        <div class="d-flex flex-column justify-content-center">
                                                            <p class="mb-0 text-sm">{{ $venda->empresa->sigla }}</p>
                                                        </div>
                                                    </div>
                                                </td>
                                                <!--td>
                                                    <div class="d-flex px-2 py-1">
                                                        <div class="d-flex flex-column justify-content-center">
                                                            <p class="mb-0 text-sm">{{ $venda->fornecedor->nome ?? '-' }}</p>
                                                        </div>
                                                    </div>
                                                </td-->
                                                <td>
                                                    <div class="d-flex px-2 py-1">
                                                        <div class="d-flex flex-column justify-content-center">
                                                            <p class="mb-0 text-sm">{{ $venda->fornecedor->razaosocial ?? $venda->fornecedor->nome ?? '-'  }}</p>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>
                                                    <div class="d-flex px-2 py-1">
                                                        <div class="d-flex flex-column justify-content-center">
                                                            <p class="mb-0 text-sm">{{ $venda->prodservtipo->prodservtipo ?? '-' }}</p>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>
                                                    <div class="d-flex px-2 py-1 justify-content-end">
                                                        <div class="d-flex flex-column justify-content-center">
                                                            <p class="mb-0 text-sm text-end text-bold text-success">R$
                                                                {{ number_format($venda->totalnf, 2, ',', '.') }}</p>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>
                                                    <div class="d-flex px-2 py-1 justify-content-end">
                                                        <h6 class="mb-0 text-sm justify-content-center">{{ Carbon::parse($venda->dataemissao)->format('d/m/y') }}</h6>
                                                    </div>
                                                </td>
                                                <td>
                                                    <div class="d-flex px-2 py-1 justify-content-end">
                                                    <h6 class="mb-0 text-sm">{{ Carbon::parse($venda->datavencimento)->format('d/m/y') }}</h6>
                                                    </div>
                                                </td>
                                                <td data-noclicked="true" class="pe-3">
                                                    <div class="progress mb-1" style="width: 100%;">
                                                        <div class="progress-bar {{ $venda->status === 'CONCLUÍDO' ? 'bg-success' : ($venda->status === 'ATIVO' ? 'bg-info' : 'bg-danger') }}" role="progressbar" style="height: 10px; width: 50%;" data-iditem="{{ $venda->idnf }}" data-status="INATIVO" data-bs-toggle="tooltip" data-bs-title="Inativo"></div>
                                                        <div class="progress-bar {{ $venda->status === 'CONCLUÍDO' ? 'bg-success' : ($venda->status === 'INATIVO' ? 'bg-secondary' : 'bg-info') }}" role="progressbar" style="height: 10px; width: 50%;" data-iditem="{{ $venda->idnf }}" data-status="ATIVO" data-bs-toggle="tooltip" data-bs-title="Ativo"></div>
                                                        <div class="progress-bar {{ $venda->status === 'ATIVO' || $venda->status === 'INATIVO' ? 'bg-secondary' : 'bg-success' }}" role="progressbar" style="height: 10px; width: 50%;" data-iditem="{{ $venda->idnf }}" data-status="CONCLUÍDO" data-bs-toggle="tooltip" data-bs-title="Concluído"></div>
                                                    </div>
                                                    <div>
                                                        <span id="status-{{ $venda->idnf }}" style="font-size: .8rem; text-transform: capitalize">{{ Str::lower($venda->status) }}</span>
                                                    </div>
                                                </td>
                                                <td class="align-middle text-center d-none">
                                                    <a rel="tooltip" class="btn btn-success btn-sm  btn-link"
                                                        href="{{route('admin.vendas.edit', $venda->idnf)}}" data-original-title=""
                                                        title="">
                                                        <i class="material-icons">edit</i>
                                                        <div class="ripple-container"></div>
                                                    </a>
                                                    <form action="{{route('admin.vendas.destroy', $venda->idnf)}}" class="d-inline" method="POST">
                                                        @csrf
                                                        @method('delete')
                                                        <button type="button" class="btn btn-danger btn-sm  btn-link"
                                                            data-original-title="" title=""
                                                            onclick="confirm('{{ __('Você tem certeza que deseja apagar esse venda?') }}') ? this.parentElement.submit() : ''">
                                                            <i class="material-icons">close</i>
                                                            <div class="ripple-container"></div>
                                                        </button>
                                                    </form>
                                                </td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <x-footers.auth></x-footers.auth>
        </div>
    </main>
    <x-plugins></x-plugins>
</x-layout>
@include('partials.update-status-progress', ['route' => route('admin.vendas.update', ['venda' => ':id']), 'redirect' => 0, 'options' => [
    'INATIVO' => 'bg-danger',
    'ATIVO' => 'bg-info',
    'CONCLUÍDO' => 'bg-success'
]])
@include('partials.filter-inativo', ['routeSearch' => route('admin.vendas.search'), 'routeIndex' => route('admin.vendas.index')])
@include('partials.filters', [
    'route' => route('admin.vendas.search'),
    'filters' => [
        ['label' => 'Nº Compra', 'value' => 'idnf', 'inputType' => 'text', 'required' => true],
        ['label' => 'Empresa', 'value' => 'idempresa', 'inputType' => 'select', 'options' => $empresas, 'valueField' => 'idempresa', 'textField' => 'razaosocial'],
        ['label' => 'Colaborador/Cliente', 'value' => 'idpessoa', 'inputType' => 'select', 'options' => $pessoas, 'valueField' => 'idpessoa', 'textField' => 'nome'],
        ['label' => 'Tipo', 'value' => 'idprodservtipo', 'inputType' => 'select', 'options' => $tiposProdutoServico, 'valueField' => 'idprodservtipo', 'textField' => 'prodservtipo'],
        ['label' => 'Data de Vencimento', 'value' => 'datavencimento', 'inputType' => 'date'],
        ['label' => 'Status', 'value' => 'status', 'inputType' => 'select', 'options' => [
            ['status' => 'INATIVO', 'label' => 'Inativo'],
            ['status' => 'ATIVO', 'label' => 'Ativo'],
            ['status' => 'CONCLUÍDO', 'label' => 'Concluído']
        ], 'valueField' => 'status', 'textField' => 'label']
    ]
])
