<!--
=========================================================
* Material Dashboard 2 - v3.0.0
=========================================================

* Product Page: https://www.creative-tim.com/product/material-dashboard
* Copyright 2021 Creative Tim (https://www.creative-tim.com) & UPDIVISION (https://www.updivision.com)
* Licensed under MIT (https://www.creative-tim.com/license)
* Coded by www.creative-tim.com & www.updivision.com

=========================================================

* The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.
-->
@props(['bodyClass'])
<!DOCTYPE html>
<html lang="pt-br">

<head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

    <link rel="apple-touch-icon" sizes="76x76" href="{{ asset('assets') }}/img/apple-icon.png">
    <link rel="icon" type="image/png" href="{{ asset('assets') }}/img/favicon.png">
    <title>
        Empresa
    </title>
    <!--     Fonts and icons     -->
    <link rel="stylesheet" type="text/css"
        href="https://fonts.googleapis.com/css?family=Roboto:300,400,500,700,900|Roboto+Slab:400,700" />
    <!-- Nucleo Icons -->
    <link href="{{ asset('assets') }}/css/nucleo-icons.css" rel="stylesheet" />
    <link href="{{ asset('assets') }}/css/nucleo-svg.css" rel="stylesheet" />
    <!-- Font Awesome Icons -->
    <script src="{{ asset('assets') }}/js/42d5adcbca.js" crossorigin="anonymous"></script>
    <!-- Material Icons -->
    <link href="https://fonts.googleapis.com/icon?family=Material+Icons+Round" rel="stylesheet">
    <!-- CSS Files -->
    <link id="pagestyle" href="{{ asset('assets') }}/css/material-dashboard.css?v=3.0.1" rel="stylesheet" />
    <link href="{{ asset('assets') }}/css/daterangepicker.css" rel="stylesheet" />

    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/selectize.js/0.15.2/css/selectize.bootstrap5.min.css" integrity="sha512-Ars0BmSwpsUJnWMw+KoUKGKunT7+T8NGK0ORRKj+HT8naZzLSIQoOSIIM3oyaJljgLxFi0xImI5oZkAWEFARSA==" crossorigin="anonymous" referrerpolicy="no-referrer" />
    @stack('link')

    <style>
        #date_range, #date_range + .input-group-append .input-group-text {
            cursor: pointer;
        }

        /* Estilizando o ícone do calendário */
        .input-group .input-group-text {
            padding: 10px; /* Ajuste o padding conforme necessário */
            color: #495057; /* Cor do ícone */
        }

        /* Opcional: Estilizando o ícone diretamente para um tamanho maior, cor, etc. */
        .input-group .input-group-text i.fa-calendar {
            color: #495057; /* Cor do ícone */
            /* Adicione aqui mais estilos se necessário, como font-size para tamanho do ícone */
        }

        .form-check-input.status {
            background-color: #da0000 !important;

            &:checked {
                background-color: #00a205 !important;
            }
        }
        .prefix-column {
            width: 85px !important;
        }

        .clearAll, .addFilter, .add-filter-group, .close-filters {
            &:active {
                background-color: #adb3bd !important;
                color: #656f7d !important;
            }

            &:hover {
                background-color: #e5e5e5 !important;
                color: #344767 !important;
            }
        }

    </style>
    @stack('css')
    @livewireStyles
    <script src="//unpkg.com/alpinejs" defer></script>
</head>
<body class="{{ $bodyClass }} g-sidenav-hidden">

{{ $slot }}

<script src="{{ asset('assets') }}/js/core/popper.min.js"></script>
<script src="{{ asset('assets') }}/js/core/bootstrap.min.js"></script>
<script src="{{ asset('assets') }}/js/plugins/perfect-scrollbar.min.js"></script>
<script src="{{ asset('assets') }}/js/plugins/smooth-scrollbar.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.1/jquery.min.js" integrity="sha512-aVKKRRi/Q/YV+4mjoKBsE4x3H+BkegoM/em46NNlCqNTmUYADjBbeNefNxYV7giUp0VxICtqdrbqU7iVaeZNXA==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery.mask/1.14.16/jquery.mask.min.js" integrity="sha512-pHVGpX7F/27yZ0ISY+VVjyULApbDlD0/X0rgGbTqCE7WFW5MezNTWG/dnhtbBuICzsd0WQPgpE4REBLv+UqChw==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
<script src="{{asset('js/app.js')}}"></script>
{{-- <script src="{{ asset('vendor/jQuery-Mask-Plugin/dist/jquery.mask.min.js') }}"></script> --}}
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11.7.3/dist/sweetalert2.all.min.js"></script>
<script src="{{ asset('assets') }}/js/moment.min.js" type="text/javascript"></script>
<script src="{{ asset('assets') }}/js/daterangepicker.min.js" type="text/javascript"></script>
<script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>
<script src="https://cdn.jsdelivr.net/npm/flatpickr/dist/plugins/rangePlugin.js"></script>

@stack('js')
<script>
    $(document).ready(function() {
        $('tr[data-url]').on('click', function(event) {
            // Verifica se o clique foi em um elemento com data-noclicked
            if ($(event.target).closest('td').is('[data-noclicked]')) {
                return; // Interrompe o redirecionamento
            }

            // Redireciona se o clique não foi em um elemento com data-noclicked
            window.location.href = $(this).data('url');
        });
    });


    var win = navigator.platform.indexOf('Win') > -1;
    if (win && document.querySelector('#sidenav-scrollbar')) {
        var options = {
            damping: '0.5'
        }
        Scrollbar.init(document.querySelector('#sidenav-scrollbar'), options);
    }

    // Mascaras JQUERY
    var SPMaskBehavior = function (val) {
        return val.replace(/\D/g, '').length === 11 ? '(00) 00000-0000' : '(00) 0000-00009';
    },
    spOptions = {
        onKeyPress: function (val, e, field, options) {
            field.mask(SPMaskBehavior.apply({}, arguments), options);
        }
    };

    var optionsCpfCnpj = {
        onKeyPress : function(cpfcnpj, e, field, options) {
            var masks = ['000.000.000-000', '00.000.000/0000-00'];
            var mask = (cpfcnpj.length > 14) ? masks[1] : masks[0];
            $('.cpfcnpj').mask(mask, options);
        }
    };


    $('.telefone').mask(SPMaskBehavior, spOptions);
    $('.cep').mask('00000-000');
    $('.cpfcnpj').mask('00.000.000/0000-00', optionsCpfCnpj);
    $('.cnpj').mask('00.000.000/0000-00', {reverse: true});
    $('.data').mask('00/00/0000');
    $('.ano').mask('0000');
    $('.placa').mask('AAA-0A00');
    // Buscar informacoes de um cep a partir do input com name=cep
    $('input[name="cep"]').on('keyup', function(e)
    {
        let JQelement = $(this),
            JQform = $('form'),
            cepErrorSPAN = $('.cep-error'),
            JQloader = $('.loader');

        // Buscar cep
        if(JQelement.val().length == 9)
        {
            JQform.find('input').attr('disabled', true);

            cep(JQelement.cleanVal())
                .then(res => {
                    $('#input-estado').val(res.state);
                    $('#input-cidade').val(res.city);
                    $('#input-endereco').val(res.street);
                    $('#input-bairro').val(res.neighborhood);

                    JQform.find('input').removeAttr('disabled');
                    $('#input-numero').focus();
                })
                .catch(e => {
                    Swal.fire({
                        title: 'Erro',
                        text: e.message,
                        icon: 'error',
                        didClose: _ => {
                            JQform.find('input').removeAttr('disabled');
                            JQelement.select();
                        }
                    });
                });
        }
    });
</script>
<!-- Github buttons -->
<script async defer src="https://buttons.github.io/buttons.js"></script>
<!-- Control Center for Material Dashboard: parallax effects, scripts for the example pages etc -->
<script src="{{ asset('assets') }}/js/material-dashboard.min.js?v=3.0.0"></script>
<script>
        $(document).ready(function() {
            $(window).on('keydown', function(event) {
                if (event.ctrlKey || event.metaKey) {
                    switch (String.fromCharCode(event.which).toLowerCase()) {
                        case 's':
                            event.preventDefault();
                            //$('#formPrincipal').submit();
                            $('#submit-button').click()
                            break;
                    }
                }
            });

            var startDate = moment();
            var endDate = moment();
            var hasDateRange = false;

             // Verificar se há valor no input de date_range
            if ($('#date_range').val()) {
                var dateRange = $('#date_range').val().split(' - ');
                if (dateRange.length === 2 && moment(dateRange[0], 'DD/MM/YY', true).isValid() && moment(dateRange[1], 'DD/MM/YY', true).isValid()) {
                    startDate = moment(dateRange[0], 'DD/MM/YY');
                    endDate = moment(dateRange[1], 'DD/MM/YY');
                    hasDateRange = true;
                }
            }

            if ($('#date_range').length) { // Verifica se o input com ID #date_range existe
                $('#date_range').daterangepicker({
                    startDate: hasDateRange ? startDate : undefined,
                    endDate: hasDateRange ? endDate : undefined,
                    autoUpdateInput: false,
                    opens: 'left',
                    ranges: {
                        'Hoje': [moment(), moment()],
                        'Ontem': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
                        'Amanhã': [moment().add(1, 'days'), moment().add(1, 'days')],
                        'Esta Semana': [moment().startOf('week'), moment().endOf('week')],
                        'Semana Passada': [moment().subtract(1, 'week').startOf('week'), moment().subtract(1, 'week').endOf('week')],
                        'Próxima Semana': [moment().add(1, 'week').startOf('week'), moment().add(1, 'week').endOf('week')],
                        'Este Mês': [moment().startOf('month'), moment().endOf('month')],
                        'Mês Passado': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],

                        'Próximo Mês': [moment().add(1, 'month').startOf('month'), moment().add(1, 'month').endOf('month')],
                        'Este Ano': [moment().startOf('year'), moment().endOf('year')],
                        'Ano Passado': [moment().subtract(1, 'year').startOf('year'), moment().subtract(1, 'year').endOf('year')],

                        'Próximo Ano': [moment().add(1, 'year').startOf('year'), moment().add(1, 'year').endOf('year')]
                    },
                    locale: {
                        format: 'DD/MM/YY',
                        applyLabel: 'Confirmar',
                        cancelLabel: 'Cancelar',
                        customRangeLabel: 'Personalizado...',
                    },
                });
            }

            // Configurar o evento para aplicar a seleção
            $('#date_range').on('apply.daterangepicker', function(ev, picker) {
                $(this).val(picker.startDate.format('DD/MM/YY') + ' - ' + picker.endDate.format('DD/MM/YY'));
            });

            // Adicionar evento de clique ao ícone do calendário
            $('.input-group-text').on('click', function() {
                $('#date_range').focus();
            });


        });


</script>
@livewireScripts
<script src="{{ asset('assets') }}/js/dashboard-filters.js"></script>
</body>
</html>
