<div class="col-lg-12 col-md-12 mt-4 mb-4">
    <div class="card card-calendar z-index-2">
        <div class="card-body p-3">
            <div class="calendar" data-bs-toggle="calendar" id="calendar"></div>
        </div>
    </div>
</div>

<style>
    .fc-event-title {
        white-space: normal !important;
        font-size: 0.95em; /* Ajusta o tamanho da fonte do título */
        font-weight: 500;
    }

    .fc-event {
        height: auto !important; /* Permite que o evento expanda para acomodar o texto */
    }

    .fc-daygrid-event {
        display: flex;
        flex-direction: column; /* Organiza hora e título em colunas */
    }

    .fc-event-time, .fc-event-title {
        width: 100%; /* Ocupa 100% da largura do contêiner */
        text-align: left; /* Alinha o texto à esquerda */
        padding: 0px 4px;
        font-weight: 500;
    }

    .fc-event-time {
        font-size: 0.85em; /* Reduz o tamanho da fonte da hora */
        margin-bottom: 0.5em; /* Espaçamento entre hora e título */
    }

    /* Estilo personalizado para as tags baseados na classe da tag */
    @foreach($tags as $tag)
        .{{ $tag['className'] }} {
            background-color: {{ $tag['backgroundColor'] ?? '#ccc' }} !important;
            color: {{ $tag['textColor'] ?? '#333' }} !important;
        }
    @endforeach
</style>

<script>
    var calendarEl = document.getElementById('calendar');
    var calendar = new FullCalendar.Calendar(calendarEl, {
        initialView: 'dayGridMonth',
        eventClick: function(info) {
            info.jsEvent.preventDefault(); // Previne a ação padrão
            if (info.event.url) {
                window.open(info.event.url, '_blank'); // Abre a URL em uma nova aba
            }
        },
        customButtons: {
            mostrarInicio: {
                text: 'Por Inícios',
                click: function() {
                    window.location.href = window.location.pathname + '?visualizacao=inicio';
                }
            },
            mostrarTermino: {
                text: 'Por Términos',
                click: function() {
                    window.location.href = window.location.pathname + '?visualizacao=termino';
                }
            },
            mostrarDuracao: {
                text: 'Por Duração',
                click: function() {
                    window.location.href = window.location.pathname + '?visualizacao=duracao';
                }
            }
        },
        headerToolbar: {
            start: 'dayGridMonth,timeGridWeek,timeGridDay',
            center: 'title',
            end: 'today prev,next mostrarInicio,mostrarTermino,mostrarDuracao'
        },
        selectable: true,
        editable: false,
        locale: 'pt-br', // Define o local para português brasileiro
        buttonText: {
            today: 'Hoje',
            month: 'Mês',
            week: 'Semana',
            day: 'Dia',
        },
        weekends: true,
        height: 'auto',
        contentHeight: 'auto',
        eventContent: function(arg) {
            var timeElement = document.createElement('div');
            timeElement.classList.add('fc-event-time');
            timeElement.innerHTML = arg.timeText; // Hora do evento

            var titleElement = document.createElement('div');
            titleElement.classList.add('fc-event-title');
            titleElement.classList.add('fw-normal');
            titleElement.innerHTML = arg.event.title;

            var arrayOfDomNodes = [timeElement, titleElement];
            return { domNodes: arrayOfDomNodes };
        },
        eventSources: @json($tags), // Eventos carregados aqui
        events: @json($tags),
        views: {
            month: {
                titleFormat: { month: 'short', year: 'numeric' }
            },
            agendaWeek: {
                titleFormat: { month: 'short', year: 'numeric', day: 'numeric' }
            },
            agendaDay: {
                titleFormat: { month: 'short', year: 'numeric', day: 'numeric' }
            }
        },
        eventTimeFormat: {
            hour: '2-digit',
            minute: '2-digit',
            meridiem: false,
            hour12: false
        },
    });

    calendar.render();
</script>
