{{-- @push('link')
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/selectize.js/0.15.2/css/selectize.bootstrap5.min.css" integrity="sha512-Ars0BmSwpsUJnWMw+KoUKGKunT7+T8NGK0ORRKj+HT8naZzLSIQoOSIIM3oyaJljgLxFi0xImI5oZkAWEFARSA==" crossorigin="anonymous" referrerpolicy="no-referrer" />
@endpush --}}

<div class="row">
    <div class="col-12">
        <div class="card mb-4">
            <div class="row m-0 pt-4">
                <div class="col-md-3 col-sm-4 text-left">
                    <div class=" input-group mb-4" wire:ignore>
                        <input wire:model="datarange" type="text" id="datePicker" class="form-control select-custom" placeholder="Selecione a data...">
                        <span class="input-group-text"><i class="fa fa-calendar"></i></span>
                    </div>
                </div>

                @if ($showEmpresas)
                    <div class="col-md-2 col-sm-4 text-left">
                        <div class="input-group mb-4">
                            <select wire:model="idempresa" class="form-control select-custom" id="empresas" name="idempresa" data-idempresa="{{ $idempresa ?? null}}"  style="border: 1px solid #d2d6da;border-radius: 0.5rem;font-size: 0.777rem; color: #777;appearance: menulist; -webkit-appearance: menulist;line-height:1.4rem">
                                <option value="">Empresa</option>
                                @foreach($empresas as $empresa)
                                    <option value="{{ $empresa->idempresa }}" {{ (isset($idempresa) && $idempresa == $empresa->idempresa) ? 'selected' : '' }}>{{$empresa->sigla}}</option>
                                @endforeach
                            </select>


                            <div class="selected-value" style="display: none;" onclick="clearSelection(this)">
                                <span class="text"></span>
                                <button type="button"><i class="fa fa-window-close" aria-hidden="true"></i></button>
                            </div>
                        </div>
                    </div>
                @endif

                @if ($showUsers)
                    <div class="col-md-2 col-sm-4 text-left d-none">
                        <div class=" input-group mb-4">
                            <select wire:model="id" class="form-control select-custom" name="id" data-id="{{ $id ?? ''}}"  style="border: 1px solid #d2d6da;border-radius: 0.5rem;font-size: 0.777rem; color: #777;appearance: menulist; -webkit-appearance: menulist;line-height:1.4rem">
                                <option value="">Usuário</option>
                                @foreach($users as $user)
                                    <option value="{{ $user->id }}" {{ (isset($id) && $id == $user->id) ? 'selected' : '' }}>{{$user->name}}</option>
                                @endforeach
                            </select>
                            <div class="selected-value" style="display: none;" onclick="clearSelection(this)">
                                <span class="text"></span>
                                <button type="button"><i class="fa fa-window-close" aria-hidden="true"></i></button>
                            </div>
                        </div>
                    </div>
                @endif

                @if ($showContratos)
                <div class="col-md-2 col-sm-4 text-left">
                    <div class=" input-group mb-4">
                        <select wire:model="idcontrato" id="contratos" class="form-control select-custom" name="idcontrato" data-id="{{ $idcontrato ?? ''}}"  style="border: 1px solid #d2d6da;border-radius: 0.5rem;font-size: 0.777rem; color: #777;appearance: menulist; -webkit-appearance: menulist;line-height:1.4rem">
                            <option value="">Contrato</option>
                            @foreach($contratos as $contrato)
                                <option value="{{ $contrato->idcontrato }}">{{ "$contrato->idcontrato - {$contrato->empresa->nomefantasia}" }}</option>
                            @endforeach
                        </select>
                        <div class="selected-value" style="display: none;" onclick="clearSelection(this)">
                            <span class="text"></span>
                            <button type="button"><i class="fa fa-window-close" aria-hidden="true"></i></button>
                        </div>
                    </div>
                </div>
                @endif

                @if ($showVeiculos)
                    <div class="col-md-2 col-sm-4 text-left">
                        <div class=" input-group mb-4">
                            <select wire:model="idveiculo" id="veiculos" class="form-control select-custom" name="idveiculo" style="border: 1px solid #d2d6da;border-radius: 0.5rem;font-size: 0.777rem; color: #777;appearance: menulist; -webkit-appearance: menulist;line-height:1.4rem">
                                <option value="">Veículo</option>
                                @foreach($veiculos as $veiculo)
                                        <option value="{{ $veiculo->idveiculo }}">{{$veiculo->placa}} {{$veiculo->marca}}/{{$veiculo->modelo}} - </option>
                                @endforeach
                            </select>
                            <div class="selected-value" style="display: none;" onclick="clearSelection(this)">
                                <span class="text"></span>
                                <button type="button"><i class="fa fa-window-close" aria-hidden="true"></i></button>
                            </div>
                        </div>
                    </div>
                @endif

                @if ($showAgencias)
                    <div class="col-md-2 col-sm-4 text-left">
                        <div class=" input-group mb-4">
                            <select wire:model="idagencia" id="agencias" class="form-control select-custom" name="idagencia" style="border: 1px solid #d2d6da;border-radius: 0.5rem;font-size: 0.777rem; color: #777;appearance: menulist; -webkit-appearance: menulist;line-height:1.4rem">
                                <option value="">Agência</option>
                                @foreach($agencias as $agencia)
                                        <option value="{{ $agencia->idagencia }}">{{ $agencia->nome }}</option>
                                @endforeach
                            </select>
                            <div class="selected-value" style="display: none;" onclick="clearSelection(this)">
                                <span class="text"></span>
                                <button type="button"><i class="fa fa-window-close" aria-hidden="true"></i></button>
                            </div>
                        </div>
                    </div>
                @endif

                <div class="col-md-1 col-sm-4 text-left d-none">
                    <div class=" input-group mb-4">
                        <select wire:model="origemuf" class="form-control select-custom" id="origemuf" name="origemuf" onchange="updateSelection(this)" data-origemuf="{{ $origemuf ?? ''}}"  style="border: 1px solid #d2d6da;border-radius: 0.5rem;font-size: 0.777rem; color: #777;appearance: menulist; -webkit-appearance: menulist;line-height:1.4rem">
                            <option value="" >Origem UF</option>
                            <option value="AC" {{ (isset($origemuf) && $origemuf == 'AC') ? 'selected' : '' }}>AC</option>
                            <option value="AL" {{ (isset($origemuf) && $origemuf == 'AL') ? 'selected' : '' }}>AL</option>
                            <option value="AP" {{ (isset($origemuf) && $origemuf == 'AP') ? 'selected' : '' }}>AP</option>
                            <option value="AM" {{ (isset($origemuf) && $origemuf == 'AM') ? 'selected' : '' }}>AM</option>
                            <option value="BA" {{ (isset($origemuf) && $origemuf == 'BA') ? 'selected' : '' }}>BA</option>
                            <option value="CE" {{ (isset($origemuf) && $origemuf == 'CE') ? 'selected' : '' }}>CE</option>
                            <option value="DF" {{ (isset($origemuf) && $origemuf == 'DF') ? 'selected' : '' }}>DF</option>
                            <option value="ES" {{ (isset($origemuf) && $origemuf == 'ES') ? 'selected' : '' }}>ES</option>
                            <option value="GO" {{ (isset($origemuf) && $origemuf == 'GO') ? 'selected' : '' }}>GO</option>
                            <option value="MA" {{ (isset($origemuf) && $origemuf == 'MA') ? 'selected' : '' }}>MA</option>
                            <option value="MT" {{ (isset($origemuf) && $origemuf == 'MT') ? 'selected' : '' }}>MT</option>
                            <option value="MS" {{ (isset($origemuf) && $origemuf == 'MS') ? 'selected' : '' }}>MS</option>
                            <option value="MG" {{ (isset($origemuf) && $origemuf == 'MG') ? 'selected' : '' }}>MG</option>
                            <option value="PA" {{ (isset($origemuf) && $origemuf == 'PA') ? 'selected' : '' }}>PA</option>
                            <option value="PB" {{ (isset($origemuf) && $origemuf == 'PB') ? 'selected' : '' }}>PB</option>
                            <option value="PR" {{ (isset($origemuf) && $origemuf == 'PR') ? 'selected' : '' }}>PR</option>
                            <option value="PE" {{ (isset($origemuf) && $origemuf == 'PE') ? 'selected' : '' }}>PE</option>
                            <option value="PI" {{ (isset($origemuf) && $origemuf == 'PI') ? 'selected' : '' }}>PI</option>
                            <option value="RJ" {{ (isset($origemuf) && $origemuf == 'RJ') ? 'selected' : '' }}>RJ</option>
                            <option value="RN" {{ (isset($origemuf) && $origemuf == 'RN') ? 'selected' : '' }}>RN</option>
                            <option value="RS" {{ (isset($origemuf) && $origemuf == 'RS') ? 'selected' : '' }}>RS</option>
                            <option value="RO" {{ (isset($origemuf) && $origemuf == 'RO') ? 'selected' : '' }}>RO</option>
                            <option value="RR" {{ (isset($origemuf) && $origemuf == 'RR') ? 'selected' : '' }}>RR</option>
                            <option value="SC" {{ (isset($origemuf) && $origemuf == 'SC') ? 'selected' : '' }}>SC</option>
                            <option value="SP" {{ (isset($origemuf) && $origemuf == 'SP') ? 'selected' : '' }}>SP</option>
                            <option value="SE" {{ (isset($origemuf) && $origemuf == 'SE') ? 'selected' : '' }}>SE</option>
                            <option value="TO" {{ (isset($origemuf) && $origemuf == 'TO') ? 'selected' : '' }}>TO</option>

                        </select>
                        <div class=" selected-value" style="display: none;" onclick="clearSelection(this)">
                            <span class="text"></span>
                            <button type="button"><i class="fa fa-window-close" aria-hidden="true"></i></button>
                        </div>
                    </div>
                </div>

                <div class="col-md-1 col-sm-4 text-left d-none">
                    <div class=" input-group mb-4">
                        <select wire:model="destinouf" class="form-control select-custom" id="destinouf" name="destinouf" onchange="updateSelection(this)" data-destinouf="{{ $destinouf ?? ''}}"  style="border: 1px solid #d2d6da;border-radius: 0.5rem;font-size: 0.777rem; color: #777;appearance: menulist; -webkit-appearance: menulist;line-height:1.4rem">
                        <option value="">Destino UF</option>
                            <option value="AC" {{ (isset($destinouf) && $destinouf == 'AC') ? 'selected' : '' }}>AC</option>
                            <option value="AL" {{ (isset($destinouf) && $destinouf == 'AL') ? 'selected' : '' }}>AL</option>
                            <option value="AP" {{ (isset($destinouf) && $destinouf == 'AP') ? 'selected' : '' }}>AP</option>
                            <option value="AM" {{ (isset($destinouf) && $destinouf == 'AM') ? 'selected' : '' }}>AM</option>
                            <option value="BA" {{ (isset($destinouf) && $destinouf == 'BA') ? 'selected' : '' }}>BA</option>
                            <option value="CE" {{ (isset($destinouf) && $destinouf == 'CE') ? 'selected' : '' }}>CE</option>
                            <option value="DF" {{ (isset($destinouf) && $destinouf == 'DF') ? 'selected' : '' }}>DF</option>
                            <option value="ES" {{ (isset($destinouf) && $destinouf == 'ES') ? 'selected' : '' }}>ES</option>
                            <option value="GO" {{ (isset($destinouf) && $destinouf == 'GO') ? 'selected' : '' }}>GO</option>
                            <option value="MA" {{ (isset($destinouf) && $destinouf == 'MA') ? 'selected' : '' }}>MA</option>
                            <option value="MT" {{ (isset($destinouf) && $destinouf == 'MT') ? 'selected' : '' }}>MT</option>
                            <option value="MS" {{ (isset($destinouf) && $destinouf == 'MS') ? 'selected' : '' }}>MS</option>
                            <option value="MG" {{ (isset($destinouf) && $destinouf == 'MG') ? 'selected' : '' }}>MG</option>
                            <option value="PA" {{ (isset($destinouf) && $destinouf == 'PA') ? 'selected' : '' }}>PA</option>
                            <option value="PB" {{ (isset($destinouf) && $destinouf == 'PB') ? 'selected' : '' }}>PB</option>
                            <option value="PR" {{ (isset($destinouf) && $destinouf == 'PR') ? 'selected' : '' }}>PR</option>
                            <option value="PE" {{ (isset($destinouf) && $destinouf == 'PE') ? 'selected' : '' }}>PE</option>
                            <option value="PI" {{ (isset($destinouf) && $destinouf == 'PI') ? 'selected' : '' }}>PI</option>
                            <option value="RJ" {{ (isset($destinouf) && $destinouf == 'RJ') ? 'selected' : '' }}>RJ</option>
                            <option value="RN" {{ (isset($destinouf) && $destinouf == 'RN') ? 'selected' : '' }}>RN</option>
                            <option value="RS" {{ (isset($destinouf) && $destinouf == 'RS') ? 'selected' : '' }}>RS</option>
                            <option value="RO" {{ (isset($destinouf) && $destinouf == 'RO') ? 'selected' : '' }}>RO</option>
                            <option value="RR" {{ (isset($destinouf) && $destinouf == 'RR') ? 'selected' : '' }}>RR</option>
                            <option value="SC" {{ (isset($destinouf) && $destinouf == 'SC') ? 'selected' : '' }}>SC</option>
                            <option value="SP" {{ (isset($destinouf) && $destinouf == 'SP') ? 'selected' : '' }}>SP</option>
                            <option value="SE" {{ (isset($destinouf) && $destinouf == 'SE') ? 'selected' : '' }}>SE</option>
                            <option value="TO" {{ (isset($destinouf) && $destinouf == 'TO') ? 'selected' : '' }}>TO</option>
                        </select>
                        <div class=" selected-value" style="display: none;" onclick="clearSelection(this)">
                            <span class="text"></span>
                            <button type="button"><i class="fa fa-window-close" aria-hidden="true"></i></button>
                        </div>
                    </div>
                </div>


                <div class="col-md-2 col-sm-6 col-xs-6 text-left">

                <button wire:click="applyFilters" class="btn btn-primary btn-round btn-just-icon m-0 btn-xs">
                    <i class="fa fa-search"></i> Buscar
                    <div class="ripple-container"></div>
                </button>

                </div>

            </div>
        </div>
    </div>
</div>

{{-- @push('js')
<script src="https://cdnjs.cloudflare.com/ajax/libs/selectize.js/0.15.2/js/selectize.min.js" integrity="sha512-IOebNkvA/HZjMM7MxL0NYeLYEalloZ8ckak+NDtOViP7oiYzG5vn6WVXyrJDiJPhl4yRdmNAG49iuLmhkUdVsQ==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
<script>
    $(document).ready(function() {
        $('#veiculos').selectize({
            sortField: 'text'
        });
        $('#contratos').selectize({
            sortField: 'text'
        });
        $('#empresas').selectize({
            sortField: 'text'
        });
        $('#origemuf').selectize({
            sortField: 'text'
        });
        $('#destinouf').selectize({
            sortField: 'text'
        });
    });
</script>
@endpush --}}
