<script>
    document.addEventListener('DOMContentLoaded', function () {
        // Inicializa o gráfico com os dados iniciais do Livewire
        var dadosGrafico = @json($GraficoPedidosDieselPorMesJs);
        var ctx = document.getElementById("chart-line").getContext("2d");
        var chart = new Chart(ctx, {
            type: "bar",
            data: {
                labels: dadosGrafico.labels,
                datasets: [{
                    label: "Consumo",
                    tension: 0,
                    pointRadius: 5,
                    pointBackgroundColor: "rgba(229,57,53, .8)",
                    pointBorderColor: "transparent",
                    borderColor: "transparent",
                    borderWidth: 4,
                    backgroundColor: "rgba(73, 83, 97,0.8)",
                    fill: true,
                    data: dadosGrafico.data,
                    maxBarThickness: 30
                }, {
                    label: "Meta do Mês",
                    type: 'line',
                    borderColor: "rgba(73, 83, 97,0.8)",
                    borderWidth: 2,
                    fill: false,
                    data: dadosGrafico.metaData // Garanta que esta propriedade está sendo enviada do backend
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                plugins: {
                    legend: {
                        display: true, // Habilitando a legenda
                    }
                },
                interaction: {
                    intersect: false,
                    mode: 'index',
                },
                scales: {
                    y: {
                        grid: {
                            drawBorder: false,
                            display: true,
                            drawOnChartArea: true,
                            drawTicks: false,
                            borderDash: [5, 5],
                            color: 'rgba(67,160,71, .2)'
                        },
                        ticks: {
                            display: true,
                            color: '#344767',
                            padding: 10,
                            font: {
                                size: 14,
                                weight: 300,
                                family: "Roboto",
                                style: 'normal',
                                lineHeight: 2
                            },
                        }
                    },
                    x: {
                        grid: {
                            drawBorder: false,
                            display: false,
                            drawOnChartArea: false,
                            drawTicks: false,
                            borderDash: [5, 5]
                        },
                        ticks: {
                            display: true,
                            color: '#344767',
                            padding: 10,
                            font: {
                                size: 14,
                                weight: 300,
                                family: "Roboto",
                                style: 'normal',
                                lineHeight: 2
                            },
                        }
                    },
                },
            }
        });

        // Listener para o evento emitido pelo Livewire para atualizar o gráfico
        window.addEventListener('GraficoPedidosDieselPorMesJsAtualizado', function (event) {
            const newData = event.detail.GraficoPedidosDieselPorMesJs;
            
            if (newData) {
                updateChartData(chart, newData);
            }
        });

        // Função para atualizar o gráfico com novos dados
        function updateChartData(chart, newData) {
            chart.data.labels = newData.labels;
            chart.data.datasets[0].data = newData.data;
            chart.data.datasets[1].data = newData.metaData;
            chart.update();
        }
    });



</script>
